/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.PropertySetting;
import mmcorej.StrVector;
import mmcorej.TaggedImage;
import org.json.JSONObject;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.acquisition.AcquisitionManager;
import org.micromanager.acquisition.DefaultTaggedImageSink;
import org.micromanager.acquisition.MMAcquisition;
import org.micromanager.acquisition.ProcessorStack;
import org.micromanager.api.DataProcessor;
import org.micromanager.api.IAcquisitionEngine2010;
import org.micromanager.api.ImageCache;
import org.micromanager.api.PositionList;
import org.micromanager.api.ScriptInterface;
import org.micromanager.api.SequenceSettings;
import org.micromanager.events.EventManager;
import org.micromanager.events.PipelineEvent;
import org.micromanager.events.ProcessorEvent;
import org.micromanager.events.SummaryMetadataEvent;
import org.micromanager.internalinterfaces.AcqSettingsListener;
import org.micromanager.utils.AutofocusManager;
import org.micromanager.utils.ChannelSpec;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.MMException;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class AcquisitionWrapperEngine
implements AcquisitionEngine {
    private CMMCore core_;
    protected ScriptInterface studio_;
    private PositionList posList_;
    private String zstage_;
    private double sliceZStepUm_;
    private double sliceZBottomUm_;
    private double sliceZTopUm_;
    private boolean useSlices_;
    private boolean useFrames_;
    private boolean useChannels_;
    private boolean useMultiPosition_;
    private boolean keepShutterOpenForStack_;
    private boolean keepShutterOpenForChannels_;
    private ArrayList<ChannelSpec> channels_ = new ArrayList();
    private String rootName_;
    private String dirName_;
    private int numFrames_;
    private double interval_;
    private double minZStepUm_;
    private String comment_;
    private boolean saveFiles_;
    private int acqOrderMode_;
    private boolean useAutoFocus_;
    private int afSkipInterval_;
    protected HashMap<String, Class<? extends DataProcessor<TaggedImage>>> nameToProcessorClass_ = new HashMap();
    protected List<DataProcessor<TaggedImage>> taggedImageProcessors_ = new ArrayList<DataProcessor<TaggedImage>>();
    private boolean absoluteZ_;
    private IAcquisitionEngine2010 acquisitionEngine2010;
    private ArrayList<Double> customTimeIntervalsMs_;
    private boolean useCustomIntervals_ = false;
    protected JSONObject summaryMetadata_;
    protected ImageCache imageCache_;
    private ArrayList<AcqSettingsListener> settingsListeners_ = new ArrayList();
    private AcquisitionManager acqManager_;
    private int cameraTimeout_ = 20000;

    public AcquisitionWrapperEngine(AcquisitionManager mgr) {
        this.acqManager_ = mgr;
    }

    @Override
    public String acquire() throws MMException {
        return this.runAcquisition(this.getSequenceSettings(), this.acqManager_);
    }

    @Override
    public void addSettingsListener(AcqSettingsListener listener) {
        this.settingsListeners_.add(listener);
    }

    @Override
    public void removeSettingsListener(AcqSettingsListener listener) {
        this.settingsListeners_.remove(listener);
    }

    public void settingsChanged() {
        for (AcqSettingsListener listener : this.settingsListeners_) {
            listener.settingsChanged();
        }
    }

    protected IAcquisitionEngine2010 getAcquisitionEngine2010() {
        if (this.acquisitionEngine2010 == null) {
            this.acquisitionEngine2010 = this.studio_.getAcquisitionEngine2010();
        }
        return this.acquisitionEngine2010;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String runAcquisition(SequenceSettings acquisitionSettings, AcquisitionManager acqManager) {
        if (this.saveFiles_) {
            File root = new File(this.rootName_);
            if (!root.canWrite()) {
                int result = JOptionPane.showConfirmDialog(null, "The specified root directory\n" + root.getAbsolutePath() + "\ndoes not exist. Create it?", "Directory not found.", 0);
                if (result != 0) {
                    ReportingUtils.showMessage("Acquisition canceled.");
                    return null;
                }
                root.mkdirs();
                if (!root.canWrite()) {
                    ReportingUtils.showError("Unable to save data to selected location: check that location exists.\nAcquisition canceled.");
                    return null;
                }
            } else if (!this.enoughDiskSpace()) {
                ReportingUtils.showError("Not enough space on disk to save the requested image set; acquisition canceled.");
                return null;
            }
        }
        this.studio_.enableLiveMode(false);
        try {
            BlockingQueue<TaggedImage> engineOutputQueue = this.getAcquisitionEngine2010().run(acquisitionSettings, true, this.studio_.getPositionList(), this.studio_.getAutofocusManager().getDevice());
            this.summaryMetadata_ = this.getAcquisitionEngine2010().getSummaryMetadata();
            EventManager.post(new SummaryMetadataEvent(this.summaryMetadata_));
            BlockingQueue<TaggedImage> procStackOutputQueue = ProcessorStack.run(engineOutputQueue, this.taggedImageProcessors_);
            String acqName = acqManager.createAcquisition(this.summaryMetadata_, acquisitionSettings.save, this, this.studio_.getHideMDADisplayOption());
            MMAcquisition acq = acqManager.getAcquisition(acqName);
            this.imageCache_ = acq.getImageCache();
            DefaultTaggedImageSink sink = new DefaultTaggedImageSink(procStackOutputQueue, this.imageCache_);
            sink.start(new Runnable(){

                @Override
                public void run() {
                    AcquisitionWrapperEngine.this.getAcquisitionEngine2010().stop();
                }
            });
            return acqName;
        }
        catch (Throwable ex) {
            ReportingUtils.showError(ex);
            return null;
        }
    }

    private int getNumChannels() {
        int numChannels = 0;
        if (this.useChannels_) {
            for (ChannelSpec channel : this.channels_) {
                if (!channel.useChannel) continue;
                ++numChannels;
            }
        } else {
            numChannels = 1;
        }
        return numChannels;
    }

    @Override
    public int getNumFrames() {
        int numFrames = this.numFrames_;
        if (!this.useFrames_) {
            numFrames = 1;
        }
        return numFrames;
    }

    private int getNumPositions() {
        int numPositions = Math.max(1, this.posList_.getNumberOfPositions());
        if (!this.useMultiPosition_) {
            numPositions = 1;
        }
        return numPositions;
    }

    private int getNumSlices() {
        if (!this.useSlices_) {
            return 1;
        }
        if (this.sliceZStepUm_ == 0.0) {
            return Integer.MAX_VALUE;
        }
        return 1 + (int)Math.abs((this.sliceZTopUm_ - this.sliceZBottomUm_) / this.sliceZStepUm_);
    }

    private int getTotalImages() {
        int totalImages = this.getNumFrames() * this.getNumSlices() * this.getNumChannels() * this.getNumPositions();
        return totalImages;
    }

    private long getTotalMB() {
        CMMCore core = this.studio_.getMMCore();
        long totalMB = core.getImageWidth() * core.getImageHeight() * core.getBytesPerPixel() * (long)this.getTotalImages() / 0x100000L;
        return totalMB;
    }

    private void updateChannelCameras() {
        for (ChannelSpec channel : this.channels_) {
            channel.camera = this.getSource(channel);
        }
    }

    @Override
    public void attachRunnable(int frame, int position, int channel, int slice, Runnable runnable) {
        this.getAcquisitionEngine2010().attachRunnable(frame, position, channel, slice, runnable);
    }

    @Override
    public void clearRunnables() {
        this.getAcquisitionEngine2010().clearRunnables();
    }

    private String getSource(ChannelSpec channel) {
        try {
            Configuration state = this.core_.getConfigState(this.core_.getChannelGroup(), channel.config);
            if (state.isPropertyIncluded("Core", "Camera")) {
                return state.getSetting("Core", "Camera").getPropertyValue();
            }
            return "";
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
            return "";
        }
    }

    @Override
    public void addImageProcessor(DataProcessor<TaggedImage> taggedImageProcessor) {
        if (!this.taggedImageProcessors_.contains(taggedImageProcessor)) {
            this.taggedImageProcessors_.add(taggedImageProcessor);
            EventManager.post(new PipelineEvent(this.taggedImageProcessors_));
        }
    }

    @Override
    public void removeImageProcessor(DataProcessor<TaggedImage> taggedImageProcessor) {
        this.taggedImageProcessors_.remove(taggedImageProcessor);
        taggedImageProcessor.dispose();
        EventManager.post(new PipelineEvent(this.taggedImageProcessors_));
    }

    @Override
    public void setImageProcessorPipeline(List<DataProcessor<TaggedImage>> pipeline) {
        this.taggedImageProcessors_.clear();
        this.taggedImageProcessors_.addAll(pipeline);
        EventManager.post(new PipelineEvent(this.taggedImageProcessors_));
    }

    @Override
    public ArrayList<DataProcessor<TaggedImage>> getImageProcessorPipeline() {
        return new ArrayList<DataProcessor<TaggedImage>>(this.taggedImageProcessors_);
    }

    @Override
    public void registerProcessorClass(Class<? extends DataProcessor<TaggedImage>> processorClass, String name) {
        if (this.nameToProcessorClass_.get(name) != null) {
            ReportingUtils.logError("Tried to register an additional DataProcessor under the name \"" + name + "\"; ignoring it.");
        } else {
            this.nameToProcessorClass_.put(name, processorClass);
            EventManager.post(new ProcessorEvent(name, processorClass));
        }
    }

    @Override
    public List<String> getSortedDataProcessorNames() {
        Set<String> keys = this.nameToProcessorClass_.keySet();
        ArrayList<String> sortedKeys = new ArrayList<String>();
        sortedKeys.addAll(keys);
        Collections.sort(sortedKeys);
        return sortedKeys;
    }

    @Override
    public DataProcessor<TaggedImage> makeProcessor(String name, ScriptInterface gui) {
        DataProcessor<TaggedImage> newProcessor;
        Class<? extends DataProcessor<TaggedImage>> processorClass = this.nameToProcessorClass_.get(name);
        try {
            newProcessor = processorClass.newInstance();
            newProcessor.setApp(gui);
            this.addImageProcessor(newProcessor);
        }
        catch (Exception ex) {
            ReportingUtils.logError("Failed to create processor " + name + " mapped to class " + processorClass + ": " + ex);
            newProcessor = null;
        }
        return newProcessor;
    }

    @Override
    public DataProcessor<TaggedImage> getProcessorRegisteredAs(String name) {
        Class<? extends DataProcessor<TaggedImage>> processorClass = this.nameToProcessorClass_.get(name);
        for (DataProcessor<TaggedImage> processor : this.taggedImageProcessors_) {
            if (processor.getClass() != processorClass) continue;
            return processor;
        }
        return null;
    }

    @Override
    public String getNameForProcessorClass(Class<? extends DataProcessor<TaggedImage>> processorClass) {
        for (String name : this.nameToProcessorClass_.keySet()) {
            if (this.nameToProcessorClass_.get(name) != processorClass) continue;
            return name;
        }
        return null;
    }

    @Override
    public void disposeProcessors() {
        for (DataProcessor<TaggedImage> processor : this.taggedImageProcessors_) {
            processor.dispose();
        }
    }

    public SequenceSettings getSequenceSettings() {
        SequenceSettings acquisitionSettings = new SequenceSettings();
        this.updateChannelCameras();
        if (this.useFrames_) {
            if (this.useCustomIntervals_ && this.customTimeIntervalsMs_ != null) {
                acquisitionSettings.customIntervalsMs = this.customTimeIntervalsMs_;
                acquisitionSettings.numFrames = acquisitionSettings.customIntervalsMs.size();
            } else {
                acquisitionSettings.numFrames = this.numFrames_;
                acquisitionSettings.intervalMs = this.interval_;
            }
        } else {
            acquisitionSettings.numFrames = 0;
        }
        if (this.useSlices_) {
            double start = this.sliceZBottomUm_;
            double stop = this.sliceZTopUm_;
            double step = Math.abs(this.sliceZStepUm_);
            if (step == 0.0) {
                throw new UnsupportedOperationException("zero Z step size");
            }
            int count = this.getNumSlices();
            if (start > stop) {
                step = -step;
            }
            for (int i = 0; i < count; ++i) {
                acquisitionSettings.slices.add(start + (double)i * step);
            }
        }
        acquisitionSettings.relativeZSlice = !this.absoluteZ_;
        try {
            String zdrive = this.core_.getFocusDevice();
            acquisitionSettings.zReference = zdrive.length() > 0 ? this.core_.getPosition(this.core_.getFocusDevice()) : 0.0;
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
        }
        if (this.useChannels_) {
            for (ChannelSpec channel : this.channels_) {
                if (!channel.useChannel) continue;
                acquisitionSettings.channels.add(channel);
            }
            acquisitionSettings.channelGroup = this.core_.getChannelGroup();
        }
        acquisitionSettings.timeFirst = this.acqOrderMode_ == 3 || this.acqOrderMode_ == 2;
        acquisitionSettings.slicesFirst = this.acqOrderMode_ == 3 || this.acqOrderMode_ == 1;
        acquisitionSettings.useAutofocus = this.useAutoFocus_;
        acquisitionSettings.skipAutofocusCount = this.afSkipInterval_;
        acquisitionSettings.keepShutterOpenChannels = this.keepShutterOpenForChannels_;
        acquisitionSettings.keepShutterOpenSlices = this.keepShutterOpenForStack_;
        acquisitionSettings.save = this.saveFiles_;
        if (this.saveFiles_) {
            acquisitionSettings.root = this.rootName_;
            acquisitionSettings.prefix = this.dirName_;
        }
        acquisitionSettings.comment = this.comment_;
        acquisitionSettings.usePositionList = this.useMultiPosition_;
        acquisitionSettings.cameraTimeout = this.cameraTimeout_;
        return acquisitionSettings;
    }

    public void setSequenceSettings(SequenceSettings ss) {
        this.updateChannelCameras();
        this.useFrames_ = true;
        if (ss.customIntervalsMs != null && ss.customIntervalsMs.size() > 0) {
            this.useCustomIntervals_ = true;
            this.customTimeIntervalsMs_ = ss.customIntervalsMs;
            this.numFrames_ = ss.customIntervalsMs.size();
        } else {
            this.useCustomIntervals_ = false;
            this.numFrames_ = ss.numFrames;
            this.interval_ = ss.intervalMs;
        }
        this.useSlices_ = true;
        if (ss.slices.size() == 0) {
            this.useSlices_ = false;
        } else if (ss.slices.size() == 1) {
            this.sliceZTopUm_ = this.sliceZBottomUm_ = ss.slices.get(0).doubleValue();
            this.sliceZStepUm_ = 0.0;
        } else {
            this.sliceZBottomUm_ = ss.slices.get(0);
            this.sliceZTopUm_ = ss.slices.get(ss.slices.size() - 1);
            this.sliceZStepUm_ = ss.slices.get(1) - ss.slices.get(0);
            if (this.sliceZBottomUm_ > this.sliceZBottomUm_) {
                this.sliceZStepUm_ = -this.sliceZStepUm_;
            }
        }
        this.absoluteZ_ = !ss.relativeZSlice;
        this.useChannels_ = ss.channels.size() > 0;
        this.channels_ = ss.channels;
        if (ss.timeFirst && ss.slicesFirst) {
            this.acqOrderMode_ = 3;
        }
        if (ss.timeFirst && !ss.slicesFirst) {
            this.acqOrderMode_ = 2;
        }
        if (!ss.timeFirst && ss.slicesFirst) {
            this.acqOrderMode_ = 1;
        }
        if (!ss.timeFirst && !ss.slicesFirst) {
            this.acqOrderMode_ = 0;
        }
        this.useAutoFocus_ = ss.useAutofocus;
        this.afSkipInterval_ = ss.skipAutofocusCount;
        this.keepShutterOpenForChannels_ = ss.keepShutterOpenChannels;
        this.keepShutterOpenForStack_ = ss.keepShutterOpenSlices;
        this.saveFiles_ = ss.save;
        this.rootName_ = ss.root;
        this.dirName_ = ss.prefix;
        this.comment_ = ss.comment;
        this.useMultiPosition_ = ss.usePositionList;
        this.cameraTimeout_ = ss.cameraTimeout;
    }

    @Override
    public void stop(boolean interrupted) {
        try {
            if (this.acquisitionEngine2010 != null) {
                this.acquisitionEngine2010.stop();
            }
        }
        catch (Exception ex) {
            ReportingUtils.showError((Throwable)ex, "Acquisition engine stop request failed");
        }
    }

    @Override
    public boolean abortRequest() {
        Object[] options;
        int result;
        if (this.isAcquisitionRunning() && (result = JOptionPane.showOptionDialog(null, "Abort current acquisition task?", "Micro-Manager", -1, 3, null, options = new String[]{"Abort", "Cancel"}, options[1])) == 0) {
            this.stop(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean abortRequested() {
        return this.acquisitionEngine2010.stopHasBeenRequested();
    }

    @Override
    public void shutdown() {
        this.stop(true);
    }

    @Override
    public void setPause(boolean state) {
        if (state) {
            this.acquisitionEngine2010.pause();
        } else {
            this.acquisitionEngine2010.resume();
        }
    }

    @Override
    public boolean isAcquisitionRunning() {
        if (this.acquisitionEngine2010 != null) {
            return this.acquisitionEngine2010.isRunning();
        }
        return false;
    }

    @Override
    public boolean isFinished() {
        if (this.acquisitionEngine2010 != null) {
            return this.acquisitionEngine2010.isFinished();
        }
        return false;
    }

    @Override
    public boolean isMultiFieldRunning() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long getNextWakeTime() {
        return this.acquisitionEngine2010.nextWakeTime();
    }

    @Override
    public void setCore(CMMCore core_, AutofocusManager afMgr) {
        this.core_ = core_;
    }

    @Override
    public void setPositionList(PositionList posList) {
        this.posList_ = posList;
    }

    @Override
    public void setParentGUI(ScriptInterface parent) {
        this.studio_ = parent;
    }

    @Override
    public void setZStageDevice(String stageLabel_) {
        this.zstage_ = stageLabel_;
    }

    @Override
    public void setUpdateLiveWindow(boolean b) {
    }

    @Override
    public void setFinished() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getCurrentFrameCount() {
        return 0;
    }

    @Override
    public double getFrameIntervalMs() {
        return this.interval_;
    }

    @Override
    public double getSliceZStepUm() {
        return this.sliceZStepUm_;
    }

    @Override
    public double getSliceZBottomUm() {
        return this.sliceZBottomUm_;
    }

    @Override
    public void setChannel(int row, ChannelSpec channel) {
        this.channels_.set(row, channel);
    }

    @Override
    public String getFirstConfigGroup() {
        if (this.core_ == null) {
            return "";
        }
        String[] groups = this.getAvailableGroups();
        if (groups == null || groups.length < 1) {
            return "";
        }
        return this.getAvailableGroups()[0];
    }

    @Override
    public String[] getChannelConfigs() {
        if (this.core_ == null) {
            return new String[0];
        }
        return this.core_.getAvailableConfigs(this.core_.getChannelGroup()).toArray();
    }

    @Override
    public String getChannelGroup() {
        return this.core_.getChannelGroup();
    }

    @Override
    public boolean setChannelGroup(String group) {
        if (this.groupIsEligibleChannel(group)) {
            try {
                this.core_.setChannelGroup(group);
            }
            catch (Exception e) {
                try {
                    this.core_.setChannelGroup("");
                }
                catch (Exception ex) {
                    ReportingUtils.showError(ex);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.channels_ != null) {
            this.channels_.clear();
        }
        this.numFrames_ = 0;
    }

    @Override
    public void setFrames(int numFrames, double interval) {
        this.numFrames_ = numFrames;
        this.interval_ = interval;
    }

    @Override
    public double getMinZStepUm() {
        return this.minZStepUm_;
    }

    @Override
    public void setSlices(double bottom, double top, double step, boolean absolute) {
        this.sliceZBottomUm_ = bottom;
        this.sliceZTopUm_ = top;
        this.sliceZStepUm_ = step;
        this.absoluteZ_ = absolute;
        this.settingsChanged();
    }

    @Override
    public boolean getZAbsoluteMode() {
        return this.absoluteZ_;
    }

    @Override
    public boolean isFramesSettingEnabled() {
        return this.useFrames_;
    }

    @Override
    public void enableFramesSetting(boolean enable) {
        this.useFrames_ = enable;
    }

    @Override
    public boolean isChannelsSettingEnabled() {
        return this.useChannels_;
    }

    @Override
    public void enableChannelsSetting(boolean enable) {
        this.useChannels_ = enable;
    }

    @Override
    public boolean isZSliceSettingEnabled() {
        return this.useSlices_;
    }

    @Override
    public double getZTopUm() {
        return this.sliceZTopUm_;
    }

    @Override
    public void keepShutterOpenForStack(boolean open) {
        this.keepShutterOpenForStack_ = open;
    }

    @Override
    public boolean isShutterOpenForStack() {
        return this.keepShutterOpenForStack_;
    }

    @Override
    public void keepShutterOpenForChannels(boolean open) {
        this.keepShutterOpenForChannels_ = open;
    }

    @Override
    public boolean isShutterOpenForChannels() {
        return this.keepShutterOpenForChannels_;
    }

    @Override
    public void enableZSliceSetting(boolean boolean1) {
        this.useSlices_ = boolean1;
    }

    @Override
    public void enableMultiPosition(boolean selected) {
        this.useMultiPosition_ = selected;
    }

    @Override
    public boolean isMultiPositionEnabled() {
        return this.useMultiPosition_;
    }

    @Override
    public ArrayList<ChannelSpec> getChannels() {
        return this.channels_;
    }

    @Override
    public void setChannels(ArrayList<ChannelSpec> channels) {
        this.channels_ = channels;
    }

    @Override
    public String getRootName() {
        return this.rootName_;
    }

    @Override
    public void setRootName(String absolutePath) {
        this.rootName_ = absolutePath;
    }

    @Override
    public void setCameraConfig(String cfg) {
    }

    @Override
    public void setDirName(String text) {
        this.dirName_ = text;
    }

    @Override
    public void setComment(String text) {
        this.comment_ = text;
        this.settingsChanged();
    }

    @Override
    public boolean addChannel(String config, double exp, Boolean doZStack, double zOffset, ContrastSettings con8, ContrastSettings con16, int skip, Color c, boolean use) {
        return this.addChannel(config, exp, doZStack, zOffset, con8, skip, c, use);
    }

    @Override
    public boolean addChannel(String config, double exp, Boolean doZStack, double zOffset, ContrastSettings con, int skip, Color c, boolean use) {
        if (this.isConfigAvailable(config)) {
            ChannelSpec channel = new ChannelSpec();
            channel.config = config;
            channel.useChannel = use;
            channel.exposure = exp;
            channel.doZStack = doZStack;
            channel.zOffset = zOffset;
            channel.contrast = con;
            channel.color = c;
            channel.skipFactorFrame = skip;
            this.channels_.add(channel);
            return true;
        }
        ReportingUtils.logError("\"" + config + "\" is not found in the current Channel group.");
        return false;
    }

    @Override
    public boolean addChannel(String config, double exp, double zOffset, ContrastSettings c8, ContrastSettings c16, int skip, Color c) {
        return this.addChannel(config, exp, true, zOffset, c16, skip, c, true);
    }

    @Override
    public void setSaveFiles(boolean selected) {
        this.saveFiles_ = selected;
    }

    @Override
    public boolean getSaveFiles() {
        return this.saveFiles_;
    }

    @Override
    public void setDisplayMode(int mode) {
    }

    @Override
    public int getAcqOrderMode() {
        return this.acqOrderMode_;
    }

    @Override
    public int getDisplayMode() {
        return 0;
    }

    @Override
    public void setAcqOrderMode(int mode) {
        this.acqOrderMode_ = mode;
    }

    @Override
    public void enableAutoFocus(boolean enabled) {
        this.useAutoFocus_ = enabled;
    }

    @Override
    public boolean isAutoFocusEnabled() {
        return this.useAutoFocus_;
    }

    @Override
    public int getAfSkipInterval() {
        return this.afSkipInterval_;
    }

    @Override
    public void setAfSkipInterval(int interval) {
        this.afSkipInterval_ = interval;
    }

    public void setParameterPreferences(Preferences prefs) {
    }

    @Override
    public void setSingleFrame(boolean selected) {
    }

    @Override
    public void setSingleWindow(boolean selected) {
    }

    @Override
    public String installAutofocusPlugin(String className) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected boolean enoughDiskSpace() {
        File root = new File(this.rootName_);
        while (!root.exists()) {
            if ((root = root.getParentFile()) != null) continue;
            return false;
        }
        long usableMB = root.getUsableSpace() / 0x100000L;
        return 1.25 * (double)this.getTotalMB() < (double)usableMB;
    }

    @Override
    public String getVerboseSummary() {
        int numFrames = this.getNumFrames();
        int numSlices = this.getNumSlices();
        int numPositions = this.getNumPositions();
        int numChannels = this.getNumChannels();
        int totalImages = this.getTotalImages();
        long totalMB = this.getTotalMB();
        double totalDurationSec = 0.0;
        if (!this.useCustomIntervals_ || this.customTimeIntervalsMs_ == null) {
            totalDurationSec = this.interval_ * (double)numFrames / 1000.0;
        } else {
            for (Double d : this.customTimeIntervalsMs_) {
                totalDurationSec += d / 1000.0;
            }
        }
        int hrs = (int)(totalDurationSec / 3600.0);
        double remainSec = totalDurationSec - (double)(hrs * 3600);
        int mins = (int)(remainSec / 60.0);
        String txt = "Number of time points: " + (!this.useCustomIntervals_ ? numFrames : this.customTimeIntervalsMs_.size()) + "\nNumber of positions: " + numPositions + "\nNumber of slices: " + numSlices + "\nNumber of channels: " + numChannels + "\nTotal images: " + totalImages + "\nTotal memory: " + (totalMB <= 1024L ? totalMB + " MB" : NumberUtils.doubleToDisplayString((double)totalMB / 1024.0) + " GB") + "\nDuration: " + hrs + "h " + mins + "m " + NumberUtils.doubleToDisplayString(remainSec -= (double)(mins * 60)) + "s";
        if (this.useFrames_ || this.useMultiPosition_ || this.useChannels_ || this.useSlices_) {
            StringBuffer order = new StringBuffer("\nOrder: ");
            if (this.useFrames_ && this.useMultiPosition_) {
                if (this.acqOrderMode_ == 1 || this.acqOrderMode_ == 0) {
                    order.append("Time, Position");
                } else {
                    order.append("Position, Time");
                }
            } else if (this.useFrames_) {
                order.append("Time");
            } else if (this.useMultiPosition_) {
                order.append("Position");
            }
            if ((this.useFrames_ || this.useMultiPosition_) && (this.useChannels_ || this.useSlices_)) {
                order.append(", ");
            }
            if (this.useChannels_ && this.useSlices_) {
                if (this.acqOrderMode_ == 1 || this.acqOrderMode_ == 3) {
                    order.append("Channel, Slice");
                } else {
                    order.append("Slice, Channel");
                }
            } else if (this.useChannels_) {
                order.append("Channel");
            } else if (this.useSlices_) {
                order.append("Slice");
            }
            return txt + order.toString();
        }
        return txt;
    }

    @Override
    public boolean isConfigAvailable(String config) {
        StrVector vcfgs = this.core_.getAvailableConfigs(this.core_.getChannelGroup());
        int i = 0;
        while ((long)i < vcfgs.size()) {
            if (config.compareTo(vcfgs.get(i)) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String[] getCameraConfigs() {
        if (this.core_ == null) {
            return new String[0];
        }
        return this.core_.getAvailableConfigs("Camera").toArray();
    }

    @Override
    public String[] getAvailableGroups() {
        StrVector groups;
        try {
            groups = this.core_.getAllowedPropertyValues("Core", "ChannelGroup");
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
            return new String[0];
        }
        ArrayList<String> strGroups = new ArrayList<String>();
        for (String group : groups) {
            if (!this.groupIsEligibleChannel(group)) continue;
            strGroups.add(group);
        }
        return strGroups.toArray(new String[0]);
    }

    @Override
    public double getCurrentZPos() {
        if (this.isFocusStageAvailable()) {
            double z = 0.0;
            try {
                z = this.core_.getPosition(this.core_.getFocusDevice());
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
            }
            return z;
        }
        return 0.0;
    }

    @Override
    public boolean isPaused() {
        return this.acquisitionEngine2010.isPaused();
    }

    public void restoreSystem() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected boolean isFocusStageAvailable() {
        return this.zstage_ != null && this.zstage_.length() > 0;
    }

    private boolean groupIsEligibleChannel(String group) {
        StrVector cfgs = this.core_.getAvailableConfigs(group);
        if (cfgs.size() == 1L) {
            try {
                String propName;
                PropertySetting setting;
                String devLabel;
                Configuration presetData = this.core_.getConfigData(group, cfgs.get(0));
                if (presetData.size() == 1L && this.core_.hasPropertyLimits(devLabel = (setting = presetData.getSetting(0L)).getDeviceLabel(), propName = setting.getPropertyName())) {
                    return false;
                }
            }
            catch (Exception ex) {
                ReportingUtils.logError(ex);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<DataProcessor<TaggedImage>> getImageProcessors() {
        return this.taggedImageProcessors_;
    }

    @Override
    public void setCustomTimeIntervals(double[] customTimeIntervals) {
        if (customTimeIntervals == null || customTimeIntervals.length == 0) {
            this.customTimeIntervalsMs_ = null;
            this.enableCustomTimeIntervals(false);
        } else {
            this.enableCustomTimeIntervals(true);
            this.customTimeIntervalsMs_ = new ArrayList();
            for (double d : customTimeIntervals) {
                this.customTimeIntervalsMs_.add(d);
            }
        }
    }

    @Override
    public double[] getCustomTimeIntervals() {
        if (this.customTimeIntervalsMs_ == null) {
            return null;
        }
        double[] intervals = new double[this.customTimeIntervalsMs_.size()];
        for (int i = 0; i < this.customTimeIntervalsMs_.size(); ++i) {
            intervals[i] = this.customTimeIntervalsMs_.get(i);
        }
        return intervals;
    }

    @Override
    public void enableCustomTimeIntervals(boolean enable) {
        this.useCustomIntervals_ = enable;
    }

    @Override
    public boolean customTimeIntervalsEnabled() {
        return this.useCustomIntervals_;
    }

    @Override
    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    @Override
    public ImageCache getImageCache() {
        return this.imageCache_;
    }

    @Override
    public String getComment() {
        return this.comment_;
    }
}

