/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.gui.ImageWindow;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.prefs.Preferences;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.acquisition.MMAcquisition;
import org.micromanager.api.ImageCache;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class AcquisitionManager {
    private static final String ALBUM_WIN_X = "album_x";
    private static final String ALBUM_WIN_Y = "album_y";
    Hashtable<String, MMAcquisition> acqs_ = new Hashtable();
    private String album_ = null;

    public void openAcquisition(String name, String rootDir) throws MMScriptException {
        if (this.acquisitionExists(name)) {
            throw new MMScriptException("The name is in use");
        }
        MMAcquisition acq = new MMAcquisition(name, rootDir);
        this.acqs_.put(name, acq);
    }

    public void openAcquisition(String name, String rootDir, boolean show) throws MMScriptException {
        this.openAcquisition(name, rootDir, show, false);
    }

    public void openAcquisition(String name, String rootDir, boolean show, boolean diskCached) throws MMScriptException {
        this.openAcquisition(name, rootDir, show, diskCached, false);
    }

    public void openAcquisition(String name, String rootDir, boolean show, boolean diskCached, boolean existing) throws MMScriptException {
        if (this.acquisitionExists(name)) {
            throw new MMScriptException("The name is in use");
        }
        this.acqs_.put(name, new MMAcquisition(name, rootDir, show, diskCached, existing));
    }

    public void closeAcquisition(final String name) throws MMScriptException {
        if (name == null) {
            return;
        }
        final MMScriptException[] ex = new MMScriptException[]{null};
        try {
            GUIUtils.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (!AcquisitionManager.this.acqs_.containsKey(name)) {
                        ex[0] = new MMScriptException("The acquisition named \"" + name + "\" does not exist");
                    } else {
                        AcquisitionManager.this.acqs_.get(name).close();
                        AcquisitionManager.this.acqs_.remove(name);
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
    }

    public boolean closeImageWindow(String name) throws MMScriptException {
        if (!this.acquisitionExists(name)) {
            throw new MMScriptException("The name does not exist");
        }
        return this.acqs_.get(name).closeImageWindow();
    }

    public boolean closeAllImageWindows() throws MMScriptException {
        String[] acqNames;
        for (String acqName : acqNames = this.getAcquisitionNames()) {
            if (this.closeImageWindow(acqName)) continue;
            return false;
        }
        return true;
    }

    public boolean acquisitionExists(String name) {
        if (this.acqs_.containsKey(name)) {
            MMAcquisition acq = this.acqs_.get(name);
            if (acq.getShow() && acq.windowClosed()) {
                acq.close();
                this.acqs_.remove(name);
                return false;
            }
            return true;
        }
        return false;
    }

    public MMAcquisition getAcquisition(String name) throws MMScriptException {
        if (this.acquisitionExists(name)) {
            return this.acqs_.get(name);
        }
        throw new MMScriptException("Undefined acquisition name: " + name);
    }

    public void closeAll() {
        Enumeration<MMAcquisition> e = this.acqs_.elements();
        while (e.hasMoreElements()) {
            e.nextElement().close();
        }
        this.acqs_.clear();
    }

    public String getUniqueAcquisitionName(String name) {
        char separator = '_';
        while (this.acquisitionExists(name)) {
            int lastSeparator = name.lastIndexOf(separator);
            if (lastSeparator == -1) {
                name = name + separator + "1";
                continue;
            }
            try {
                Integer i;
                Integer n = i = Integer.valueOf(Integer.parseInt(name.substring(lastSeparator + 1)));
                Integer n2 = i = Integer.valueOf(i + 1);
                name = name.substring(0, lastSeparator) + separator + i;
            }
            catch (NumberFormatException e) {
                name = name + separator + "1";
            }
        }
        return name;
    }

    public String getCurrentAlbum() {
        if (this.album_ == null) {
            return this.createNewAlbum();
        }
        return this.album_;
    }

    public String createNewAlbum() {
        this.album_ = this.getUniqueAcquisitionName("Album");
        return this.album_;
    }

    public String addToAlbum(TaggedImage image, JSONObject displaySettings) throws MMScriptException {
        int numChannels;
        int imageBitDepth;
        int imageDepth;
        int imageHeight;
        int imageWidth;
        boolean newNeeded = true;
        MMAcquisition acq = null;
        String album = this.getCurrentAlbum();
        JSONObject tags = image.tags;
        try {
            imageWidth = MDUtils.getWidth(tags);
            imageHeight = MDUtils.getHeight(tags);
            imageDepth = MDUtils.getDepth(tags);
            imageBitDepth = MDUtils.getBitDepth(tags);
            numChannels = MDUtils.getNumChannels(tags);
        }
        catch (Exception e) {
            throw new MMScriptException("Something wrong with image tags.");
        }
        if (this.acquisitionExists(album)) {
            acq = this.acqs_.get(album);
            try {
                if (acq.getWidth() == imageWidth && acq.getHeight() == imageHeight && acq.getByteDepth() == imageDepth && acq.getMultiCameraNumChannels() == numChannels && !acq.getImageCache().isFinished()) {
                    newNeeded = false;
                }
            }
            catch (Exception e) {
                ReportingUtils.logError(e, "Couldn't check if we need a new album");
            }
        }
        if (newNeeded) {
            album = this.createNewAlbum();
            this.openAcquisition(album, "", true, false);
            acq = this.getAcquisition(album);
            boolean mustHackDims = false;
            try {
                mustHackDims = numChannels > 1 || MDUtils.getNumberOfComponents(image.tags) > 1;
            }
            catch (JSONException ex) {
                ReportingUtils.logError(ex, "Unable to determine number of components of image");
            }
            acq.setDimensions(mustHackDims ? 2 : 1, numChannels, 1, 1);
            acq.setImagePhysicalDimensions(imageWidth, imageHeight, imageDepth, imageBitDepth, numChannels);
            try {
                JSONObject summary = new JSONObject();
                MDUtils.setPixelTypeFromString(summary, MDUtils.getPixelType(tags));
                acq.setSummaryProperties(summary);
            }
            catch (JSONException ex) {
                ReportingUtils.logError(ex);
            }
            acq.initialize();
            final ImageWindow win = acq.getAcquisitionWindow().getImagePlus().getWindow();
            final Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            win.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Point loc = win.getLocation();
                    prefs.putInt(AcquisitionManager.ALBUM_WIN_X, loc.x);
                    prefs.putInt(AcquisitionManager.ALBUM_WIN_Y, loc.y);
                }
            });
            win.setLocation(prefs.getInt(ALBUM_WIN_X, 0), prefs.getInt(ALBUM_WIN_Y, 0));
        }
        int newImageFrame = acq.getLastAcquiredFrame() + 1;
        if (numChannels > 1) {
            try {
                JSONObject lastTags = acq.getImageCache().getLastImageTags();
                int lastCh = -1;
                if (lastTags != null) {
                    lastCh = MDUtils.getChannelIndex(lastTags);
                }
                if (lastCh == 0) {
                    newImageFrame = acq.getLastAcquiredFrame();
                }
            }
            catch (JSONException ex) {
                ReportingUtils.logError(ex);
            }
        }
        try {
            MDUtils.setFrameIndex(tags, newImageFrame);
        }
        catch (JSONException ex) {
            ReportingUtils.showError(ex);
        }
        try {
            acq.getSummaryMetadata().put("Frames", newImageFrame + 1);
        }
        catch (JSONException ex) {
            ReportingUtils.logError("Couldn't update number of frames in album summary metadata");
        }
        acq.insertImage(image);
        if (numChannels == 1) {
            try {
                if (MDUtils.getFrameIndex(tags) == 0 && displaySettings != null) {
                    this.copyDisplaySettings(acq, displaySettings);
                }
            }
            catch (JSONException ex) {
                ReportingUtils.logError(ex);
            }
        } else {
            try {
                if (numChannels > 1 && MDUtils.getChannelIndex(tags) == numChannels - 1 && acq.getLastAcquiredFrame() == 0 && displaySettings != null) {
                    this.copyDisplaySettings(acq, displaySettings);
                }
            }
            catch (JSONException ex) {
                ReportingUtils.logError(ex);
            }
        }
        return album;
    }

    private void copyDisplaySettings(MMAcquisition acq, JSONObject displaySettings) {
        if (displaySettings == null) {
            return;
        }
        ImageCache ic = acq.getImageCache();
        for (int i = 0; i < ic.getNumDisplayChannels(); ++i) {
            try {
                JSONObject channelSetting = (JSONObject)((JSONArray)displaySettings.get("Channels")).get(i);
                int color = channelSetting.getInt("Color");
                int min = channelSetting.getInt("Min");
                int max = channelSetting.getInt("Max");
                double gamma = channelSetting.getDouble("Gamma");
                String name = channelSetting.getString("Name");
                int histMax = channelSetting.has("HistogramMax") ? channelSetting.getInt("HistogramMax") : -1;
                int displayMode = 1;
                if (channelSetting.has("DisplayMode")) {
                    displayMode = channelSetting.getInt("DisplayMode");
                }
                ic.storeChannelDisplaySettings(i, min, max, gamma, histMax, displayMode);
                acq.getAcquisitionWindow().setChannelHistogramDisplayMax(i, histMax);
                acq.getAcquisitionWindow().setChannelContrast(i, min, max, gamma);
                acq.getAcquisitionWindow().setDisplayMode(displayMode);
                acq.setChannelColor(i, color);
                acq.setChannelName(i, name);
                continue;
            }
            catch (JSONException ex) {
                ReportingUtils.logError("Something wrong with Display and Comments");
                continue;
            }
            catch (MMScriptException e) {
                ReportingUtils.logError(e);
            }
        }
    }

    public String[] getAcquisitionNames() {
        Set<String> keySet = this.acqs_.keySet();
        String[] keys = new String[keySet.size()];
        return keySet.toArray(keys);
    }

    public String createAcquisition(JSONObject summaryMetadata, boolean diskCached, AcquisitionEngine engine, boolean displayOff) {
        String name = this.getUniqueAcquisitionName("Acq");
        this.acqs_.put(name, new MMAcquisition(name, summaryMetadata, diskCached, engine, !displayOff));
        return name;
    }
}

