/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import com.google.common.eventbus.Subscribe;
import mmcorej.CMMCore;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.micromanager.MainFrame;
import org.micromanager.api.events.PixelSizeChangedEvent;
import org.micromanager.api.events.StagePositionChangedEvent;
import org.micromanager.api.events.XYStagePositionChangedEvent;
import org.micromanager.events.EventManager;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.TextUtils;

class StaticInfo {
    public static long width_;
    public static long height_;
    public static long bytesPerPixel_;
    public static long imageBitDepth_;
    public static double pixSizeUm_;
    public static double zPos_;
    public static double x_;
    public static double y_;
    public static String cameraLabel_;
    public static String shutterLabel_;
    public static String xyStageLabel_;
    public static String zStageLabel_;
    private static CMMCore core_;
    private static MainFrame frame_;

    public StaticInfo(CMMCore core, MainFrame frame) {
        core_ = core;
        frame_ = frame;
        EventManager.register(this);
    }

    public void updateXYPos(double x, double y) {
        x_ = x;
        y_ = y;
        this.updateInfoDisplay();
    }

    public void updateXYPosRelative(double x, double y) {
        x_ += x;
        y_ += y;
        this.updateInfoDisplay();
    }

    public void getNewXYStagePosition() {
        double[] x = new double[1];
        double[] y = new double[1];
        try {
            if (xyStageLabel_.length() > 0) {
                core_.getXYPosition(xyStageLabel_, x, y);
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
        this.updateXYPos(x[0], y[0]);
    }

    public void updateZPos(double z) {
        zPos_ = z;
        this.updateInfoDisplay();
    }

    public void updateZPosRelative(double z) {
        zPos_ += z;
        this.updateInfoDisplay();
    }

    @Subscribe
    public void onPixelSizeChanged(PixelSizeChangedEvent event) {
        pixSizeUm_ = event.getNewPixelSizeUm();
        this.updateInfoDisplay();
    }

    @Subscribe
    public void onStagePositionChanged(StagePositionChangedEvent event) {
        this.updateZPos(event.getPos());
    }

    @Subscribe
    public void onXYStagePositionChanged(XYStagePositionChangedEvent event) {
        this.updateXYPos(event.getXPos(), event.getYPos());
    }

    public void refreshValues() {
        try {
            cameraLabel_ = core_.getCameraDevice();
            shutterLabel_ = core_.getShutterDevice();
            zStageLabel_ = core_.getFocusDevice();
            xyStageLabel_ = core_.getXYStageDevice();
            double zPos = 0.0;
            double[] x = new double[1];
            double[] y = new double[1];
            try {
                if (zStageLabel_.length() > 0) {
                    zPos = core_.getPosition(zStageLabel_);
                }
                if (xyStageLabel_.length() > 0) {
                    core_.getXYPosition(xyStageLabel_, x, y);
                }
            }
            catch (Exception e) {
                ReportingUtils.showError((Throwable)e, "Failed to get stage position");
            }
            width_ = core_.getImageWidth();
            height_ = core_.getImageHeight();
            bytesPerPixel_ = core_.getBytesPerPixel();
            imageBitDepth_ = core_.getImageBitDepth();
            pixSizeUm_ = core_.getPixelSizeUm();
            zPos_ = zPos;
            x_ = x[0];
            y_ = y[0];
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
        this.updateInfoDisplay();
    }

    public void updateInfoDisplay() {
        String text = "Image info (from camera): " + width_ + " X " + height_ + " X " + bytesPerPixel_ + ", Intensity range: " + imageBitDepth_ + " bits";
        text = text + ", " + TextUtils.FMT0.format(pixSizeUm_ * 1000.0) + "nm/pix";
        if (zStageLabel_.length() > 0) {
            text = text + ", Z=" + TextUtils.FMT2.format(zPos_) + "um";
        }
        if (xyStageLabel_.length() > 0) {
            text = text + ", XY=(" + TextUtils.FMT2.format(x_) + "," + TextUtils.FMT2.format(y_) + ")um";
        }
        frame_.updateInfoDisplay(text);
    }

    public void addStagePositionToTags(TaggedImage ti) throws JSONException {
        if (xyStageLabel_.length() > 0) {
            MDUtils.setXPositionUm(ti.tags, x_);
            MDUtils.setYPositionUm(ti.tags, y_);
        }
        if (zStageLabel_.length() > 0) {
            MDUtils.setZPositionUm(ti.tags, zPos_);
        }
    }

    static {
        cameraLabel_ = "";
        shutterLabel_ = "";
        xyStageLabel_ = "";
        zStageLabel_ = "";
    }
}

