/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import ij.gui.ImageWindow;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mmcorej.CMMCore;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.MMStudio;
import org.micromanager.acquisition.LiveModeTimer;
import org.micromanager.acquisition.MMAcquisition;
import org.micromanager.api.ImageCache;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.internalinterfaces.LiveModeListener;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.WaitDialog;

public class SnapLiveManager {
    private final MMStudio studio_;
    private final CMMCore core_;
    private LiveModeTimer liveModeTimer_;
    private final List<LiveModeListener> liveModeListeners_ = Collections.synchronizedList(new ArrayList());
    private static VirtualAcquisitionDisplay display_;
    public static final String SIMPLE_ACQ = "Snap/Live Window";
    private final Color[] multiCameraColors_ = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.CYAN};

    public SnapLiveManager(MMStudio studio, CMMCore core) {
        this.studio_ = studio;
        this.core_ = core;
    }

    public void safeSetCoreExposure(double exposureTime) {
        boolean isOn = this.getIsLiveModeOn();
        if (isOn) {
            this.setLiveMode(false);
        }
        try {
            this.core_.setExposure(exposureTime);
        }
        catch (Exception e) {
            ReportingUtils.logError(e, "Failed to set core exposure time.");
        }
        if (isOn) {
            this.setLiveMode(true);
        }
    }

    public boolean getIsLiveModeOn() {
        return this.liveModeTimer_ != null && this.liveModeTimer_.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLiveMode(boolean isOn) {
        if (isOn == this.getIsLiveModeOn()) {
            return;
        }
        if (isOn && this.liveModeTimer_ == null) {
            if (this.core_.getCameraDevice().length() == 0) {
                ReportingUtils.showError("No camera configured.");
            }
            this.liveModeTimer_ = new LiveModeTimer();
        }
        if (this.liveModeTimer_ != null) {
            if (isOn) {
                WaitDialog waitDlg = new WaitDialog("Starting Live...");
                waitDlg.setAlwaysOnTop(true);
                waitDlg.showDialog();
                try {
                    this.liveModeTimer_.begin();
                    this.callLiveModeListeners(true);
                }
                catch (Exception e) {
                    waitDlg.closeDialog();
                    ReportingUtils.showError((Throwable)e, "Couldn't start live mode.");
                    waitDlg = new WaitDialog("Stopping Live...");
                    waitDlg.setAlwaysOnTop(true);
                    waitDlg.showDialog();
                    this.liveModeTimer_.stop();
                    this.callLiveModeListeners(false);
                }
                finally {
                    waitDlg.closeDialog();
                }
            } else {
                WaitDialog waitDlg = new WaitDialog("Stopping Live...");
                waitDlg.setAlwaysOnTop(true);
                waitDlg.showDialog();
                this.liveModeTimer_.stop();
                this.callLiveModeListeners(false);
                waitDlg.closeDialog();
            }
        }
    }

    public final void addLiveModeListener(LiveModeListener listener) {
        if (this.liveModeListeners_.contains(listener)) {
            return;
        }
        this.liveModeListeners_.add(listener);
    }

    public void removeLiveModeListener(LiveModeListener listener) {
        this.liveModeListeners_.remove(listener);
    }

    public void callLiveModeListeners(boolean enable) {
        for (LiveModeListener listener : this.liveModeListeners_) {
            listener.liveModeEnabled(enable);
        }
    }

    public void createSnapLiveDisplay(String name, ImageCache cache) {
        try {
            display_ = new VirtualAcquisitionDisplay(cache, name);
        }
        catch (MMScriptException e) {
            ReportingUtils.logError(e, "Failed to create Snap/Live display");
        }
    }

    public VirtualAcquisitionDisplay getSnapLiveDisplay() {
        return display_;
    }

    public ImageWindow getSnapLiveWindow() {
        if (display_ != null && display_.getHyperImage() != null) {
            return display_.getHyperImage().getWindow();
        }
        return null;
    }

    public void moveDisplayToFront() {
        ImageWindow window = this.getSnapLiveWindow();
        if (window != null) {
            window.toFront();
        }
    }

    public void validateDisplayAndAcquisition(int width, int height, int depth, int bitDepth, int numCamChannels) {
        try {
            if (this.studio_.acquisitionExists(SIMPLE_ACQ).booleanValue() && (this.studio_.getAcquisitionImageWidth(SIMPLE_ACQ) != width || this.studio_.getAcquisitionImageHeight(SIMPLE_ACQ) != height || this.studio_.getAcquisitionImageByteDepth(SIMPLE_ACQ) != depth || this.studio_.getAcquisitionImageBitDepth(SIMPLE_ACQ) != bitDepth || this.studio_.getAcquisitionMultiCamNumChannels(SIMPLE_ACQ) != numCamChannels)) {
                this.studio_.closeAcquisitionWindow(SIMPLE_ACQ);
            }
            if (!this.studio_.acquisitionExists(SIMPLE_ACQ).booleanValue()) {
                this.studio_.openAcquisition(SIMPLE_ACQ, "", 1, numCamChannels, 1, true);
                if (numCamChannels > 1) {
                    for (long i = 0L; i < (long)numCamChannels; ++i) {
                        String chName = this.core_.getCameraChannelName(i);
                        int defaultColor = this.multiCameraColors_[(int)i % this.multiCameraColors_.length].getRGB();
                        this.studio_.setChannelColor(SIMPLE_ACQ, (int)i, this.studio_.getChannelColor(chName, defaultColor));
                        this.studio_.setChannelName(SIMPLE_ACQ, (int)i, chName);
                    }
                }
                this.initializeAcquisition(width, height, depth, bitDepth, numCamChannels);
                this.studio_.getAcquisition(SIMPLE_ACQ).promptToSave(false);
                display_ = this.studio_.getAcquisition(SIMPLE_ACQ).getAcquisitionWindow();
                this.getSnapLiveWindow().toFront();
                this.studio_.updateCenterAndDragListener();
            }
        }
        catch (MMScriptException ex) {
            ReportingUtils.showError(ex);
        }
    }

    public void validateDisplayAndAcquisition(TaggedImage image) {
        JSONObject tags = image.tags;
        try {
            int width = MDUtils.getWidth(tags);
            int height = MDUtils.getHeight(tags);
            int depth = MDUtils.getDepth(tags);
            int bitDepth = MDUtils.getBitDepth(tags);
            int numCamChannels = (int)this.core_.getNumberOfCameraChannels();
            this.validateDisplayAndAcquisition(width, height, depth, bitDepth, numCamChannels);
        }
        catch (JSONException ex) {
            ReportingUtils.showError("Error extracting image info in validateDisplayAndAcquisition: " + ex);
        }
        catch (MMScriptException ex) {
            ReportingUtils.showError("Error extracting image info in validateDisplayAndAcquisition: " + ex);
        }
    }

    public void validateDisplayAndAcquisition() {
        if (this.core_.getCameraDevice().length() == 0) {
            ReportingUtils.showError("No camera configured");
            return;
        }
        int width = (int)this.core_.getImageWidth();
        int height = (int)this.core_.getImageHeight();
        int depth = (int)this.core_.getBytesPerPixel();
        int bitDepth = (int)this.core_.getImageBitDepth();
        int numCamChannels = (int)this.core_.getNumberOfCameraChannels();
        this.validateDisplayAndAcquisition(width, height, depth, bitDepth, numCamChannels);
    }

    private void initializeAcquisition(int width, int height, int byteDepth, int bitDepth, int numMultiCamChannels) throws MMScriptException {
        MMAcquisition acq = this.studio_.getAcquisitionWithName(SIMPLE_ACQ);
        acq.setImagePhysicalDimensions(width, height, byteDepth, bitDepth, numMultiCamChannels);
        acq.initializeSimpleAcq();
    }

    public boolean displayImage(Object pixels) {
        this.validateDisplayAndAcquisition();
        try {
            MMAcquisition acquisition = this.studio_.getAcquisition(SIMPLE_ACQ);
            int width = acquisition.getWidth();
            int height = acquisition.getHeight();
            int byteDepth = acquisition.getByteDepth();
            TaggedImage ti = ImageUtils.makeTaggedImage(pixels, 0, 0, 0, 0, width, height, byteDepth);
            try {
                display_.getImageCache().putImage(ti);
            }
            catch (IOException e) {
                ReportingUtils.logError(e, "This should never happen!");
            }
            display_.imageReceived(ti);
            return true;
        }
        catch (MMScriptException ex) {
            ReportingUtils.showError(ex);
            return false;
        }
        catch (MMException ex) {
            ReportingUtils.showError(ex);
            return false;
        }
    }

    public void displayTaggedImage(TaggedImage image) {
        this.validateDisplayAndAcquisition(image);
    }

    public void setStatusLine(String status) {
        display_.displayStatusLine(status);
    }

    public void snapAndAddToImage5D() {
        if (this.core_.getCameraDevice().length() == 0) {
            ReportingUtils.showError("No camera configured");
            return;
        }
        try {
            if (this.getIsLiveModeOn()) {
                ImageCache cache = display_.getImageCache();
                int channels = cache.getSummaryMetadata().getInt("Channels");
                for (int i = 0; i < channels; ++i) {
                    this.studio_.addToAlbum(cache.getImage(i, 0, 0, 0), cache.getDisplayAndComments());
                }
            } else {
                this.studio_.doSnap(true);
            }
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
        }
        catch (MMScriptException ex) {
            ReportingUtils.logError(ex);
        }
    }
}

