/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import com.swtdesigner.SwingResourceManager;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.border.BevelBorder;
import javax.swing.table.TableColumn;
import mmcorej.CMMCore;
import mmcorej.StrVector;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMFrame;
import org.micromanager.utils.MMListenerAdapter;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.PropertyNameCellRenderer;
import org.micromanager.utils.PropertyTableData;
import org.micromanager.utils.PropertyValueCellEditor;
import org.micromanager.utils.PropertyValueCellRenderer;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.ShowFlags;

public class PropertyEditor
extends MMFrame {
    private final SpringLayout springLayout;
    private static final long serialVersionUID = 1507097881635431043L;
    private JTable table_;
    private PropertyEditorTableData data_;
    private ShowFlags flags_;
    private static final String PREF_SHOW_READONLY = "show_readonly";
    private JCheckBox showCamerasCheckBox_;
    private JCheckBox showShuttersCheckBox_;
    private JCheckBox showStagesCheckBox_;
    private JCheckBox showStateDevicesCheckBox_;
    private JCheckBox showOtherCheckBox_;
    private JCheckBox showReadonlyCheckBox_;
    private final JScrollPane scrollPane_;
    private ScriptInterface gui_;
    private final myMMListener myMMListener_ = new myMMListener();

    public void setGui(ScriptInterface gui) {
        this.gui_ = gui;
        this.gui_.addMMListener(this.myMMListener_);
    }

    public PropertyEditor() {
        this.flags_ = new ShowFlags();
        this.flags_.load(this.getPrefsNode());
        this.setIconImage(SwingResourceManager.getImage(PropertyEditor.class, "icons/microscope.gif"));
        this.springLayout = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout);
        this.setSize(551, 514);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Preferences prefs = PropertyEditor.this.getPrefsNode();
                prefs.putBoolean(PropertyEditor.PREF_SHOW_READONLY, PropertyEditor.this.showReadonlyCheckBox_.isSelected());
                PropertyEditor.this.flags_.save(PropertyEditor.this.getPrefsNode());
            }

            @Override
            public void windowOpened(WindowEvent e) {
                Preferences prefs = PropertyEditor.this.getPrefsNode();
                PropertyEditor.this.showReadonlyCheckBox_.setSelected(prefs.getBoolean(PropertyEditor.PREF_SHOW_READONLY, true));
                PropertyEditor.this.data_.update(false);
                PropertyEditor.this.data_.fireTableStructureChanged();
            }
        });
        this.setTitle("Device Property Browser");
        this.loadAndRestorePosition(100, 100, 400, 300);
        this.setDefaultCloseOperation(3);
        this.scrollPane_ = new JScrollPane();
        this.scrollPane_.setFont(new Font("Arial", 0, 10));
        this.scrollPane_.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.scrollPane_);
        this.springLayout.putConstraint("East", (Component)this.scrollPane_, -5, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.scrollPane_, 5, "West", (Component)this.getContentPane());
        this.table_ = new JTable();
        this.table_.setAutoCreateColumnsFromModel(false);
        JButton refreshButton = new JButton();
        refreshButton.setIcon(SwingResourceManager.getIcon(PropertyEditor.class, "/org/micromanager/icons/arrow_refresh.png"));
        refreshButton.setFont(new Font("Arial", 0, 10));
        this.getContentPane().add(refreshButton);
        this.springLayout.putConstraint("East", (Component)refreshButton, 285, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)refreshButton, 185, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)refreshButton, 32, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)refreshButton, 9, "North", (Component)this.getContentPane());
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.refresh();
            }
        });
        refreshButton.setText("Refresh! ");
        this.showReadonlyCheckBox_ = new JCheckBox();
        this.showReadonlyCheckBox_.setFont(new Font("Arial", 0, 10));
        this.showReadonlyCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.data_.setShowReadOnly(PropertyEditor.this.showReadonlyCheckBox_.isSelected());
                PropertyEditor.this.data_.update(false);
                PropertyEditor.this.data_.fireTableStructureChanged();
            }
        });
        this.showReadonlyCheckBox_.setText("Show read-only properties");
        this.getContentPane().add(this.showReadonlyCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showReadonlyCheckBox_, 358, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showReadonlyCheckBox_, 185, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showReadonlyCheckBox_, 63, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.showReadonlyCheckBox_, 40, "North", (Component)this.getContentPane());
        Preferences prefs = this.getPrefsNode();
        this.showReadonlyCheckBox_.setSelected(prefs.getBoolean(PREF_SHOW_READONLY, true));
        this.showCamerasCheckBox_ = new JCheckBox();
        this.showCamerasCheckBox_.setFont(new Font("", 0, 10));
        this.showCamerasCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((PropertyEditor)PropertyEditor.this).flags_.cameras_ = PropertyEditor.this.showCamerasCheckBox_.isSelected();
                PropertyEditor.this.data_.update(false);
            }
        });
        this.showCamerasCheckBox_.setText("Show cameras");
        this.getContentPane().add(this.showCamerasCheckBox_);
        this.springLayout.putConstraint("South", (Component)this.showCamerasCheckBox_, 28, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showCamerasCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.showCamerasCheckBox_, 111, "West", (Component)this.getContentPane());
        this.showShuttersCheckBox_ = new JCheckBox();
        this.showShuttersCheckBox_.setFont(new Font("", 0, 10));
        this.showShuttersCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((PropertyEditor)PropertyEditor.this).flags_.shutters_ = PropertyEditor.this.showShuttersCheckBox_.isSelected();
                PropertyEditor.this.data_.update(false);
            }
        });
        this.showShuttersCheckBox_.setText("Show shutters");
        this.getContentPane().add(this.showShuttersCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showShuttersCheckBox_, 111, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showShuttersCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showShuttersCheckBox_, 50, "North", (Component)this.getContentPane());
        this.showStagesCheckBox_ = new JCheckBox();
        this.showStagesCheckBox_.setFont(new Font("", 0, 10));
        this.showStagesCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((PropertyEditor)PropertyEditor.this).flags_.stages_ = PropertyEditor.this.showStagesCheckBox_.isSelected();
                PropertyEditor.this.data_.update(false);
            }
        });
        this.showStagesCheckBox_.setText("Show stages");
        this.getContentPane().add(this.showStagesCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showStagesCheckBox_, 111, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showStagesCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showStagesCheckBox_, 73, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.showStagesCheckBox_, 50, "North", (Component)this.getContentPane());
        this.showStateDevicesCheckBox_ = new JCheckBox();
        this.showStateDevicesCheckBox_.setFont(new Font("", 0, 10));
        this.showStateDevicesCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((PropertyEditor)PropertyEditor.this).flags_.state_ = PropertyEditor.this.showStateDevicesCheckBox_.isSelected();
                PropertyEditor.this.data_.update(false);
            }
        });
        this.showStateDevicesCheckBox_.setText("Show discrete changers");
        this.getContentPane().add(this.showStateDevicesCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showStateDevicesCheckBox_, 200, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showStateDevicesCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showStateDevicesCheckBox_, 95, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.showStateDevicesCheckBox_, 72, "North", (Component)this.getContentPane());
        this.showOtherCheckBox_ = new JCheckBox();
        this.showOtherCheckBox_.setFont(new Font("", 0, 10));
        this.showOtherCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((PropertyEditor)PropertyEditor.this).flags_.other_ = PropertyEditor.this.showOtherCheckBox_.isSelected();
                PropertyEditor.this.data_.update(false);
            }
        });
        this.showOtherCheckBox_.setText("Show other devices");
        this.getContentPane().add(this.showOtherCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showOtherCheckBox_, 155, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showOtherCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.showOtherCheckBox_, 95, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.scrollPane_, -5, "South", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.scrollPane_, 5, "South", (Component)this.showOtherCheckBox_);
    }

    protected void refresh() {
        this.data_.gui_ = this.gui_;
        this.data_.flags_ = this.flags_;
        this.data_.showUnused_ = true;
        this.data_.refresh(false);
    }

    public void updateStatus() {
        if (this.data_ != null) {
            this.data_.update(false);
        }
    }

    public void setCore(CMMCore core) {
        this.data_ = new PropertyEditorTableData(core, "", "", 1, 2, this.getContentPane());
        this.data_.gui_ = this.gui_;
        this.data_.flags_ = this.flags_;
        this.data_.showUnused_ = true;
        this.data_.setColumnNames("Property", "Value", "");
        this.table_ = new JTable();
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setModel(this.data_);
        this.scrollPane_.setViewportView(this.table_);
        this.table_.addColumn(new TableColumn(0, 200, new PropertyNameCellRenderer(), null));
        this.table_.addColumn(new TableColumn(1, 200, new PropertyValueCellRenderer(false), new PropertyValueCellEditor(false)));
        this.showCamerasCheckBox_.setSelected(this.flags_.cameras_);
        this.showStagesCheckBox_.setSelected(this.flags_.stages_);
        this.showShuttersCheckBox_.setSelected(this.flags_.shutters_);
        this.showStateDevicesCheckBox_.setSelected(this.flags_.state_);
        this.showOtherCheckBox_.setSelected(this.flags_.other_);
        this.data_.setShowReadOnly(this.showReadonlyCheckBox_.isSelected());
    }

    private void handleException(Exception e) {
        ReportingUtils.showError((Throwable)e, (Component)this);
    }

    public class PropertyEditorTableData
    extends PropertyTableData {
        private static final long serialVersionUID = 1L;

        public PropertyEditorTableData(CMMCore core, String groupName, String presetName, int PropertyValueColumn, int PropertyUsedColumn, Component parentComponent) {
            super(core, groupName, presetName, PropertyValueColumn, PropertyUsedColumn, false);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            PropertyItem item = (PropertyItem)this.propListVisible_.get(row);
            this.gui_.logMessage("Setting value " + value + " at row " + row);
            if (col == this.PropertyValueColumn_) {
                this.setValueInCore(item, value);
            }
            this.core_.updateSystemStateCache();
            this.refresh(true);
            this.gui_.refreshGUIFromCache();
            this.fireTableCellUpdated(row, col);
        }

        public void update(String device, String propName, String newValue) {
            PropertyItem item = this.getItem(device, propName);
            if (item != null) {
                item.value = newValue;
                this.fireTableDataChanged();
            }
        }

        @Override
        public void update(ShowFlags flags, String groupName, String presetName, boolean fromCache) {
            try {
                StrVector devices = this.core_.getLoadedDevices();
                this.propList_.clear();
                boolean liveMode = this.gui_.isLiveModeOn();
                if (!fromCache) {
                    this.gui_.enableLiveMode(false);
                }
                int i = 0;
                while ((long)i < devices.size()) {
                    if (PropertyEditor.this.data_.showDevice(flags, devices.get(i)).booleanValue()) {
                        StrVector properties = this.core_.getDevicePropertyNames(devices.get(i));
                        int j = 0;
                        while ((long)j < properties.size()) {
                            PropertyItem item = new PropertyItem();
                            item.readFromCore(this.core_, devices.get(i), properties.get(j), fromCache);
                            if (!(item.readOnly && !this.showReadOnly_ || item.preInit)) {
                                this.propList_.add(item);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                this.updateRowVisibility(flags);
                if (!fromCache) {
                    this.gui_.enableLiveMode(liveMode);
                }
            }
            catch (Exception e) {
                PropertyEditor.this.handleException(e);
            }
            this.fireTableStructureChanged();
        }
    }

    public class myMMListener
    extends MMListenerAdapter {
        @Override
        public void propertiesChangedAlert() {
            if (!PropertyEditor.this.data_.updating()) {
                PropertyEditor.this.refresh();
            }
        }

        @Override
        public void propertyChangedAlert(String device, String property, String value) {
            PropertyEditor.this.data_.update(device, property, value);
        }
    }
}

