/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import com.google.common.eventbus.Subscribe;
import com.swtdesigner.SwingResourceManager;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import org.micromanager.ConfigGroupPad;
import org.micromanager.ConfigPadButtonPanel;
import org.micromanager.MMStudio;
import org.micromanager.SnapLiveManager;
import org.micromanager.StaticInfo;
import org.micromanager.api.events.ConfigGroupChangedEvent;
import org.micromanager.diagnostics.ThreadExceptionLogger;
import org.micromanager.events.EventManager;
import org.micromanager.imagedisplay.MetadataPanel;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.internalinterfaces.LiveModeListener;
import org.micromanager.utils.DragDropUtil;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.MMFrame;
import org.micromanager.utils.MMKeyDispatcher;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class MainFrame
extends MMFrame
implements LiveModeListener {
    private static final String MICRO_MANAGER_TITLE = "Micro-Manager";
    private static final String MAIN_FRAME_DIVIDER_POS = "divider_pos";
    private static final String MAIN_EXPOSURE = "exposure";
    private JComboBox comboBinning_;
    private JComboBox shutterComboBox_;
    private JTextField textFieldExp_;
    private JLabel labelImageDimensions_;
    private JToggleButton liveButton_;
    private JCheckBox autoShutterCheckBox_;
    private JButton snapButton_;
    private JButton autofocusNowButton_;
    private JButton autofocusConfigureButton_;
    private JButton saveConfigButton_;
    private JToggleButton toggleShutterButton_;
    private ConfigGroupPad configPad_;
    private final Font defaultFont_ = new Font("Arial", 0, 10);
    private final CMMCore core_;
    private final MMStudio studio_;
    private final SnapLiveManager snapLiveManager_;
    private ConfigPadButtonPanel configPadButtonPanel_;
    private final MetadataPanel metadataPanel_;
    private final JSplitPane splitPane_;
    private AbstractButton setRoiButton_;
    private AbstractButton clearRoiButton_;

    public MainFrame(MMStudio studio, CMMCore core, SnapLiveManager manager, Preferences prefs) {
        super("main_");
        ThreadExceptionLogger.setUp();
        this.studio_ = studio;
        this.core_ = core;
        this.snapLiveManager_ = manager;
        this.snapLiveManager_.addLiveModeListener(this);
        this.setTitle("Micro-Manager 1.4.x dev");
        this.setMinimumSize(new Dimension(605, 480));
        this.splitPane_ = this.createSplitPane(prefs.getInt(MAIN_FRAME_DIVIDER_POS, 200));
        this.getContentPane().add(this.splitPane_);
        this.createTopPanelWidgets((JPanel)this.splitPane_.getComponent(0));
        this.metadataPanel_ = MainFrame.createMetadataPanel((JPanel)this.splitPane_.getComponent(1));
        this.setDefaultCloseOperation(0);
        this.setupWindowHandlers();
        EventManager.register(this);
        MMKeyDispatcher mmKD = new MMKeyDispatcher();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(mmKD);
        DropTarget dropTarget = new DropTarget(this, new DragDropUtil());
        this.setVisible(true);
    }

    private void setupWindowHandlers() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MainFrame.this.studio_.closeSequence(false);
            }
        });
    }

    public void loadApplicationPrefs(Preferences prefs, boolean shouldCloseOnExit) {
        this.loadAndRestorePosition(100, 100, 644, 570);
        this.setExitStrategy(shouldCloseOnExit);
    }

    public void paintToFront() {
        this.toFront();
        this.paint(this.getGraphics());
    }

    public void initializeConfigPad() {
        this.configPad_.setCore(this.core_);
        this.configPad_.setParentGUI(this.studio_);
        this.configPadButtonPanel_.setCore(this.core_);
    }

    private static JLabel createLabel(String text, boolean big, JPanel parentPanel, int west, int north, int east, int south) {
        JLabel label = new JLabel();
        label.setFont(new Font("Arial", big ? 1 : 0, big ? 11 : 10));
        label.setText(text);
        GUIUtils.addWithEdges(parentPanel, label, west, north, east, south);
        return label;
    }

    private void createActiveShutterChooser(JPanel topPanel) {
        MainFrame.createLabel("Shutter", false, topPanel, 111, 73, 158, 86);
        this.shutterComboBox_ = new JComboBox();
        this.shutterComboBox_.setName("Shutter");
        this.shutterComboBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (MainFrame.this.shutterComboBox_.getSelectedItem() != null) {
                        MainFrame.this.core_.setShutterDevice((String)MainFrame.this.shutterComboBox_.getSelectedItem());
                    }
                }
                catch (Exception e) {
                    ReportingUtils.showError(e);
                }
            }
        });
        GUIUtils.addWithEdges(topPanel, this.shutterComboBox_, 170, 70, 275, 92);
    }

    private void createBinningChooser(JPanel topPanel) {
        MainFrame.createLabel("Binning", false, topPanel, 111, 43, 199, 64);
        this.comboBinning_ = new JComboBox();
        this.comboBinning_.setName("Binning");
        this.comboBinning_.setFont(this.defaultFont_);
        this.comboBinning_.setMaximumRowCount(4);
        this.comboBinning_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.studio_.changeBinning();
            }
        });
        GUIUtils.addWithEdges(topPanel, this.comboBinning_, 200, 43, 275, 66);
    }

    private void createExposureField(JPanel topPanel) {
        MainFrame.createLabel("Exposure [ms]", false, topPanel, 111, 23, 198, 39);
        this.textFieldExp_ = new JTextField();
        this.textFieldExp_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent fe) {
                MainFrame.this.studio_.setExposure(MainFrame.this.getDisplayedExposureTime());
            }
        });
        this.textFieldExp_.setFont(this.defaultFont_);
        this.textFieldExp_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.studio_.setExposure(MainFrame.this.getDisplayedExposureTime());
            }
        });
        GUIUtils.addWithEdges(topPanel, this.textFieldExp_, 203, 21, 276, 40);
    }

    private void createShutterControls(JPanel topPanel) {
        this.autoShutterCheckBox_ = new JCheckBox();
        this.autoShutterCheckBox_.setFont(this.defaultFont_);
        this.autoShutterCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.studio_.toggleAutoShutter();
            }
        });
        this.autoShutterCheckBox_.setIconTextGap(6);
        this.autoShutterCheckBox_.setHorizontalTextPosition(10);
        this.autoShutterCheckBox_.setText("Auto shutter");
        GUIUtils.addWithEdges(topPanel, this.autoShutterCheckBox_, 107, 96, 199, 119);
        this.toggleShutterButton_ = (JToggleButton)GUIUtils.createButton(true, "toggleShutterButton", "Open", "Open/close the shutter", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.toggleShutter();
            }
        }, null, topPanel, 203, 96, 275, 117);
    }

    private void createCameraSettingsWidgets(JPanel topPanel) {
        MainFrame.createLabel("Camera settings", true, topPanel, 109, 2, 211, 22);
        this.createExposureField(topPanel);
        this.createBinningChooser(topPanel);
        this.createActiveShutterChooser(topPanel);
        this.createShutterControls(topPanel);
    }

    private void createConfigurationControls(JPanel topPanel) {
        MainFrame.createLabel("Configuration settings", true, topPanel, 280, 2, 430, 22);
        this.saveConfigButton_ = (JButton)GUIUtils.createButton(false, "saveConfigureButton", "Save", "Save current presets to the configuration file", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.studio_.saveConfigPresets();
            }
        }, null, topPanel, -80, 2, -5, 20);
        this.configPad_ = new ConfigGroupPad();
        this.configPadButtonPanel_ = new ConfigPadButtonPanel();
        this.configPadButtonPanel_.setConfigPad(this.configPad_);
        this.configPadButtonPanel_.setGUI(this.studio_);
        this.configPad_.setFont(this.defaultFont_);
        GUIUtils.addWithEdges(topPanel, this.configPad_, 280, 21, -4, -44);
        GUIUtils.addWithEdges(topPanel, this.configPadButtonPanel_, 280, -40, -4, -20);
    }

    private void createCommonActionButtons(JPanel topPanel) {
        this.snapButton_ = (JButton)GUIUtils.createButton(false, "Snap", "Snap", "Snap single image", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.studio_.doSnap();
            }
        }, "camera.png", topPanel, 7, 4, 95, 25);
        this.liveButton_ = (JToggleButton)GUIUtils.createButton(true, "Live", "Live", "Continuous live view", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.studio_.enableLiveMode(!MainFrame.this.studio_.isLiveModeOn());
            }
        }, "camera_go.png", topPanel, 7, 26, 95, 47);
        GUIUtils.createButton(false, "Album", "Album", "Acquire single frame and add to an album", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.snapLiveManager_.snapAndAddToImage5D();
            }
        }, "camera_plus_arrow.png", topPanel, 7, 48, 95, 69);
        GUIUtils.createButton(false, "Multi-D Acq.", "Multi-D Acq.", "Open multi-dimensional acquisition window", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.studio_.openAcqControlDialog();
            }
        }, "film.png", topPanel, 7, 70, 95, 91);
        GUIUtils.createButton(false, "Refresh", "Refresh", "Refresh all GUI controls directly from the hardware", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.core_.updateSystemStateCache();
                MainFrame.this.studio_.updateGUI(true);
            }
        }, "arrow_refresh.png", topPanel, 7, 92, 95, 113);
    }

    private static MetadataPanel createMetadataPanel(JPanel bottomPanel) {
        MetadataPanel metadataPanel = new MetadataPanel();
        GUIUtils.addWithEdges(bottomPanel, metadataPanel, 0, 0, 0, 0);
        metadataPanel.setBorder(BorderFactory.createEmptyBorder());
        return metadataPanel;
    }

    private void createPleaLabel(JPanel topPanel) {
        JLabel citePleaLabel = new JLabel("<html>Please <a href=\"http://micro-manager.org\">cite Micro-Manager</a> so funding will continue!</html>");
        citePleaLabel.setFont(new Font("Arial", 0, 11));
        GUIUtils.addWithEdges(topPanel, citePleaLabel, 7, 119, 270, 139);
        citePleaLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                new Thread(GUIUtils.makeURLRunnable("https://micro-manager.org/wiki/Citing_Micro-Manager")).start();
            }
        });
    }

    private JSplitPane createSplitPane(int dividerPos) {
        JPanel topPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        topPanel.setLayout(new SpringLayout());
        topPanel.setMinimumSize(new Dimension(580, 195));
        bottomPanel.setLayout(new SpringLayout());
        JSplitPane splitPane = new JSplitPane(0, true, topPanel, bottomPanel);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setDividerLocation(dividerPos);
        splitPane.setResizeWeight(0.0);
        return splitPane;
    }

    private void createTopPanelWidgets(JPanel topPanel) {
        this.createCommonActionButtons(topPanel);
        this.createCameraSettingsWidgets(topPanel);
        this.createPleaLabel(topPanel);
        this.createUtilityButtons(topPanel);
        this.createConfigurationControls(topPanel);
        this.labelImageDimensions_ = MainFrame.createLabel("", false, topPanel, 5, -20, 0, 0);
    }

    private void createUtilityButtons(JPanel topPanel) {
        MainFrame.createLabel("ROI", true, topPanel, 8, 140, 71, 154);
        this.setRoiButton_ = GUIUtils.createButton(false, "setRoiButton", null, "Set Region Of Interest to selected rectangle", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.studio_.setROI();
            }
        }, "shape_handles.png", topPanel, 7, 154, 37, 174);
        this.clearRoiButton_ = GUIUtils.createButton(false, "clearRoiButton", null, "Reset Region of Interest to full frame", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.studio_.clearROI();
            }
        }, "arrow_out.png", topPanel, 40, 154, 70, 174);
        MainFrame.createLabel("Zoom", true, topPanel, 81, 140, 139, 154);
        GUIUtils.createButton(false, "zoomInButton", null, "Zoom in", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.zoomIn();
            }
        }, "zoom_in.png", topPanel, 80, 154, 110, 174);
        GUIUtils.createButton(false, "zoomOutButton", null, "Zoom out", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.zoomOut();
            }
        }, "zoom_out.png", topPanel, 113, 154, 143, 174);
        MainFrame.createLabel("Profile", true, topPanel, 154, 140, 217, 154);
        GUIUtils.createButton(false, "lineProfileButton", null, "Open line profile window (requires line selection)", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.studio_.openLineProfileWindow();
            }
        }, "chart_curve.png", topPanel, 153, 154, 183, 174);
        MainFrame.createLabel("Autofocus", true, topPanel, 194, 140, 276, 154);
        this.autofocusNowButton_ = (JButton)GUIUtils.createButton(false, "autofocusNowButton", null, "Autofocus now", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.studio_.autofocusNow();
            }
        }, "find.png", topPanel, 193, 154, 223, 174);
        this.autofocusConfigureButton_ = (JButton)GUIUtils.createButton(false, "autofocusConfigureButton", null, "Set autofocus options", new Runnable(){

            @Override
            public void run() {
                MainFrame.this.studio_.showAutofocusDialog();
            }
        }, "wrench_orange.png", topPanel, 226, 154, 256, 174);
    }

    public void updateTitle(String configFile) {
        this.setTitle("Micro-Manager 1.4.x dev - " + configFile);
    }

    public final void setExitStrategy(boolean closeOnExit) {
        if (closeOnExit) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(2);
        }
    }

    protected void setConfigSaveButtonStatus(boolean changed) {
        this.saveConfigButton_.setEnabled(changed);
    }

    public void updateInfoDisplay(String text) {
        this.labelImageDimensions_.setText(text);
    }

    public void setShutterButton(boolean state) {
        if (state) {
            this.toggleShutterButton_.setText("Close");
        } else {
            this.toggleShutterButton_.setText("Open");
        }
    }

    public void toggleShutter() {
        try {
            if (!this.toggleShutterButton_.isEnabled()) {
                return;
            }
            this.toggleShutterButton_.requestFocusInWindow();
            if (this.toggleShutterButton_.getText().equals("Open")) {
                this.setShutterButton(true);
                this.core_.setShutterOpen(true);
            } else {
                this.core_.setShutterOpen(false);
                this.setShutterButton(false);
            }
        }
        catch (Exception e1) {
            ReportingUtils.showError(e1);
        }
    }

    public void toggleAutoShutter(boolean enabled) {
        StaticInfo.shutterLabel_ = this.core_.getShutterDevice();
        if (StaticInfo.shutterLabel_.length() == 0) {
            this.setToggleShutterButtonEnabled(false);
        } else {
            this.setToggleShutterButtonEnabled(enabled);
            try {
                this.setShutterButton(this.core_.getShutterOpen());
            }
            catch (Exception ex) {
                ReportingUtils.logError(ex);
            }
            if (!enabled) {
                this.toggleShutterButton_.setSelected(false);
            }
        }
    }

    @Override
    public void liveModeEnabled(boolean isEnabled) {
        this.autoShutterCheckBox_.setEnabled(!isEnabled);
        if (this.core_.getAutoShutter()) {
            this.toggleShutterButton_.setText(isEnabled ? "Close" : "Open");
        }
        this.snapButton_.setEnabled(!isEnabled);
        this.liveButton_.setIcon(isEnabled ? SwingResourceManager.getIcon(MainFrame.class, "/org/micromanager/icons/cancel.png") : SwingResourceManager.getIcon(MainFrame.class, "/org/micromanager/icons/camera_go.png"));
        this.liveButton_.setSelected(false);
        this.liveButton_.setText(isEnabled ? "Stop Live" : "Live");
    }

    public void initializeShutterGUI(String[] items) {
        GUIUtils.replaceComboContents(this.shutterComboBox_, items);
        String activeShutter = this.core_.getShutterDevice();
        if (activeShutter != null) {
            this.shutterComboBox_.setSelectedItem(activeShutter);
        } else {
            this.shutterComboBox_.setSelectedItem("");
        }
    }

    public void updateAutofocusButtons(boolean isEnabled) {
        this.autofocusConfigureButton_.setEnabled(isEnabled);
        this.autofocusNowButton_.setEnabled(isEnabled);
    }

    @Subscribe
    public void onConfigGroupChanged(ConfigGroupChangedEvent event) {
        this.configPad_.refreshGroup(event.getGroupName(), event.getNewConfig());
    }

    private List<String> sortBinningItems(List<String> items) {
        ArrayList<Integer> binSizes = new ArrayList<Integer>();
        for (String s : items) {
            Integer i;
            try {
                i = Integer.valueOf(s);
            }
            catch (NumberFormatException e) {
                return items;
            }
            binSizes.add(i);
        }
        Collections.sort(binSizes);
        ArrayList<String> ret = new ArrayList<String>();
        for (Integer i : binSizes) {
            ret.add(i.toString());
        }
        return ret;
    }

    public void configureBinningComboForCamera(String cameraLabel) {
        if (this.comboBinning_.getItemCount() > 0) {
            this.comboBinning_.removeAllItems();
        }
        try {
            StrVector binSizes = this.core_.getAllowedPropertyValues(cameraLabel, MMCoreJ.getG_Keyword_Binning());
            List<String> items = this.sortBinningItems(Arrays.asList(binSizes.toArray()));
            ActionListener[] listeners = this.comboBinning_.getActionListeners();
            for (int i = 0; i < listeners.length; ++i) {
                this.comboBinning_.removeActionListener(listeners[i]);
            }
            for (String item : items) {
                this.comboBinning_.addItem(item);
            }
            this.comboBinning_.setMaximumRowCount(items.size());
            if (items.isEmpty()) {
                this.comboBinning_.setEditable(true);
            } else {
                this.comboBinning_.setEditable(false);
            }
            for (int i = 0; i < listeners.length; ++i) {
                this.comboBinning_.addActionListener(listeners[i]);
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
    }

    public void setBinSize(String binSize) {
        GUIUtils.setComboSelection(this.comboBinning_, binSize);
    }

    public String getBinMode() {
        Object item = this.comboBinning_.getSelectedItem();
        if (item != null) {
            return item.toString();
        }
        return null;
    }

    public void setAutoShutterSelected(boolean isSelected) {
        this.autoShutterCheckBox_.setSelected(isSelected);
    }

    public void setToggleShutterButtonEnabled(boolean isEnabled) {
        this.toggleShutterButton_.setEnabled(isEnabled);
    }

    public void setShutterComboSelection(String activeShutter) {
        this.shutterComboBox_.setSelectedItem(activeShutter);
        if (activeShutter.equals("") || this.core_.getAutoShutter()) {
            this.setToggleShutterButtonEnabled(false);
        } else {
            this.setToggleShutterButtonEnabled(true);
        }
    }

    public boolean getAutoShutterChecked() {
        return this.autoShutterCheckBox_.isSelected();
    }

    public ConfigGroupPad getConfigPad() {
        return this.configPad_;
    }

    public void savePrefs(Preferences prefs) {
        this.savePosition();
        prefs.putInt(MAIN_FRAME_DIVIDER_POS, this.splitPane_.getDividerLocation());
        prefs.put(MAIN_EXPOSURE, this.textFieldExp_.getText());
    }

    public void setDisplayedExposureTime(double exposure) {
        this.textFieldExp_.setText(NumberUtils.doubleToDisplayString(exposure));
    }

    public double getDisplayedExposureTime() {
        try {
            return NumberUtils.displayStringToDouble(this.textFieldExp_.getText());
        }
        catch (ParseException e) {
            ReportingUtils.logError(e, "Couldn't convert displayed exposure time to double");
            return -1.0;
        }
    }

    public void enableRoiButtons(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.setRoiButton_.setEnabled(enabled);
                MainFrame.this.clearRoiButton_.setEnabled(enabled);
            }
        });
    }

    public MetadataPanel getMetadataPanel() {
        return this.metadataPanel_;
    }

    protected void zoomOut() {
        ImageWindow curWin = WindowManager.getCurrentWindow();
        if (curWin != null) {
            ImageCanvas canvas = curWin.getCanvas();
            Rectangle r = canvas.getBounds();
            canvas.zoomOut(r.width / 2, r.height / 2);
            VirtualAcquisitionDisplay display = VirtualAcquisitionDisplay.getDisplay(curWin.getImagePlus());
            if (display != null) {
                display.updateWindowTitleAndStatus();
            }
        }
    }

    protected void zoomIn() {
        ImageWindow curWin = WindowManager.getCurrentWindow();
        if (curWin != null) {
            ImageCanvas canvas = curWin.getCanvas();
            Rectangle r = canvas.getBounds();
            canvas.zoomIn(r.width / 2, r.height / 2);
            VirtualAcquisitionDisplay display = VirtualAcquisitionDisplay.getDisplay(curWin.getImagePlus());
            if (display != null) {
                display.updateWindowTitleAndStatus();
            }
        }
    }
}

