/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import bsh.EvalError;
import bsh.Interpreter;
import com.google.common.eventbus.Subscribe;
import com.swtdesigner.SwingResourceManager;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.ConfigGroupPad;
import org.micromanager.CoreEventCallback;
import org.micromanager.MMOptions;
import org.micromanager.MainFrame;
import org.micromanager.PropertyEditor;
import org.micromanager.SnapLiveManager;
import org.micromanager.StaticInfo;
import org.micromanager.acquisition.AcquisitionManager;
import org.micromanager.acquisition.AcquisitionWrapperEngine;
import org.micromanager.acquisition.MMAcquisition;
import org.micromanager.acquisition.ProcessorStack;
import org.micromanager.acquisition.TaggedImageQueue;
import org.micromanager.acquisition.TaggedImageStorageDiskDefault;
import org.micromanager.acquisition.TaggedImageStorageMultipageTiff;
import org.micromanager.api.Autofocus;
import org.micromanager.api.DataProcessor;
import org.micromanager.api.IAcquisitionEngine2010;
import org.micromanager.api.ImageCache;
import org.micromanager.api.MMListenerInterface;
import org.micromanager.api.PositionList;
import org.micromanager.api.ScriptInterface;
import org.micromanager.api.SequenceSettings;
import org.micromanager.api.events.ExposureChangedEvent;
import org.micromanager.api.events.PropertiesChangedEvent;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.diagnostics.EDTHangLogger;
import org.micromanager.diagnostics.ThreadExceptionLogger;
import org.micromanager.diagnostics.gui.ProblemReportController;
import org.micromanager.dialogs.AcqControlDlg;
import org.micromanager.dialogs.CalibrationListDlg;
import org.micromanager.dialogs.MMIntroDlg;
import org.micromanager.dialogs.RegistrationDlg;
import org.micromanager.events.EventManager;
import org.micromanager.graph.GraphData;
import org.micromanager.graph.GraphFrame;
import org.micromanager.graph.HistogramSettings;
import org.micromanager.imagedisplay.DisplayWindow;
import org.micromanager.imagedisplay.MetadataPanel;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.logging.LogFileManager;
import org.micromanager.menus.FileMenu;
import org.micromanager.menus.HelpMenu;
import org.micromanager.menus.ToolsMenu;
import org.micromanager.navigation.CenterAndDragListener;
import org.micromanager.navigation.XYZKeyListener;
import org.micromanager.navigation.ZWheelListener;
import org.micromanager.pipelineinterface.PipelineFrame;
import org.micromanager.pluginmanagement.PluginManager;
import org.micromanager.positionlist.PositionListDlg;
import org.micromanager.script.ScriptPanel;
import org.micromanager.utils.AutofocusManager;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.GUIColors;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.HotKeys;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.TextUtils;
import org.micromanager.utils.UIMonitor;
import org.micromanager.utils.WaitDialog;

public class MMStudio
implements ScriptInterface {
    private static final long serialVersionUID = 3556500289598574541L;
    private static final String MAIN_SAVE_METHOD = "saveMethod";
    private static final String SYSTEM_CONFIG_FILE = "sysconfig_file";
    private static final String OPEN_ACQ_DIR = "openDataDir";
    private static final String SCRIPT_CORE_OBJECT = "mmc";
    private static final String SCRIPT_ACQENG_OBJECT = "acq";
    private static final String SCRIPT_GUI_OBJECT = "gui";
    private static final String AUTOFOCUS_DEVICE = "autofocus_device";
    private static final String EXPOSURE_SETTINGS_NODE = "MainExposureSettings";
    private static final String CONTRAST_SETTINGS_NODE = "MainContrastSettings";
    private static final int TOOLTIP_DISPLAY_DURATION_MILLISECONDS = 15000;
    private static final int TOOLTIP_DISPLAY_INITIAL_DELAY_MILLISECONDS = 2000;
    private static final String DEFAULT_CONFIG_FILE_NAME = "MMConfig_demo.cfg";
    private static final String DEFAULT_CONFIG_FILE_PROPERTY = "org.micromanager.default.config.file";
    private static final String CFGFILE_ENTRY_BASE = "CFGFileEntry";
    private MMOptions options_;
    private boolean amRunningAsPlugin_;
    private GUIColors guiColors_;
    private GraphFrame profileWin_;
    private PropertyEditor propertyBrowser_;
    private CalibrationListDlg calibrationListDlg_;
    private AcqControlDlg acqControlWin_;
    private PluginManager pluginManager_;
    private final SnapLiveManager snapLiveManager_;
    private final ToolsMenu toolsMenu_;
    private List<Component> MMFrames_ = Collections.synchronizedList(new ArrayList());
    private AutofocusManager afMgr_;
    private ArrayList<String> MRUConfigFiles_;
    private static final int maxMRUCfgs_ = 5;
    private String sysConfigFile_;
    private String startupScriptFile_;
    private GraphData lineProfileData_;
    private Preferences mainPrefs_;
    private Preferences systemPrefs_;
    private Preferences colorPrefs_;
    private Preferences exposurePrefs_;
    private Preferences contrastPrefs_;
    private CMMCore core_;
    private AcquisitionWrapperEngine engine_;
    private PositionList posList_;
    private PositionListDlg posListDlg_;
    private String openAcqDirectory_ = "";
    private boolean isProgramRunning_;
    private boolean configChanged_ = false;
    private StrVector shutters_ = null;
    private ScriptPanel scriptPanel_;
    private PipelineFrame pipelineFrame_;
    private HotKeys hotKeys_;
    private CenterAndDragListener centerAndDragListener_;
    private ZWheelListener zWheelListener_;
    private XYZKeyListener xyzKeyListener_;
    private AcquisitionManager acqMgr_;
    private boolean liveModeSuspended_;
    public static final FileDialogs.FileType MM_CONFIG_FILE = new FileDialogs.FileType("MM_CONFIG_FILE", "Micro-Manager Config File", "./MyScope.cfg", true, "cfg");
    private static MMStudio studio_;
    private static MainFrame frame_;
    private CoreEventCallback coreCallback_;
    private final Object shutdownLock_ = new Object();
    private final JMenuBar menuBar_;
    private final FileMenu fileMenu_;
    private JCheckBoxMenuItem centerAndDragMenuItem_;
    public static final FileDialogs.FileType MM_DATA_SET;
    private Thread acquisitionEngine2010LoadingThread_ = null;
    private Class<?> acquisitionEngine2010Class_ = null;
    private IAcquisitionEngine2010 acquisitionEngine2010_ = null;
    private final StaticInfo staticInfo_;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            MMStudio mMStudio = new MMStudio(false);
        }
        catch (ClassNotFoundException e) {
            ReportingUtils.showError((Throwable)e, "A java error has caused Micro-Manager to exit.");
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            ReportingUtils.showError((Throwable)e, "A java error has caused Micro-Manager to exit.");
            System.exit(1);
        }
        catch (InstantiationException e) {
            ReportingUtils.showError((Throwable)e, "A java error has caused Micro-Manager to exit.");
            System.exit(1);
        }
        catch (UnsupportedLookAndFeelException e) {
            ReportingUtils.showError((Throwable)e, "A java error has caused Micro-Manager to exit.");
            System.exit(1);
        }
    }

    public MMStudio(boolean shouldRunAsPlugin) {
        ThreadExceptionLogger.setUp();
        EventManager manager = new EventManager();
        EventManager.register(this);
        this.prepAcquisitionEngine();
        this.options_ = new MMOptions();
        try {
            this.options_.loadSettings();
        }
        catch (NullPointerException ex) {
            ReportingUtils.logError(ex);
        }
        UIMonitor.enable(this.options_.debugLogEnabled_);
        this.guiColors_ = new GUIColors();
        studio_ = this;
        this.amRunningAsPlugin_ = shouldRunAsPlugin;
        this.isProgramRunning_ = true;
        this.acqMgr_ = new AcquisitionManager();
        this.sysConfigFile_ = new File(DEFAULT_CONFIG_FILE_NAME).getAbsolutePath();
        this.sysConfigFile_ = System.getProperty(DEFAULT_CONFIG_FILE_PROPERTY, this.sysConfigFile_);
        this.startupScriptFile_ = this.options_.startupScript_.length() > 0 ? new File(this.options_.startupScript_).getAbsolutePath() : "";
        try {
            this.mainPrefs_ = Preferences.userNodeForPackage(this.getClass());
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
        this.systemPrefs_ = this.mainPrefs_;
        this.colorPrefs_ = this.mainPrefs_.node(this.mainPrefs_.absolutePath() + "/" + "ColorSettings");
        this.exposurePrefs_ = this.mainPrefs_.node(this.mainPrefs_.absolutePath() + "/" + EXPOSURE_SETTINGS_NODE);
        this.contrastPrefs_ = this.mainPrefs_.node(this.mainPrefs_.absolutePath() + "/" + CONTRAST_SETTINGS_NODE);
        try {
            Preferences p = Preferences.systemNodeForPackage(this.getClass());
            if (null != p && JavaUtils.backingStoreAvailable(p)) {
                this.systemPrefs_ = p;
            }
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
        this.showRegistrationDialogMaybe();
        try {
            this.core_ = new CMMCore();
        }
        catch (UnsatisfiedLinkError ex) {
            ReportingUtils.showError((Throwable)ex, "Failed to load the MMCoreJ_wrap native library");
        }
        this.core_.enableStderrLog(true);
        this.snapLiveManager_ = new SnapLiveManager(studio_, this.core_);
        frame_ = new MainFrame(this, this.core_, this.snapLiveManager_, this.mainPrefs_);
        frame_.setIconImage(SwingResourceManager.getImage(MMStudio.class, "icons/microscope.gif"));
        frame_.loadApplicationPrefs(this.mainPrefs_, this.options_.closeOnExit_);
        ReportingUtils.SetContainingFrame(frame_);
        if (IJ.getInstance() != null) {
            Point ijWinLoc = IJ.getInstance().getLocation();
            if (GUIUtils.getGraphicsConfigurationContaining(ijWinLoc.x, ijWinLoc.y) == null) {
                IJ.getInstance().setLocation(150, 150);
            }
        }
        this.staticInfo_ = new StaticInfo(this.core_, frame_);
        this.openAcqDirectory_ = this.mainPrefs_.get(OPEN_ACQ_DIR, "");
        try {
            ImageUtils.setImageStorageClass(Class.forName(this.mainPrefs_.get(MAIN_SAVE_METHOD, ImageUtils.getImageStorageClass().getName())));
        }
        catch (ClassNotFoundException ex) {
            ReportingUtils.logError(ex, "Class not found error.  Should never happen");
        }
        ToolTipManager ttManager = ToolTipManager.sharedInstance();
        ttManager.setDismissDelay(15000);
        ttManager.setInitialDelay(2000);
        frame_.setBackground(this.getBackgroundColor());
        this.menuBar_ = new JMenuBar();
        frame_.setJMenuBar(this.menuBar_);
        this.fileMenu_ = new FileMenu(studio_);
        this.fileMenu_.initializeFileMenu(this.menuBar_);
        this.toolsMenu_ = new ToolsMenu(studio_, this.core_, this.options_);
        this.toolsMenu_.initializeToolsMenu(this.menuBar_, this.mainPrefs_);
        HelpMenu helpMenu = new HelpMenu(studio_, this.core_);
        this.initializationSequence();
        helpMenu.initializeHelpMenu(this.menuBar_, this.systemPrefs_);
    }

    private void initializationSequence() {
        if (this.core_ == null) {
            return;
        }
        String logFileName = LogFileManager.makeLogFileNameForCurrentSession();
        new File(logFileName).getParentFile().mkdirs();
        try {
            this.core_.setPrimaryLogFile(logFileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.core_.enableDebugLog(this.options_.debugLogEnabled_);
        if (this.options_.deleteOldCoreLogs_) {
            LogFileManager.deleteLogFilesDaysOld(this.options_.deleteCoreLogAfterDays_, logFileName);
        }
        EDTHangLogger.startDefault(this.core_, 4500L, 1000L);
        ReportingUtils.setCore(this.core_);
        this.logStartupProperties();
        this.engine_ = new AcquisitionWrapperEngine(this.acqMgr_);
        this.coreCallback_ = new CoreEventCallback(this.core_, this.engine_);
        try {
            this.core_.setCircularBufferMemoryFootprint((long)this.options_.circularBufferSizeMB_);
        }
        catch (Exception ex) {
            ReportingUtils.showError(ex);
        }
        this.engine_.setParentGUI(studio_);
        this.loadMRUConfigFiles();
        this.afMgr_ = new AutofocusManager(studio_);
        this.pluginManager_ = new PluginManager(studio_, this.menuBar_);
        Thread pluginInitializer = this.pluginManager_.initializePlugins();
        frame_.paintToFront();
        this.engine_.setCore(this.core_, this.afMgr_);
        this.posList_ = new PositionList();
        this.engine_.setPositionList(this.posList_);
        this.createScriptPanel();
        this.createPipelinePanel();
        this.hotKeys_ = new HotKeys();
        this.hotKeys_.loadSettings();
        if (!this.options_.doNotAskForConfigFile_) {
            MMIntroDlg introDlg = new MMIntroDlg("1.4.x dev", this.MRUConfigFiles_);
            introDlg.setConfigFile(this.sysConfigFile_);
            introDlg.setBackground(this.getBackgroundColor());
            introDlg.setVisible(true);
            introDlg.toFront();
            if (!introDlg.okChosen()) {
                this.closeSequence(false);
                return;
            }
            this.sysConfigFile_ = introDlg.getConfigFile();
        }
        this.saveMRUConfigFiles();
        this.mainPrefs_.put(SYSTEM_CONFIG_FILE, this.sysConfigFile_);
        WaitDialog waitDlg = new WaitDialog("Loading plugins, please wait...");
        waitDlg.setAlwaysOnTop(true);
        waitDlg.showDialog();
        try {
            pluginInitializer.join(15000L);
        }
        catch (InterruptedException ex) {
            ReportingUtils.logError(ex, "Interrupted while waiting for plugin loading thread");
        }
        if (pluginInitializer.isAlive()) {
            ReportingUtils.logMessage("Warning: Plugin loading did not finish within 15 seconds; continuing anyway");
        } else {
            ReportingUtils.logMessage("Finished waiting for plugins to load");
        }
        waitDlg.closeDialog();
        if (!this.loadSystemConfiguration()) {
            ReportingUtils.showErrorOn(false);
        }
        this.executeStartupScript();
        this.acqControlWin_ = new AcqControlDlg(this.engine_, this.mainPrefs_, studio_, this.options_);
        this.addMMBackgroundListener(this.acqControlWin_);
        frame_.initializeConfigPad();
        String afDevice = this.mainPrefs_.get(AUTOFOCUS_DEVICE, "");
        if (this.afMgr_.hasDevice(afDevice)) {
            try {
                this.afMgr_.selectDevice(afDevice);
            }
            catch (MMException ex) {
                ReportingUtils.showError(ex);
            }
        }
        this.centerAndDragListener_ = new CenterAndDragListener(studio_);
        this.zWheelListener_ = new ZWheelListener(this.core_, studio_);
        this.snapLiveManager_.addLiveModeListener(this.zWheelListener_);
        this.xyzKeyListener_ = new XYZKeyListener(this.core_, studio_);
        this.snapLiveManager_.addLiveModeListener(this.xyzKeyListener_);
        ReportingUtils.showErrorOn(true);
        ProblemReportController.startIfInterruptedOnExit();
    }

    public void showPipelinePanel() {
        this.pipelineFrame_.setVisible(true);
    }

    public void showScriptPanel() {
        this.scriptPanel_.setVisible(true);
    }

    private void handleError(String message) {
        this.snapLiveManager_.setLiveMode(false);
        JOptionPane.showMessageDialog(frame_, message);
        this.core_.logMessage(message);
    }

    public void saveChannelColor(String chName, int rgb) {
        if (this.colorPrefs_ != null) {
            this.colorPrefs_.putInt("Color_" + chName, rgb);
        }
    }

    public Color getChannelColor(String chName, int defaultColor) {
        if (this.colorPrefs_ != null) {
            defaultColor = this.colorPrefs_.getInt("Color_" + chName, defaultColor);
        }
        return new Color(defaultColor);
    }

    public void copyFromLiveModeToAlbum(VirtualAcquisitionDisplay display) throws MMScriptException, JSONException {
        ImageCache ic = display.getImageCache();
        int channels = ic.getSummaryMetadata().getInt("Channels");
        for (int i = 0; i < channels; ++i) {
            TaggedImage image = ic.getImage(i, 0, 0, 0);
            this.addToAlbum(ImageUtils.copyMetadata(image), ic.getDisplayAndComments());
        }
    }

    private void showRegistrationDialogMaybe() {
        boolean userReg;
        boolean bl = userReg = this.mainPrefs_.getBoolean("registered", false) || this.mainPrefs_.getBoolean("reg_never", false);
        if (!userReg) {
            boolean systemReg;
            boolean bl2 = systemReg = this.systemPrefs_.getBoolean("registered", false) || this.systemPrefs_.getBoolean("reg_never", false);
            if (!systemReg) {
                RegistrationDlg dlg = new RegistrationDlg(this.systemPrefs_);
                dlg.setVisible(true);
            }
        }
    }

    private void prepAcquisitionEngine() {
        this.acquisitionEngine2010LoadingThread_ = new Thread("Pipeline Class loading thread"){

            @Override
            public void run() {
                try {
                    MMStudio.this.acquisitionEngine2010Class_ = Class.forName("org.micromanager.AcquisitionEngine2010");
                }
                catch (ClassNotFoundException ex) {
                    ReportingUtils.logError(ex);
                    MMStudio.this.acquisitionEngine2010Class_ = null;
                }
            }
        };
        this.acquisitionEngine2010LoadingThread_.setContextClassLoader(this.getClass().getClassLoader());
        this.acquisitionEngine2010LoadingThread_.start();
    }

    public void toggleAutoShutter() {
        try {
            if (frame_.getAutoShutterChecked()) {
                this.core_.setAutoShutter(true);
                this.core_.setShutterOpen(false);
                frame_.toggleAutoShutter(false);
            } else {
                this.core_.setAutoShutter(false);
                this.core_.setShutterOpen(false);
                frame_.toggleAutoShutter(true);
            }
        }
        catch (Exception exc) {
            ReportingUtils.logError(exc);
        }
    }

    public Thread runDisplayThread(BlockingQueue<TaggedImage> rawImageQueue, final DisplayImageRoutine displayImageRoutine) {
        final BlockingQueue<TaggedImage> processedImageQueue = ProcessorStack.run(rawImageQueue, this.getAcquisitionEngine().getImageProcessors());
        Thread displayThread = new Thread("Display thread"){

            @Override
            public void run() {
                try {
                    TaggedImage image;
                    do {
                        if ((image = (TaggedImage)processedImageQueue.take()) == TaggedImageQueue.POISON) continue;
                        displayImageRoutine.show(image);
                    } while (image != TaggedImageQueue.POISON);
                }
                catch (InterruptedException ex) {
                    ReportingUtils.logError(ex);
                }
            }
        };
        displayThread.start();
        return displayThread;
    }

    public void saveChannelHistogramSettings(String channelGroup, String channel, boolean mda, HistogramSettings settings) {
        String type;
        String string = type = mda ? "MDA_" : "SnapLive_";
        if (this.options_.syncExposureMainAndMDA_) {
            type = "";
        }
        this.contrastPrefs_.putInt("ContrastMin_" + channelGroup + "_" + type + channel, settings.min_);
        this.contrastPrefs_.putInt("ContrastMax_" + channelGroup + "_" + type + channel, settings.max_);
        this.contrastPrefs_.putDouble("ContrastGamma_" + channelGroup + "_" + type + channel, settings.gamma_);
        this.contrastPrefs_.putInt("ContrastHistMax_" + channelGroup + "_" + type + channel, settings.histMax_);
        this.contrastPrefs_.putInt("ContrastHistDisplayMode_" + channelGroup + "_" + type + channel, settings.displayMode_);
    }

    public HistogramSettings loadStoredChannelHistogramSettings(String channelGroup, String channel, boolean mda) {
        String type;
        String string = type = mda ? "MDA_" : "SnapLive_";
        if (this.options_.syncExposureMainAndMDA_) {
            type = "";
        }
        return new HistogramSettings(this.contrastPrefs_.getInt("ContrastMin_" + channelGroup + "_" + type + channel, 0), this.contrastPrefs_.getInt("ContrastMax_" + channelGroup + "_" + type + channel, 65536), this.contrastPrefs_.getDouble("ContrastGamma_" + channelGroup + "_" + type + channel, 1.0), this.contrastPrefs_.getInt("ContrastHistMax_" + channelGroup + "_" + type + channel, -1), this.contrastPrefs_.getInt("ContrastHistDisplayMode_" + channelGroup + "_" + type + channel, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExposure(double exposureTime) {
        Object object = this.shutdownLock_;
        synchronized (object) {
            if (this.core_ == null) {
                return;
            }
            this.snapLiveManager_.safeSetCoreExposure(exposureTime);
            try {
                double exposure = this.core_.getExposure();
                frame_.setDisplayedExposureTime(exposure);
                String channelGroup = this.core_.getChannelGroup();
                String channel = this.core_.getCurrentConfigFromCache(channelGroup);
                if (!channel.equals("")) {
                    this.exposurePrefs_.putDouble("Exposure_" + channelGroup + "_" + channel, exposure);
                    if (this.options_.syncExposureMainAndMDA_) {
                        this.getAcqDlg().setChannelExposureTime(channelGroup, channel, exposure);
                    }
                }
            }
            catch (Exception e) {
                ReportingUtils.logError(e, "Couldn't set exposure time.");
            }
        }
    }

    public double getPreferredWindowMag() {
        return this.options_.windowMag_;
    }

    public boolean getMetadataFileWithMultipageTiff() {
        return this.options_.mpTiffMetadataFile_;
    }

    public boolean getSeparateFilesForPositionsMPTiff() {
        return this.options_.mpTiffSeparateFilesForPositions_;
    }

    @Override
    public boolean getHideMDADisplayOption() {
        return this.options_.hideMDADisplay_;
    }

    public void updateLineProfile() {
        if (WindowManager.getCurrentWindow() == null || this.profileWin_ == null || !this.profileWin_.isShowing()) {
            return;
        }
        this.calculateLineProfileData(WindowManager.getCurrentImage());
        this.profileWin_.setData(this.lineProfileData_);
    }

    public void openLineProfileWindow() {
        if (WindowManager.getCurrentWindow() == null || WindowManager.getCurrentWindow().isClosed()) {
            return;
        }
        this.calculateLineProfileData(WindowManager.getCurrentImage());
        if (this.lineProfileData_ == null) {
            return;
        }
        this.profileWin_ = new GraphFrame();
        this.profileWin_.setDefaultCloseOperation(2);
        this.profileWin_.setData(this.lineProfileData_);
        this.profileWin_.setAutoScale();
        this.profileWin_.setTitle("Live line profile");
        this.profileWin_.setBackground(this.getBackgroundColor());
        this.addMMBackgroundListener(this.profileWin_);
        this.profileWin_.setVisible(true);
    }

    @Override
    public Rectangle getROI() throws MMScriptException {
        int[][] a = new int[4][1];
        try {
            this.core_.getROI(a[0], a[1], a[2], a[3]);
        }
        catch (Exception e) {
            throw new MMScriptException(e.getMessage());
        }
        return new Rectangle(a[0][0], a[1][0], a[2][0], a[3][0]);
    }

    private void calculateLineProfileData(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null || !roi.isLine()) {
            Rectangle r = imp.getProcessor().getRoi();
            int iWidth = r.width;
            int iHeight = r.height;
            int iXROI = r.x;
            int iYROI = r.y;
            if (roi == null) {
                iXROI += iWidth / 2;
                iYROI += iHeight / 2;
            }
            roi = new Line(iXROI - iWidth / 4, iYROI - iWidth / 4, iXROI + iWidth / 4, iYROI + iHeight / 4);
            imp.setRoi(roi);
            roi = imp.getRoi();
        }
        ImageProcessor ip = imp.getProcessor();
        ip.setInterpolate(true);
        Line line = (Line)roi;
        if (this.lineProfileData_ == null) {
            this.lineProfileData_ = new GraphData();
        }
        this.lineProfileData_.setData(line.getPixels());
    }

    public void setROI() {
        ImagePlus curImage = WindowManager.getCurrentImage();
        if (curImage == null) {
            return;
        }
        Roi roi = curImage.getRoi();
        try {
            Rectangle r;
            if (roi == null) {
                r = curImage.getProcessor().getRoi();
                int iWidth = r.width;
                int iHeight = r.height;
                int iXROI = r.x;
                int iYROI = r.y;
                if (roi == null) {
                    iXROI += (iWidth /= 2) / 2;
                    iYROI += (iHeight /= 2) / 2;
                }
                curImage.setRoi(iXROI, iYROI, iWidth, iHeight);
                roi = curImage.getRoi();
            }
            if (roi.getType() != 0) {
                this.handleError("ROI must be a rectangle.\nUse the ImageJ rectangle tool to draw the ROI.");
                return;
            }
            r = roi.getBounds();
            Rectangle originalROI = null;
            VirtualAcquisitionDisplay virtAcq = VirtualAcquisitionDisplay.getDisplay(curImage);
            JSONObject tags = virtAcq.getCurrentMetadata();
            try {
                originalROI = MDUtils.getROI(tags);
            }
            catch (JSONException jSONException) {
            }
            catch (MMScriptException mMScriptException) {
                // empty catch block
            }
            if (originalROI == null) {
                originalROI = this.getROI();
            }
            r.x += originalROI.x;
            r.y += originalROI.y;
            this.setROI(r);
        }
        catch (MMScriptException e) {
            ReportingUtils.showError(e);
        }
    }

    public void clearROI() {
        try {
            boolean liveRunning = false;
            if (this.isLiveModeOn()) {
                liveRunning = true;
                this.enableLiveMode(false);
            }
            this.core_.clearROI();
            this.staticInfo_.refreshValues();
            if (liveRunning) {
                this.enableLiveMode(true);
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
    }

    @Override
    public CMMCore getMMCore() {
        return this.core_;
    }

    public static MMStudio getInstance() {
        return studio_;
    }

    public static MainFrame getFrame() {
        return frame_;
    }

    public MetadataPanel getMetadataPanel() {
        return frame_.getMetadataPanel();
    }

    @Override
    public void saveConfigPresets() {
        MicroscopeModel model = new MicroscopeModel();
        try {
            model.loadFromFile(this.sysConfigFile_);
            model.createSetupConfigsFromHardware(this.core_);
            model.createResolutionsFromHardware(this.core_);
            File f = FileDialogs.save(frame_, "Save the configuration file", MM_CONFIG_FILE);
            if (f != null) {
                model.saveToFile(f.getAbsolutePath());
                this.sysConfigFile_ = f.getAbsolutePath();
                this.mainPrefs_.put(SYSTEM_CONFIG_FILE, this.sysConfigFile_);
                this.configChanged_ = false;
                frame_.setConfigSaveButtonStatus(this.configChanged_);
                frame_.updateTitle(this.sysConfigFile_);
            }
        }
        catch (MMConfigFileException e) {
            ReportingUtils.showError(e);
        }
    }

    public String getSysConfigFile() {
        return this.sysConfigFile_;
    }

    public void setSysConfigFile(String newFile) {
        this.sysConfigFile_ = newFile;
        this.configChanged_ = false;
        frame_.setConfigSaveButtonStatus(this.configChanged_);
        this.mainPrefs_.put(SYSTEM_CONFIG_FILE, this.sysConfigFile_);
        this.loadSystemConfiguration();
    }

    public void setAcqDirectory(String dir) {
        this.openAcqDirectory_ = dir;
    }

    public File promptForAcquisitionToOpen(boolean inRAM) {
        File f = FileDialogs.openDir(frame_, "Please select an image data set", MM_DATA_SET);
        if (f == null) {
            return null;
        }
        String path = f.getParent();
        if (f.isDirectory()) {
            path = f.getAbsolutePath();
        }
        try {
            this.openAcquisitionData(path, inRAM);
        }
        catch (MMScriptException ex) {
            ReportingUtils.showError(ex);
        }
        return f;
    }

    @Override
    public String openAcquisitionData(String dir, boolean inRAM, boolean show) throws MMScriptException {
        File f = new File(dir);
        String rootDir = f.getAbsolutePath();
        String name = f.getName();
        rootDir = rootDir.substring(0, rootDir.length() - (name.length() + 1));
        name = this.acqMgr_.getUniqueAcquisitionName(name);
        this.acqMgr_.openAcquisition(name, rootDir, show, !inRAM, true);
        try {
            this.getAcquisition(name).initialize();
            this.fileMenu_.addFileToRecentlyOpenedMenu(f);
        }
        catch (MMScriptException mex) {
            this.acqMgr_.closeAcquisition(name);
            throw mex;
        }
        return name;
    }

    @Override
    public String openAcquisitionData(String dir, boolean inRam) throws MMScriptException {
        return this.openAcquisitionData(dir, inRam, true);
    }

    protected void changeBinning() {
        try {
            String mode = frame_.getBinMode();
            if (!this.isCameraAvailable() || mode == null) {
                return;
            }
            if (this.core_.getProperty(StaticInfo.cameraLabel_, MMCoreJ.getG_Keyword_Binning()).equals(mode)) {
                return;
            }
            boolean isLiveOn = false;
            if (this.isLiveModeOn()) {
                isLiveOn = true;
                this.enableLiveMode(false);
            }
            this.core_.setProperty(StaticInfo.cameraLabel_, MMCoreJ.getG_Keyword_Binning(), mode);
            this.staticInfo_.refreshValues();
            if (isLiveOn) {
                this.enableLiveMode(true);
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
    }

    public void createPropertyEditor() {
        if (this.propertyBrowser_ != null) {
            this.propertyBrowser_.dispose();
        }
        this.propertyBrowser_ = new PropertyEditor();
        this.propertyBrowser_.setGui(studio_);
        this.propertyBrowser_.setVisible(true);
        this.propertyBrowser_.setDefaultCloseOperation(2);
        this.propertyBrowser_.setCore(this.core_);
    }

    public void createCalibrationListDlg() {
        if (this.calibrationListDlg_ != null) {
            this.calibrationListDlg_.dispose();
        }
        this.calibrationListDlg_ = new CalibrationListDlg(this.core_);
        this.calibrationListDlg_.setVisible(true);
        this.calibrationListDlg_.setDefaultCloseOperation(2);
        this.calibrationListDlg_.setParentGUI(studio_);
    }

    public CalibrationListDlg getCalibrationListDlg() {
        if (this.calibrationListDlg_ == null) {
            this.createCalibrationListDlg();
        }
        return this.calibrationListDlg_;
    }

    private void createScriptPanel() {
        if (this.scriptPanel_ == null) {
            this.scriptPanel_ = new ScriptPanel(this.core_, studio_);
            this.scriptPanel_.insertScriptingObject(SCRIPT_CORE_OBJECT, this.core_);
            this.scriptPanel_.insertScriptingObject(SCRIPT_ACQENG_OBJECT, this.engine_);
            this.scriptPanel_.setParentGUI(studio_);
            this.scriptPanel_.setBackground(this.getBackgroundColor());
            this.addMMBackgroundListener(this.scriptPanel_);
        }
    }

    private void createPipelinePanel() {
        if (this.pipelineFrame_ == null) {
            this.pipelineFrame_ = new PipelineFrame(studio_, this.engine_);
            this.pipelineFrame_.setBackground(this.getBackgroundColor());
            this.addMMBackgroundListener(this.pipelineFrame_);
        }
    }

    public void updateXYPos(double x, double y) {
        this.staticInfo_.updateXYPos(x, y);
    }

    public void updateXYPosRelative(double x, double y) {
        this.staticInfo_.updateXYPosRelative(x, y);
    }

    public void updateZPos(double z) {
        this.staticInfo_.updateZPos(z);
    }

    public void updateZPosRelative(double z) {
        this.staticInfo_.updateZPosRelative(z);
    }

    public void updateXYStagePosition() {
        this.staticInfo_.getNewXYStagePosition();
    }

    public void toggleShutter() {
        frame_.toggleShutter();
    }

    public void updateCenterAndDragListener() {
        if (this.toolsMenu_.getIsCenterAndDragChecked()) {
            this.centerAndDragListener_.start();
        } else {
            this.centerAndDragListener_.stop();
        }
    }

    private void checkPosListDlg() {
        if (this.posListDlg_ == null) {
            this.posListDlg_ = new PositionListDlg(this.core_, studio_, this.posList_, this.acqControlWin_, this.options_);
            this.posListDlg_.setBackground(this.getBackgroundColor());
            studio_.addMMBackgroundListener(this.posListDlg_);
            this.posListDlg_.addListeners();
        }
    }

    @Override
    public void snapSingleImage() {
        this.doSnap();
    }

    private boolean isCameraAvailable() {
        return StaticInfo.cameraLabel_.length() > 0;
    }

    @Override
    public void markCurrentPosition() {
        if (this.posListDlg_ == null) {
            this.showXYPositionList();
        }
        if (this.posListDlg_ != null) {
            this.posListDlg_.markPosition();
        }
    }

    @Override
    @Deprecated
    public AcqControlDlg getAcqDlg() {
        return this.acqControlWin_;
    }

    @Override
    @Deprecated
    public PositionListDlg getXYPosListDlg() {
        this.checkPosListDlg();
        return this.posListDlg_;
    }

    @Override
    public boolean isAcquisitionRunning() {
        if (this.engine_ == null) {
            return false;
        }
        return this.engine_.isAcquisitionRunning();
    }

    @Override
    public boolean versionLessThan(String version) throws MMScriptException {
        try {
            String[] v = "1.4.x dev".split(" ", 2);
            String[] m = v[0].split("\\.", 3);
            String[] v2 = version.split(" ", 2);
            String[] m2 = v2[0].split("\\.", 3);
            for (int i = 0; i < 3; ++i) {
                if (Integer.parseInt(m[i]) < Integer.parseInt(m2[i])) {
                    ReportingUtils.showError("This code needs Micro-Manager version " + version + " or greater");
                    return true;
                }
                if (Integer.parseInt(m[i]) <= Integer.parseInt(m2[i])) continue;
                return false;
            }
            if (v2.length < 2 || v2[1].equals("")) {
                return false;
            }
            if (v.length < 2) {
                ReportingUtils.showError("This code needs Micro-Manager version " + version + " or greater");
                return true;
            }
            if (Integer.parseInt(v[1]) < Integer.parseInt(v2[1])) {
                ReportingUtils.showError("This code needs Micro-Manager version " + version + " or greater");
                return false;
            }
            return true;
        }
        catch (NumberFormatException ex) {
            throw new MMScriptException("Format of version String should be \"a.b.c\"");
        }
    }

    @Override
    public boolean isLiveModeOn() {
        return this.snapLiveManager_.getIsLiveModeOn();
    }

    public boolean displayImage(Object pixels) {
        if (pixels instanceof TaggedImage) {
            return this.displayTaggedImage((TaggedImage)pixels, true);
        }
        return this.displayImage(pixels, true);
    }

    public boolean displayImage(Object pixels, boolean wait) {
        return this.snapLiveManager_.displayImage(pixels);
    }

    public boolean displayImageWithStatusLine(Object pixels, String statusLine) {
        boolean ret = this.displayImage(pixels);
        this.snapLiveManager_.setStatusLine(statusLine);
        return ret;
    }

    public void displayStatusLine(String statusLine) {
        ImagePlus ip = WindowManager.getCurrentImage();
        if (!(ip.getWindow() instanceof DisplayWindow)) {
            return;
        }
        VirtualAcquisitionDisplay.getDisplay(ip).displayStatusLine(statusLine);
    }

    private boolean isCurrentImageFormatSupported() {
        long channels = this.core_.getNumberOfComponents();
        long bpp = this.core_.getBytesPerPixel();
        if (channels <= 1L || channels == 4L || bpp == 1L) {
            return true;
        }
        this.handleError("Unsupported image format.");
        return false;
    }

    public void doSnap() {
        this.doSnap(false);
    }

    public void doSnap(final boolean shouldAddToAlbum) {
        if (this.core_.getCameraDevice().length() == 0) {
            ReportingUtils.showError("No camera configured");
            return;
        }
        LinkedBlockingQueue<TaggedImage> snapImageQueue = new LinkedBlockingQueue<TaggedImage>();
        try {
            this.core_.snapImage();
            long c = this.core_.getNumberOfCameraChannels();
            this.runDisplayThread(snapImageQueue, new DisplayImageRoutine(){

                @Override
                public void show(TaggedImage image) {
                    if (shouldAddToAlbum) {
                        try {
                            MMStudio.this.addToAlbum(image);
                        }
                        catch (MMScriptException ex) {
                            ReportingUtils.showError(ex);
                        }
                    } else {
                        MMStudio.this.displayImage(image);
                    }
                }
            });
            int i = 0;
            while ((long)i < c) {
                TaggedImage img = this.core_.getTaggedImage(i);
                MDUtils.setNumChannels(img.tags, (int)c);
                snapImageQueue.put(img);
                ++i;
            }
            snapImageQueue.put(TaggedImageQueue.POISON);
            this.snapLiveManager_.moveDisplayToFront();
        }
        catch (Exception ex) {
            ReportingUtils.showError(ex);
        }
    }

    public void normalizeTags(TaggedImage ti) {
        if (ti != TaggedImageQueue.POISON) {
            int channel = 0;
            try {
                if (ti.tags.has("ChannelIndex")) {
                    channel = MDUtils.getChannelIndex(ti.tags);
                }
                MDUtils.setChannelIndex(ti.tags, channel);
                MDUtils.setPositionIndex(ti.tags, 0);
                MDUtils.setSliceIndex(ti.tags, 0);
                MDUtils.setFrameIndex(ti.tags, 0);
            }
            catch (JSONException ex) {
                ReportingUtils.logError(ex);
            }
        }
    }

    private boolean displayTaggedImage(TaggedImage ti, boolean update) {
        try {
            frame_.setCursor(new Cursor(3));
            this.snapLiveManager_.validateDisplayAndAcquisition(ti);
            MDUtils.setSummary(ti.tags, this.getAcquisitionWithName("Snap/Live Window").getSummaryMetadata());
            this.staticInfo_.addStagePositionToTags(ti);
            this.addImage("Snap/Live Window", ti, update, true);
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
            return false;
        }
        catch (MMScriptException ex) {
            ReportingUtils.logError(ex);
            return false;
        }
        if (update) {
            frame_.setCursor(new Cursor(0));
            this.updateLineProfile();
        }
        return true;
    }

    private void configureBinningCombo() throws Exception {
        if (StaticInfo.cameraLabel_.length() > 0) {
            frame_.configureBinningComboForCamera(StaticInfo.cameraLabel_);
        }
    }

    public void initializeGUI() {
        try {
            this.staticInfo_.refreshValues();
            this.engine_.setZStageDevice(StaticInfo.zStageLabel_);
            this.configureBinningCombo();
            try {
                this.shutters_ = this.core_.getLoadedDevicesOfType(DeviceType.ShutterDevice);
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
            if (this.shutters_ != null) {
                String[] items = new String[(int)this.shutters_.size()];
                int i = 0;
                while ((long)i < this.shutters_.size()) {
                    items[i] = this.shutters_.get(i);
                    ++i;
                }
                frame_.initializeShutterGUI(items);
            }
            if (this.posListDlg_ != null) {
                this.posListDlg_.rebuildAxisList();
            }
            frame_.updateAutofocusButtons(this.afMgr_.getDevice() != null);
            this.updateGUI(true);
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
    }

    @Subscribe
    public void onPropertiesChanged(PropertiesChangedEvent event) {
        this.updateGUI(true);
    }

    @Subscribe
    public void onExposureChanged(ExposureChangedEvent event) {
        if (event.getCameraName().equals(StaticInfo.cameraLabel_)) {
            frame_.setDisplayedExposureTime(event.getNewExposureTime());
        }
    }

    public void updateGUI(boolean updateConfigPadStructure) {
        this.updateGUI(updateConfigPadStructure, false);
    }

    public void updateGUI(boolean updateConfigPadStructure, boolean fromCache) {
        ReportingUtils.logMessage("Updating GUI; config pad = " + updateConfigPadStructure + "; from cache = " + fromCache);
        try {
            this.staticInfo_.refreshValues();
            this.afMgr_.refresh();
            if (this.isCameraAvailable()) {
                double exp = this.core_.getExposure();
                frame_.setDisplayedExposureTime(exp);
                this.configureBinningCombo();
                String binSize = fromCache ? this.core_.getPropertyFromCache(StaticInfo.cameraLabel_, MMCoreJ.getG_Keyword_Binning()) : this.core_.getProperty(StaticInfo.cameraLabel_, MMCoreJ.getG_Keyword_Binning());
                frame_.setBinSize(binSize);
            }
            if (this.shutters_ != null) {
                String activeShutter = this.core_.getShutterDevice();
                frame_.setShutterComboSelection(activeShutter != null ? activeShutter : "");
            }
            frame_.setAutoShutterSelected(this.core_.getAutoShutter());
            frame_.setShutterButton(this.core_.getShutterOpen());
            if (this.snapLiveManager_.getIsLiveModeOn()) {
                frame_.setToggleShutterButtonEnabled(!this.core_.getAutoShutter());
            }
            ConfigGroupPad pad = frame_.getConfigPad();
            if (updateConfigPadStructure && pad != null) {
                pad.refreshStructure(fromCache);
                if (!fromCache) {
                    this.core_.updateSystemStateCache();
                }
            }
            this.updateChannelCombos();
            if (this.calibrationListDlg_ != null) {
                this.calibrationListDlg_.refreshCalibrations();
            }
            if (this.propertyBrowser_ != null) {
                this.propertyBrowser_.refresh();
            }
            ReportingUtils.logMessage("Finished updating GUI");
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
        frame_.updateTitle(this.sysConfigFile_);
    }

    public void stopAllActivity() {
        if (this.acquisitionEngine2010_ != null) {
            this.acquisitionEngine2010_.stop();
        }
        this.enableLiveMode(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanupOnClose(boolean calledByImageJ) {
        Object[] options;
        int n;
        if (this.configChanged_ && (n = JOptionPane.showOptionDialog(null, "Save Changed Configuration?", "Micro-Manager", 0, 3, null, options = new Object[]{"Yes", "No"}, options[0])) == 0) {
            this.saveConfigPresets();
            if (this.configChanged_) {
                return false;
            }
        }
        this.snapLiveManager_.setLiveMode(false);
        if (!calledByImageJ && !WindowManager.closeAllWindows()) {
            this.core_.logMessage("Failed to close some windows");
        }
        if (this.posListDlg_ != null) {
            this.removeMMBackgroundListener(this.posListDlg_);
            this.posListDlg_.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this.posListDlg_, 201));
            this.posListDlg_.dispose();
        }
        if (this.profileWin_ != null) {
            this.removeMMBackgroundListener(this.profileWin_);
            this.profileWin_.dispose();
        }
        if (this.scriptPanel_ != null) {
            this.removeMMBackgroundListener(this.scriptPanel_);
            this.scriptPanel_.closePanel();
        }
        if (this.pipelineFrame_ != null) {
            this.removeMMBackgroundListener(this.pipelineFrame_);
            this.pipelineFrame_.dispose();
        }
        if (this.propertyBrowser_ != null) {
            this.removeMMBackgroundListener(this.propertyBrowser_);
            this.propertyBrowser_.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this.propertyBrowser_, 201));
            this.propertyBrowser_.dispose();
        }
        if (this.acqControlWin_ != null) {
            this.removeMMBackgroundListener(this.acqControlWin_);
            this.acqControlWin_.close();
        }
        if (this.afMgr_ != null) {
            this.afMgr_.closeOptionsDialog();
        }
        if (this.engine_ != null) {
            this.engine_.shutdown();
            this.engine_.disposeProcessors();
        }
        this.pluginManager_.disposePlugins();
        Object object = this.shutdownLock_;
        synchronized (object) {
            EDTHangLogger.stopDefault();
            try {
                if (this.core_ != null) {
                    ReportingUtils.setCore(null);
                    this.core_.delete();
                    this.core_ = null;
                }
            }
            catch (Exception err) {
                ReportingUtils.showError(err);
            }
        }
        return true;
    }

    private void saveSettings() {
        frame_.savePrefs(this.mainPrefs_);
        this.mainPrefs_.put(OPEN_ACQ_DIR, this.openAcqDirectory_);
        this.mainPrefs_.put(MAIN_SAVE_METHOD, ImageUtils.getImageStorageClass().getName());
        if (this.afMgr_ != null && this.afMgr_.getDevice() != null) {
            this.mainPrefs_.put(AUTOFOCUS_DEVICE, this.afMgr_.getDevice().getDeviceName());
        }
    }

    public synchronized boolean closeSequence(boolean calledByImageJ) {
        block14: {
            int result22;
            if (!this.getIsProgramRunning()) {
                if (this.core_ != null) {
                    this.core_.logMessage("MMStudio::closeSequence called while isProgramRunning_ is false");
                }
                return true;
            }
            if (this.engine_ != null && this.engine_.isAcquisitionRunning() && (result22 = JOptionPane.showConfirmDialog(frame_, "Acquisition in progress. Are you sure you want to exit and discard all data?", "Micro-Manager", 0, 1)) == 1) {
                return false;
            }
            this.stopAllActivity();
            try {
                if (!this.acqMgr_.closeAllImageWindows()) {
                    return false;
                }
            }
            catch (MMScriptException result22) {
                // empty catch block
            }
            if (!this.cleanupOnClose(calledByImageJ)) {
                return false;
            }
            this.isProgramRunning_ = false;
            this.saveSettings();
            try {
                frame_.getConfigPad().saveSettings();
                this.options_.saveSettings();
                this.hotKeys_.saveSettings();
            }
            catch (NullPointerException e) {
                if (this.core_ == null) break block14;
                this.logError(e);
            }
        }
        if (this.options_.closeOnExit_) {
            if (!this.amRunningAsPlugin_) {
                System.exit(0);
            } else {
                ImageJ ij = IJ.getInstance();
                if (ij != null) {
                    ij.quit();
                }
            }
        } else {
            frame_.dispose();
        }
        return true;
    }

    public ContrastSettings getContrastSettings() {
        ImagePlus img = WindowManager.getCurrentImage();
        if (img == null || VirtualAcquisitionDisplay.getDisplay(img) == null) {
            return null;
        }
        return VirtualAcquisitionDisplay.getDisplay(img).getChannelContrastSettings(0);
    }

    public boolean getIsProgramRunning() {
        return this.isProgramRunning_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStartupScript() {
        File f = new File(this.startupScriptFile_);
        if (this.startupScriptFile_.length() > 0 && f.exists()) {
            WaitDialog waitDlg = new WaitDialog("Executing startup script, please wait...");
            waitDlg.showDialog();
            Interpreter interp = new Interpreter();
            try {
                interp.set(SCRIPT_CORE_OBJECT, (Object)this.core_);
                interp.set(SCRIPT_ACQENG_OBJECT, (Object)this.engine_);
                interp.set(SCRIPT_GUI_OBJECT, (Object)studio_);
                interp.eval(TextUtils.readTextFile(this.startupScriptFile_));
            }
            catch (IOException exc) {
                ReportingUtils.logError(exc, "Unable to read the startup script (" + this.startupScriptFile_ + ").");
            }
            catch (EvalError exc) {
                ReportingUtils.logError(exc);
            }
            finally {
                waitDlg.closeDialog();
            }
        } else if (this.startupScriptFile_.length() > 0) {
            ReportingUtils.logMessage("Startup script file (" + this.startupScriptFile_ + ") not present.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSystemConfiguration() {
        boolean result = true;
        this.saveMRUConfigFiles();
        WaitDialog waitDlg = new WaitDialog("Loading system configuration, please wait...");
        waitDlg.setAlwaysOnTop(true);
        waitDlg.showDialog();
        frame_.setEnabled(false);
        try {
            if (this.sysConfigFile_.length() > 0) {
                GUIUtils.preventDisplayAdapterChangeExceptions();
                this.core_.waitForSystem();
                this.coreCallback_.setIgnoring(true);
                this.core_.loadSystemConfiguration(this.sysConfigFile_);
                this.coreCallback_.setIgnoring(false);
                GUIUtils.preventDisplayAdapterChangeExceptions();
            }
        }
        catch (Exception err) {
            GUIUtils.preventDisplayAdapterChangeExceptions();
            waitDlg.closeDialog();
            ReportingUtils.showError(err, "Failed to load hardware configuation", null);
            result = false;
        }
        finally {
            waitDlg.closeDialog();
        }
        frame_.setEnabled(true);
        this.initializeGUI();
        this.toolsMenu_.updateSwitchConfigurationMenu();
        FileDialogs.storePath(MM_CONFIG_FILE, new File(this.sysConfigFile_));
        return result;
    }

    private void saveMRUConfigFiles() {
        if (0 < this.sysConfigFile_.length()) {
            if (this.MRUConfigFiles_.contains(this.sysConfigFile_)) {
                this.MRUConfigFiles_.remove(this.sysConfigFile_);
            }
            if (5 <= this.MRUConfigFiles_.size()) {
                this.MRUConfigFiles_.remove(4);
            }
            this.MRUConfigFiles_.add(0, this.sysConfigFile_);
            Integer icfg = 0;
            while (icfg < this.MRUConfigFiles_.size()) {
                String value = "";
                if (null != this.MRUConfigFiles_.get(icfg)) {
                    value = this.MRUConfigFiles_.get(icfg);
                }
                this.mainPrefs_.put(CFGFILE_ENTRY_BASE + icfg.toString(), value);
                icfg = icfg + 1;
            }
        }
    }

    public List<String> getMRUConfigFiles() {
        return this.MRUConfigFiles_;
    }

    private void loadMRUConfigFiles() {
        this.sysConfigFile_ = this.mainPrefs_.get(SYSTEM_CONFIG_FILE, this.sysConfigFile_);
        this.MRUConfigFiles_ = new ArrayList();
        Integer icfg = 0;
        while (icfg < 5) {
            File ruFile;
            String value = "";
            value = this.mainPrefs_.get(CFGFILE_ENTRY_BASE + icfg.toString(), value);
            if (0 < value.length() && (ruFile = new File(value)).exists() && !this.MRUConfigFiles_.contains(value)) {
                this.MRUConfigFiles_.add(value);
            }
            icfg = icfg + 1;
        }
        if (this.sysConfigFile_.length() > 0 && !this.MRUConfigFiles_.contains(this.sysConfigFile_)) {
            if (5 <= this.MRUConfigFiles_.size()) {
                this.MRUConfigFiles_.remove(4);
            }
            this.MRUConfigFiles_.add(0, this.sysConfigFile_);
        }
    }

    public void openAcqControlDialog() {
        try {
            if (this.acqControlWin_ == null) {
                this.acqControlWin_ = new AcqControlDlg(this.engine_, this.mainPrefs_, studio_, this.options_);
            }
            if (this.acqControlWin_.isActive()) {
                this.acqControlWin_.setTopPosition();
            }
            this.acqControlWin_.setVisible(true);
            this.acqControlWin_.repaint();
        }
        catch (Exception exc) {
            ReportingUtils.showError((Throwable)exc, "\nAcquistion window failed to open due to invalid or corrupted settings.\nTry resetting registry settings to factory defaults (Menu Tools|Options).");
        }
    }

    public void updateChannelCombos() {
        if (this.acqControlWin_ != null) {
            this.acqControlWin_.updateChannelAndGroupCombo();
        }
    }

    public void autofocusNow() {
        if (this.afMgr_.getDevice() != null) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        boolean lmo = MMStudio.this.isLiveModeOn();
                        if (lmo) {
                            MMStudio.this.enableLiveMode(false);
                        }
                        MMStudio.this.afMgr_.getDevice().fullFocus();
                        if (lmo) {
                            MMStudio.this.enableLiveMode(true);
                        }
                    }
                    catch (MMException ex) {
                        ReportingUtils.logError(ex);
                    }
                }
            }.start();
        }
    }

    private void testForAbortRequests() throws MMScriptException {
        if (this.scriptPanel_ != null && this.scriptPanel_.stopRequestPending()) {
            throw new MMScriptException("Script interrupted by the user!");
        }
    }

    @Override
    public String getVersion() {
        return "1.4.x dev";
    }

    @Override
    public void logStartupProperties() {
        String hostname;
        this.core_.logMessage("User: " + System.getProperty("user.name"));
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "unknown";
        }
        this.core_.logMessage("Host: " + hostname);
        this.core_.logMessage("MM Studio version: " + this.getVersion());
        this.core_.logMessage(this.core_.getVersionInfo());
        this.core_.logMessage(this.core_.getAPIVersionInfo());
        this.core_.logMessage("Operating System: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") " + System.getProperty("os.version"));
        this.core_.logMessage("JVM: " + System.getProperty("java.vm.name") + ", version " + System.getProperty("java.version") + ", " + System.getProperty("sun.arch.data.model") + "-bit");
    }

    @Override
    public void makeActive() {
        frame_.toFront();
    }

    @Override
    public boolean displayImage(TaggedImage ti) {
        this.normalizeTags(ti);
        return this.displayTaggedImage(ti, true);
    }

    @Override
    public void showXYPositionList() {
        this.checkPosListDlg();
        this.posListDlg_.setVisible(true);
    }

    @Override
    public void setConfigChanged(boolean status) {
        this.configChanged_ = status;
        frame_.setConfigSaveButtonStatus(this.configChanged_);
    }

    public boolean getIsConfigChanged() {
        return this.configChanged_;
    }

    @Override
    public void addMMBackgroundListener(Component comp) {
        if (this.MMFrames_.contains(comp)) {
            return;
        }
        this.MMFrames_.add(comp);
    }

    @Override
    public void removeMMBackgroundListener(Component comp) {
        if (!this.MMFrames_.contains(comp)) {
            return;
        }
        this.MMFrames_.remove(comp);
    }

    @Override
    public double getChannelExposureTime(String channelGroup, String channel, double defaultExp) {
        return this.exposurePrefs_.getDouble("Exposure_" + channelGroup + "_" + channel, defaultExp);
    }

    @Override
    public void setChannelExposureTime(String channelGroup, String channel, double exposure) {
        try {
            this.exposurePrefs_.putDouble("Exposure_" + channelGroup + "_" + channel, exposure);
            if (channelGroup != null && channelGroup.equals(this.core_.getChannelGroup()) && channel != null && !channel.equals("") && channel.equals(this.core_.getCurrentConfigFromCache(channelGroup))) {
                this.setExposure(exposure);
            }
        }
        catch (Exception ex) {
            ReportingUtils.logError("Failed to set Exposure prefs using Channelgroup: " + channelGroup + ", channel: " + channel + ", exposure: " + exposure);
        }
    }

    @Override
    public void enableRoiButtons(boolean enabled) {
        frame_.enableRoiButtons(enabled);
    }

    @Override
    public final Color getBackgroundColor() {
        return this.guiColors_.background.get(this.options_.displayBackground_);
    }

    @Override
    public void setBackgroundStyle(String backgroundType) {
        frame_.setBackground(this.guiColors_.background.get(backgroundType));
        frame_.paint(frame_.getGraphics());
        for (Component comp : this.MMFrames_) {
            if (comp == null) continue;
            comp.setBackground(this.guiColors_.background.get(backgroundType));
        }
    }

    @Override
    public String getBackgroundStyle() {
        return this.options_.displayBackground_;
    }

    @Override
    public ImageWindow getSnapLiveWin() {
        return this.snapLiveManager_.getSnapLiveWindow();
    }

    @Override
    public ImageCache getCacheForWindow(ImageWindow window) throws IllegalArgumentException {
        VirtualAcquisitionDisplay display = VirtualAcquisitionDisplay.getDisplay(window.getImagePlus());
        if (display == null) {
            throw new IllegalArgumentException("No matching Micro-Manager display for this window");
        }
        return display.getImageCache();
    }

    @Override
    public String runAcquisition() throws MMScriptException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new MMScriptException("Acquisition can not be run from this (EDT) thread");
        }
        this.testForAbortRequests();
        if (this.acqControlWin_ != null) {
            String name = this.acqControlWin_.runAcquisition();
            try {
                while (this.acqControlWin_.isAcquisitionRunning()) {
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException e) {
                ReportingUtils.showError(e);
            }
            return name;
        }
        throw new MMScriptException("Acquisition setup window must be open for this command to work.");
    }

    @Override
    public String runAcquisition(String name, String root) throws MMScriptException {
        this.testForAbortRequests();
        if (this.acqControlWin_ != null) {
            String acqName = this.acqControlWin_.runAcquisition(name, root);
            try {
                while (this.acqControlWin_.isAcquisitionRunning()) {
                    Thread.sleep(100L);
                }
                MMAcquisition acq = this.acqMgr_.getAcquisition(acqName);
                boolean finished = false;
                while (!finished) {
                    ImageCache imCache = acq.getImageCache();
                    if (imCache == null) continue;
                    if (imCache.isFinished()) {
                        finished = true;
                        continue;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                ReportingUtils.showError(e);
            }
            return acqName;
        }
        throw new MMScriptException("Acquisition setup window must be open for this command to work.");
    }

    @Override
    public void loadAcquisition(String path) throws MMScriptException {
        this.testForAbortRequests();
        try {
            this.engine_.shutdown();
            if (this.acqControlWin_ != null) {
                this.acqControlWin_.loadAcqSettingsFromFile(path);
            }
        }
        catch (MMScriptException ex) {
            throw new MMScriptException(ex.getMessage());
        }
    }

    @Override
    public void setPositionList(PositionList pl) throws MMScriptException {
        this.testForAbortRequests();
        this.posList_ = pl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MMStudio.this.posListDlg_ != null) {
                    MMStudio.this.posListDlg_.setPositionList(MMStudio.this.posList_);
                }
                if (MMStudio.this.engine_ != null) {
                    MMStudio.this.engine_.setPositionList(MMStudio.this.posList_);
                }
                if (MMStudio.this.acqControlWin_ != null) {
                    MMStudio.this.acqControlWin_.updateGUIContents();
                }
            }
        });
    }

    @Override
    public PositionList getPositionList() throws MMScriptException {
        this.testForAbortRequests();
        return this.posList_;
    }

    @Override
    public void sleep(long ms) throws MMScriptException {
        if (this.scriptPanel_ != null) {
            if (this.scriptPanel_.stopRequestPending()) {
                throw new MMScriptException("Script interrupted by the user!");
            }
            this.scriptPanel_.sleep(ms);
        }
    }

    @Override
    public String getUniqueAcquisitionName(String stub) {
        return this.acqMgr_.getUniqueAcquisitionName(stub);
    }

    public void openAcquisition(String name, String rootDir, int nrFrames, int nrChannels, int nrSlices, int nrPositions) throws MMScriptException {
        this.openAcquisition(name, rootDir, nrFrames, nrChannels, nrSlices, nrPositions, true, false);
    }

    public void openAcquisition(String name, String rootDir, int nrFrames, int nrChannels, int nrSlices) throws MMScriptException {
        this.openAcquisition(name, rootDir, nrFrames, nrChannels, nrSlices, 0);
    }

    public void openAcquisition(String name, String rootDir, int nrFrames, int nrChannels, int nrSlices, int nrPositions, boolean show) throws MMScriptException {
        this.openAcquisition(name, rootDir, nrFrames, nrChannels, nrSlices, nrPositions, show, false);
    }

    public void openAcquisition(String name, String rootDir, int nrFrames, int nrChannels, int nrSlices, boolean show) throws MMScriptException {
        this.openAcquisition(name, rootDir, nrFrames, nrChannels, nrSlices, 0, show, false);
    }

    @Override
    public void openAcquisition(String name, String rootDir, int nrFrames, int nrChannels, int nrSlices, int nrPositions, boolean show, boolean save) throws MMScriptException {
        if (nrFrames <= 0) {
            nrFrames = 1;
            ReportingUtils.logError("Coercing frame count to 1");
        }
        if (nrChannels <= 0) {
            nrChannels = 1;
            ReportingUtils.logError("Coercing channel count to 1");
        }
        if (nrSlices <= 0) {
            nrSlices = 1;
            ReportingUtils.logError("Coercing slice count to 1");
        }
        if (nrPositions <= 0) {
            nrPositions = 1;
            ReportingUtils.logError("Coercing position count to 1");
        }
        this.acqMgr_.openAcquisition(name, rootDir, show, save);
        MMAcquisition acq = this.acqMgr_.getAcquisition(name);
        acq.setDimensions(nrFrames, nrChannels, nrSlices, nrPositions);
    }

    public void openAcquisition(String name, String rootDir, int nrFrames, int nrChannels, int nrSlices, boolean show, boolean virtual) throws MMScriptException {
        this.openAcquisition(name, rootDir, nrFrames, nrChannels, nrSlices, 0, show, virtual);
    }

    @Override
    @Deprecated
    public String createAcquisition(JSONObject summaryMetadata, boolean diskCached, boolean displayOff) {
        return this.acqMgr_.createAcquisition(summaryMetadata, diskCached, this.engine_, displayOff);
    }

    private void initializeAcquisitionFromTags(String name, JSONObject tags) throws JSONException, MMScriptException {
        int width = MDUtils.getWidth(tags);
        int height = MDUtils.getHeight(tags);
        int byteDepth = MDUtils.getDepth(tags);
        int bitDepth = byteDepth * 8;
        if (MDUtils.hasBitDepth(tags)) {
            bitDepth = MDUtils.getBitDepth(tags);
        }
        this.initializeAcquisition(name, width, height, byteDepth, bitDepth);
    }

    @Override
    public void initializeAcquisition(String name, int width, int height, int byteDepth, int bitDepth) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(name);
        acq.setImagePhysicalDimensions(width, height, byteDepth, bitDepth, 1);
        acq.initialize();
    }

    @Override
    public int getAcquisitionImageWidth(String acqName) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(acqName);
        return acq.getWidth();
    }

    @Override
    public int getAcquisitionImageHeight(String acqName) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(acqName);
        return acq.getHeight();
    }

    @Override
    public int getAcquisitionImageBitDepth(String acqName) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(acqName);
        return acq.getBitDepth();
    }

    @Override
    public int getAcquisitionImageByteDepth(String acqName) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(acqName);
        return acq.getByteDepth();
    }

    @Override
    public int getAcquisitionMultiCamNumChannels(String acqName) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(acqName);
        return acq.getMultiCameraNumChannels();
    }

    @Override
    public Boolean acquisitionExists(String name) {
        return this.acqMgr_.acquisitionExists(name);
    }

    @Override
    public void closeAcquisition(String name) throws MMScriptException {
        this.acqMgr_.closeAcquisition(name);
    }

    @Override
    public void closeAcquisitionWindow(String acquisitionName) throws MMScriptException {
        this.acqMgr_.closeImageWindow(acquisitionName);
    }

    @Override
    public void refreshGUI() {
        this.updateGUI(true);
    }

    @Override
    public void refreshGUIFromCache() {
        this.updateGUI(true, true);
    }

    @Override
    public void setAcquisitionProperty(String acqName, String propertyName, String value) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(acqName);
        acq.setProperty(propertyName, value);
    }

    @Override
    public void setImageProperty(String acqName, int frame, int channel, int slice, String propName, String value) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(acqName);
        acq.setProperty(frame, channel, slice, propName, value);
    }

    @Override
    public String getCurrentAlbum() {
        return this.acqMgr_.getCurrentAlbum();
    }

    @Override
    public void enableLiveMode(boolean enable) {
        if (this.core_ == null) {
            return;
        }
        this.snapLiveManager_.setLiveMode(enable);
    }

    @Override
    public void addToAlbum(TaggedImage taggedImg) throws MMScriptException {
        this.addToAlbum(taggedImg, null);
    }

    public void addToAlbum(TaggedImage taggedImg, JSONObject displaySettings) throws MMScriptException {
        this.normalizeTags(taggedImg);
        this.acqMgr_.addToAlbum(taggedImg, displaySettings);
    }

    @Override
    public void addImageToAcquisition(String name, int frame, int channel, int slice, int position, TaggedImage taggedImg) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(name);
        if (acq.getPositions() <= 1 && position > 0) {
            throw new MMScriptException("The acquisition was open as a single position data set.\nOpen acqusition with two or more positions in order to crate a multi-position data set.");
        }
        if (acq.getChannels() <= channel) {
            throw new MMScriptException("This acquisition was opened with " + acq.getChannels() + " channels.\n" + "The channel number must not exceed declared number of positions.");
        }
        JSONObject tags = taggedImg.tags;
        if (!acq.isInitialized()) {
            try {
                this.initializeAcquisitionFromTags(name, tags);
            }
            catch (JSONException e) {
                throw new MMScriptException(e);
            }
        }
        try {
            MDUtils.setFrameIndex(tags, frame);
            MDUtils.setChannelIndex(tags, channel);
            MDUtils.setSliceIndex(tags, slice);
            MDUtils.setPositionIndex(tags, position);
            if (!MDUtils.hasSlicesFirst(tags) && !MDUtils.hasTimeFirst(tags)) {
                MDUtils.setSlicesFirst(tags, true);
                MDUtils.setTimeFirst(tags, false);
            }
            if (acq.getPositions() > 1 && !MDUtils.hasPositionName(tags)) {
                MDUtils.setPositionName(tags, "Pos" + position);
            }
            if (acq.getFrames() <= frame) {
                acq.setProperty("Frames", Integer.toString(frame + 1));
            }
        }
        catch (JSONException e) {
            throw new MMScriptException(e);
        }
        acq.insertImage(taggedImg);
    }

    @Override
    public void setAcquisitionAddImageAsynchronous(String name) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(name);
        acq.setAsynchronous();
    }

    @Override
    public void snapAndAddImage(String name, int frame, int channel, int slice, int position) throws MMScriptException {
        try {
            TaggedImage ti;
            if (this.core_.isSequenceRunning()) {
                ti = this.core_.getLastTaggedImage();
            } else {
                this.core_.snapImage();
                ti = this.core_.getTaggedImage();
            }
            MDUtils.setChannelIndex(ti.tags, channel);
            MDUtils.setFrameIndex(ti.tags, frame);
            MDUtils.setSliceIndex(ti.tags, slice);
            MDUtils.setPositionIndex(ti.tags, position);
            MMAcquisition acq = this.acqMgr_.getAcquisition(name);
            if (!acq.isInitialized()) {
                long width = this.core_.getImageWidth();
                long height = this.core_.getImageHeight();
                long depth = this.core_.getBytesPerPixel();
                long bitDepth = this.core_.getImageBitDepth();
                int multiCamNumCh = (int)this.core_.getNumberOfCameraChannels();
                acq.setImagePhysicalDimensions((int)width, (int)height, (int)depth, (int)bitDepth, multiCamNumCh);
                acq.initialize();
            }
            if (acq.getPositions() > 1) {
                MDUtils.setPositionName(ti.tags, "Pos" + position);
            }
            this.addImageToAcquisition(name, frame, channel, slice, position, ti);
        }
        catch (Exception e) {
            throw new MMScriptException(e);
        }
    }

    public void addImage(String name, TaggedImage taggedImg, boolean updateDisplay, boolean waitForDisplay) throws MMScriptException {
        this.acqMgr_.getAcquisition(name).insertImage(taggedImg, updateDisplay, waitForDisplay);
    }

    @Override
    public void closeAllAcquisitions() {
        this.acqMgr_.closeAll();
    }

    @Override
    public String[] getAcquisitionNames() {
        return this.acqMgr_.getAcquisitionNames();
    }

    @Override
    @Deprecated
    public MMAcquisition getAcquisition(String name) throws MMScriptException {
        return this.acqMgr_.getAcquisition(name);
    }

    public MMAcquisition getAcquisitionWithName(String name) throws MMScriptException {
        return this.acqMgr_.getAcquisition(name);
    }

    @Override
    public ImageCache getAcquisitionImageCache(String acquisitionName) throws MMScriptException {
        return this.getAcquisition(acquisitionName).getImageCache();
    }

    @Override
    public void message(final String text) throws MMScriptException {
        if (this.scriptPanel_ != null) {
            if (this.scriptPanel_.stopRequestPending()) {
                throw new MMScriptException("Script interrupted by the user!");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MMStudio.this.scriptPanel_ != null) {
                        MMStudio.this.scriptPanel_.message(text);
                    }
                }
            });
        }
    }

    @Override
    public void clearMessageWindow() throws MMScriptException {
        if (this.scriptPanel_ != null) {
            if (this.scriptPanel_.stopRequestPending()) {
                throw new MMScriptException("Script interrupted by the user!");
            }
            this.scriptPanel_.clearOutput();
        }
    }

    @Override
    public void setChannelContrast(String title, int channel, int min, int max) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(title);
        acq.setChannelContrast(channel, min, max);
    }

    @Override
    public void setChannelName(String title, int channel, String name) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(title);
        acq.setChannelName(channel, name);
    }

    @Override
    public void setChannelColor(String title, int channel, Color color) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(title);
        acq.setChannelColor(channel, color.getRGB());
    }

    @Override
    public void setContrastBasedOnFrame(String title, int frame, int slice) throws MMScriptException {
        MMAcquisition acq = this.acqMgr_.getAcquisition(title);
        acq.setContrastBasedOnFrame(frame, slice);
    }

    @Override
    public void setStagePosition(double z) throws MMScriptException {
        try {
            this.core_.setPosition(this.core_.getFocusDevice(), z);
            this.core_.waitForDevice(this.core_.getFocusDevice());
        }
        catch (Exception e) {
            throw new MMScriptException(e.getMessage());
        }
    }

    @Override
    public void setRelativeStagePosition(double z) throws MMScriptException {
        try {
            this.core_.setRelativePosition(this.core_.getFocusDevice(), z);
            this.core_.waitForDevice(this.core_.getFocusDevice());
        }
        catch (Exception e) {
            throw new MMScriptException(e.getMessage());
        }
    }

    @Override
    public void setXYStagePosition(double x, double y) throws MMScriptException {
        try {
            this.core_.setXYPosition(this.core_.getXYStageDevice(), x, y);
            this.core_.waitForDevice(this.core_.getXYStageDevice());
        }
        catch (Exception e) {
            throw new MMScriptException(e.getMessage());
        }
    }

    @Override
    public void setRelativeXYStagePosition(double x, double y) throws MMScriptException {
        try {
            this.core_.setRelativeXYPosition(this.core_.getXYStageDevice(), x, y);
            this.core_.waitForDevice(this.core_.getXYStageDevice());
        }
        catch (Exception e) {
            throw new MMScriptException(e.getMessage());
        }
    }

    @Override
    public Point2D.Double getXYStagePosition() throws MMScriptException {
        String stage = this.core_.getXYStageDevice();
        if (stage.length() == 0) {
            throw new MMScriptException("XY Stage device is not available");
        }
        double[] x = new double[1];
        double[] y = new double[1];
        try {
            this.core_.getXYPosition(stage, x, y);
            Point2D.Double pt = new Point2D.Double(x[0], y[0]);
            return pt;
        }
        catch (Exception e) {
            throw new MMScriptException(e.getMessage());
        }
    }

    @Override
    public String getXYStageName() {
        return this.core_.getXYStageDevice();
    }

    @Override
    public void setXYOrigin(double x, double y) throws MMScriptException {
        String xyStage = this.core_.getXYStageDevice();
        try {
            this.core_.setAdapterOriginXY(xyStage, x, y);
        }
        catch (Exception e) {
            throw new MMScriptException(e);
        }
    }

    public AcquisitionWrapperEngine getAcquisitionEngine() {
        return this.engine_;
    }

    public SnapLiveManager getSnapLiveManager() {
        return this.snapLiveManager_;
    }

    @Override
    public String installAutofocusPlugin(String className) {
        try {
            return this.installAutofocusPlugin(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            String msg = "Internal error: AF manager not instantiated.";
            ReportingUtils.logError(e, msg);
            return msg;
        }
    }

    public String installAutofocusPlugin(Class<?> autofocus) {
        String msg = autofocus.getSimpleName() + " module loaded.";
        if (this.afMgr_ != null) {
            this.afMgr_.setAFPluginClassName(autofocus.getSimpleName());
            try {
                this.afMgr_.refresh();
            }
            catch (MMException e) {
                msg = e.getMessage();
                ReportingUtils.logError(e);
            }
        } else {
            msg = "Internal error: AF manager not instantiated.";
        }
        return msg;
    }

    public CMMCore getCore() {
        return this.core_;
    }

    @Override
    public IAcquisitionEngine2010 getAcquisitionEngine2010() {
        try {
            this.acquisitionEngine2010LoadingThread_.join();
            if (this.acquisitionEngine2010_ == null) {
                this.acquisitionEngine2010_ = (IAcquisitionEngine2010)this.acquisitionEngine2010Class_.getConstructor(ScriptInterface.class).newInstance(studio_);
            }
            return this.acquisitionEngine2010_;
        }
        catch (IllegalAccessException e) {
            ReportingUtils.logError(e);
            return null;
        }
        catch (IllegalArgumentException e) {
            ReportingUtils.logError(e);
            return null;
        }
        catch (InstantiationException e) {
            ReportingUtils.logError(e);
            return null;
        }
        catch (InterruptedException e) {
            ReportingUtils.logError(e);
            return null;
        }
        catch (NoSuchMethodException e) {
            ReportingUtils.logError(e);
            return null;
        }
        catch (SecurityException e) {
            ReportingUtils.logError(e);
            return null;
        }
        catch (InvocationTargetException e) {
            ReportingUtils.logError(e);
            return null;
        }
    }

    @Override
    public void addImageProcessor(DataProcessor<TaggedImage> processor) {
        this.getAcquisitionEngine().addImageProcessor(processor);
    }

    @Override
    public void removeImageProcessor(DataProcessor<TaggedImage> processor) {
        this.getAcquisitionEngine().removeImageProcessor(processor);
    }

    public ArrayList<DataProcessor<TaggedImage>> getImageProcessorPipeline() {
        return this.getAcquisitionEngine().getImageProcessorPipeline();
    }

    @Override
    public void registerProcessorClass(Class<? extends DataProcessor<TaggedImage>> processorClass, String name) {
        this.getAcquisitionEngine().registerProcessorClass(processorClass, name);
    }

    @Override
    public void setImageProcessorPipeline(List<DataProcessor<TaggedImage>> pipeline) {
        this.getAcquisitionEngine().setImageProcessorPipeline(pipeline);
    }

    @Override
    public void setPause(boolean state) {
        this.getAcquisitionEngine().setPause(state);
    }

    @Override
    public boolean isPaused() {
        return this.getAcquisitionEngine().isPaused();
    }

    @Override
    public void attachRunnable(int frame, int position, int channel, int slice, Runnable runnable) {
        this.getAcquisitionEngine().attachRunnable(frame, position, channel, slice, runnable);
    }

    @Override
    public void clearRunnables() {
        this.getAcquisitionEngine().clearRunnables();
    }

    @Override
    public SequenceSettings getAcquisitionSettings() {
        if (this.engine_ == null) {
            return new SequenceSettings();
        }
        return this.engine_.getSequenceSettings();
    }

    @Override
    public void setAcquisitionSettings(SequenceSettings ss) {
        if (this.engine_ == null) {
            return;
        }
        this.engine_.setSequenceSettings(ss);
        this.acqControlWin_.updateGUIContents();
    }

    public void setAcqusitionSettings(SequenceSettings ss) {
        this.setAcquisitionSettings(ss);
    }

    @Override
    public String getAcquisitionPath() {
        if (this.engine_ == null) {
            return null;
        }
        return this.engine_.getImageCache().getDiskLocation();
    }

    @Override
    public void promptToSaveAcquisition(String name, boolean prompt) throws MMScriptException {
        this.getAcquisition(name).promptToSave(prompt);
    }

    @Override
    public void registerForEvents(Object obj) {
        EventManager.register(obj);
    }

    @Override
    public void unregisterForEvents(Object obj) {
        EventManager.unregister(obj);
    }

    @Override
    public void setROI(Rectangle r) throws MMScriptException {
        boolean liveRunning = false;
        if (this.isLiveModeOn()) {
            liveRunning = true;
            this.enableLiveMode(false);
        }
        try {
            this.core_.setROI(r.x, r.y, r.width, r.height);
        }
        catch (Exception e) {
            throw new MMScriptException(e.getMessage());
        }
        this.staticInfo_.refreshValues();
        if (liveRunning) {
            this.enableLiveMode(true);
        }
    }

    public void setAcquisitionEngine(AcquisitionWrapperEngine eng) {
        this.engine_ = eng;
    }

    @Override
    public Autofocus getAutofocus() {
        return this.afMgr_.getDevice();
    }

    @Override
    public void showAutofocusDialog() {
        if (this.afMgr_.getDevice() != null) {
            this.afMgr_.showOptionsDialog();
        }
    }

    @Override
    public AutofocusManager getAutofocusManager() {
        return this.afMgr_;
    }

    @Override
    public void setImageSavingFormat(Class imageSavingClass) throws MMScriptException {
        if (!imageSavingClass.equals(TaggedImageStorageDiskDefault.class) && !imageSavingClass.equals(TaggedImageStorageMultipageTiff.class)) {
            throw new MMScriptException("Unrecognized saving class");
        }
        ImageUtils.setImageStorageClass(imageSavingClass);
        if (this.acqControlWin_ != null) {
            this.acqControlWin_.updateSavingTypeButtons();
        }
    }

    @Override
    public void addMMListener(MMListenerInterface newL) {
        this.coreCallback_.addMMListener(newL);
    }

    @Override
    public void removeMMListener(MMListenerInterface oldL) {
        this.coreCallback_.removeMMListener(oldL);
    }

    @Override
    public void logMessage(String msg) {
        ReportingUtils.logMessage(msg);
    }

    @Override
    public void showMessage(String msg) {
        ReportingUtils.showMessage(msg);
    }

    @Override
    public void showMessage(String msg, Component parent) {
        ReportingUtils.showMessage(msg, parent);
    }

    @Override
    public void logError(Exception e, String msg) {
        ReportingUtils.logError(e, msg);
    }

    @Override
    public void logError(Exception e) {
        ReportingUtils.logError(e);
    }

    @Override
    public void logError(String msg) {
        ReportingUtils.logError(msg);
    }

    @Override
    public void showError(Exception e, String msg) {
        ReportingUtils.showError((Throwable)e, msg);
    }

    @Override
    public void showError(Exception e) {
        ReportingUtils.showError(e);
    }

    @Override
    public void showError(String msg) {
        ReportingUtils.showError(msg);
    }

    @Override
    public void showError(Exception e, String msg, Component parent) {
        ReportingUtils.showError(e, msg, parent);
    }

    @Override
    public void showError(Exception e, Component parent) {
        ReportingUtils.showError((Throwable)e, parent);
    }

    @Override
    public void showError(String msg, Component parent) {
        ReportingUtils.showError(msg, parent);
    }

    @Override
    public void autostretchCurrentWindow() {
        VirtualAcquisitionDisplay display = VirtualAcquisitionDisplay.getDisplay(WindowManager.getCurrentImage());
        if (display != null) {
            display.getHistograms().autoscaleAllChannels();
        }
    }

    static {
        MM_DATA_SET = new FileDialogs.FileType("MM_DATA_SET", "Micro-Manager Image Location", System.getProperty("user.home") + "/Untitled", false, null);
    }

    public static interface DisplayImageRoutine {
        public void show(TaggedImage var1);
    }
}

