/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class MMOptions {
    private static final String DEBUG_LOG = "DebugLog";
    private static final String PREF_DIR = "MMOptions";
    private static final String CLOSE_ON_EXIT = "CloseOnExit";
    private static final String SKIP_CONFIG = "SkipSplashScreen";
    private static final String BUFFSIZE_MB = "bufsize_mb";
    private static final String DISPLAY_BACKGROUND = "displayBackground";
    private static final String STARTUP_SCRIPT_FILE = "startupScript";
    private static final String AUTORELOAD_DEVICES = "autoreloadDevices";
    private static final String PREF_WINDOW_MAG = "windowMag";
    private static final String MPTIFF_METADATA_FILE = "MakeMetadataFileWithMultipageTiff";
    private static final String MPTIFF_SEPARATE_FILES_FOR_POSITIONS = "SplitXYPostionsInFilesMPTiff";
    private static final String SYNCEXPOSUREMAINANDMDA = "SyncExposureBetweenMainAndMDAWindows";
    private static final String HIDE_MDA_DISPLAY = "HideMDADisplay";
    private static final String FAST_STORAGE = "FastStorage";
    private static final String DELETE_OLD_CORELOGS = "DeleteOldCoreLogs";
    private static final String DELETE_CORELOG_AFTER_DAYS = "DeleteCoreLogAfterDays";
    public boolean debugLogEnabled_;
    public boolean doNotAskForConfigFile_;
    public boolean closeOnExit_;
    public int circularBufferSizeMB_;
    public String displayBackground_;
    public String startupScript_;
    public double windowMag_;
    public boolean mpTiffMetadataFile_;
    public boolean mpTiffSeparateFilesForPositions_;
    public boolean syncExposureMainAndMDA_;
    public boolean hideMDADisplay_;
    public boolean deleteOldCoreLogs_;
    public int deleteCoreLogAfterDays_;

    public MMOptions() {
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.debugLogEnabled_ = false;
        this.doNotAskForConfigFile_ = false;
        this.closeOnExit_ = true;
        boolean is64BitJVM = System.getProperty("sun.arch.data.model", "32").equals("64");
        this.circularBufferSizeMB_ = is64BitJVM ? 250 : 25;
        this.displayBackground_ = "Day";
        this.startupScript_ = "MMStartup.bsh";
        this.windowMag_ = 1.0;
        this.mpTiffMetadataFile_ = false;
        this.mpTiffSeparateFilesForPositions_ = true;
        this.syncExposureMainAndMDA_ = false;
        this.hideMDADisplay_ = false;
        this.deleteOldCoreLogs_ = false;
        this.deleteCoreLogAfterDays_ = 7;
    }

    private Preferences getPrefNode() {
        Preferences root = Preferences.userNodeForPackage(this.getClass());
        Preferences prefs = root.node(root.absolutePath() + "/" + PREF_DIR);
        return prefs;
    }

    public void saveSettings() {
        Preferences prefs = this.getPrefNode();
        prefs.putBoolean(DEBUG_LOG, this.debugLogEnabled_);
        prefs.putBoolean(SKIP_CONFIG, this.doNotAskForConfigFile_);
        prefs.putBoolean(CLOSE_ON_EXIT, this.closeOnExit_);
        prefs.putInt(BUFFSIZE_MB, this.circularBufferSizeMB_);
        prefs.put(DISPLAY_BACKGROUND, this.displayBackground_);
        prefs.put(STARTUP_SCRIPT_FILE, this.startupScript_);
        prefs.putDouble(PREF_WINDOW_MAG, this.windowMag_);
        prefs.putBoolean(MPTIFF_METADATA_FILE, this.mpTiffMetadataFile_);
        prefs.putBoolean(MPTIFF_SEPARATE_FILES_FOR_POSITIONS, this.mpTiffSeparateFilesForPositions_);
        prefs.putBoolean(SYNCEXPOSUREMAINANDMDA, this.syncExposureMainAndMDA_);
        prefs.putBoolean(HIDE_MDA_DISPLAY, this.hideMDADisplay_);
        prefs.putBoolean(DELETE_OLD_CORELOGS, this.deleteOldCoreLogs_);
        prefs.putInt(DELETE_CORELOG_AFTER_DAYS, this.deleteCoreLogAfterDays_);
    }

    public void loadSettings() {
        Preferences prefs = this.getPrefNode();
        this.debugLogEnabled_ = prefs.getBoolean(DEBUG_LOG, this.debugLogEnabled_);
        this.doNotAskForConfigFile_ = prefs.getBoolean(SKIP_CONFIG, this.doNotAskForConfigFile_);
        this.closeOnExit_ = prefs.getBoolean(CLOSE_ON_EXIT, this.closeOnExit_);
        this.circularBufferSizeMB_ = prefs.getInt(BUFFSIZE_MB, this.circularBufferSizeMB_);
        this.displayBackground_ = prefs.get(DISPLAY_BACKGROUND, this.displayBackground_);
        this.startupScript_ = prefs.get(STARTUP_SCRIPT_FILE, this.startupScript_);
        this.windowMag_ = prefs.getDouble(PREF_WINDOW_MAG, this.windowMag_);
        this.mpTiffMetadataFile_ = prefs.getBoolean(MPTIFF_METADATA_FILE, this.mpTiffMetadataFile_);
        this.mpTiffSeparateFilesForPositions_ = prefs.getBoolean(MPTIFF_SEPARATE_FILES_FOR_POSITIONS, this.mpTiffSeparateFilesForPositions_);
        this.syncExposureMainAndMDA_ = prefs.getBoolean(SYNCEXPOSUREMAINANDMDA, this.syncExposureMainAndMDA_);
        this.hideMDADisplay_ = prefs.getBoolean(HIDE_MDA_DISPLAY, this.hideMDADisplay_);
        this.deleteOldCoreLogs_ = prefs.getBoolean(DELETE_OLD_CORELOGS, this.deleteOldCoreLogs_);
        this.deleteCoreLogAfterDays_ = prefs.getInt(DELETE_CORELOG_AFTER_DAYS, this.deleteCoreLogAfterDays_);
    }

    public void resetSettings() throws BackingStoreException {
        this.getPrefNode().clear();
        this.setDefaultValues();
    }
}

