/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mmcorej.CMMCore;
import mmcorej.MMEventCallback;
import org.micromanager.acquisition.AcquisitionWrapperEngine;
import org.micromanager.api.MMListenerInterface;
import org.micromanager.events.EventManager;
import org.micromanager.events.MMListenerProxy;

public class CoreEventCallback
extends MMEventCallback {
    private final CMMCore core_;
    private final AcquisitionWrapperEngine engine_;
    private final List<MMListenerInterface> MMListeners_ = Collections.synchronizedList(new ArrayList());
    private volatile boolean ignorePropertyChanges_;

    public CoreEventCallback(CMMCore core, AcquisitionWrapperEngine engine) {
        this.core_ = core;
        this.engine_ = engine;
        this.core_.registerCallback((MMEventCallback)this);
        this.addMMListener(new MMListenerProxy(EventManager.getBus()));
    }

    public void onPropertiesChanged() {
        if (this.engine_ != null && this.engine_.isAcquisitionRunning()) {
            this.core_.logMessage("Notification from MMCore ignored because acquistion is running!", true);
            return;
        }
        if (this.ignorePropertyChanges_) {
            this.core_.logMessage("Notification from MMCore ignored since the system is still loading", true);
            return;
        }
        this.core_.updateSystemStateCache();
        this.core_.logMessage("Notification from MMCore!", true);
        for (MMListenerInterface mmIntf : this.MMListeners_) {
            mmIntf.propertiesChangedAlert();
        }
    }

    public void onPropertyChanged(String deviceName, String propName, String propValue) {
        if (this.ignorePropertyChanges_) {
            this.core_.logMessage("Notification for Device: " + deviceName + " Property: " + propName + " changed to value: " + propValue + " ignored since the system is still loading", true);
            return;
        }
        this.core_.logMessage("Notification for Device: " + deviceName + " Property: " + propName + " changed to value: " + propValue, true);
        for (MMListenerInterface mmIntf : this.MMListeners_) {
            mmIntf.propertyChangedAlert(deviceName, propName, propValue);
        }
    }

    public void onConfigGroupChanged(String groupName, String newConfig) {
        try {
            for (MMListenerInterface mmIntf : this.MMListeners_) {
                mmIntf.configGroupChangedAlert(groupName, newConfig);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onSystemConfigurationLoaded() {
        for (MMListenerInterface mmIntf : this.MMListeners_) {
            mmIntf.systemConfigurationLoaded();
        }
    }

    public void onPixelSizeChanged(double newPixelSizeUm) {
        for (MMListenerInterface mmIntf : this.MMListeners_) {
            mmIntf.pixelSizeChangedAlert(newPixelSizeUm);
        }
    }

    public void onStagePositionChanged(String deviceName, double pos) {
        if (deviceName.equals(this.core_.getFocusDevice())) {
            for (MMListenerInterface mmIntf : this.MMListeners_) {
                mmIntf.stagePositionChangedAlert(deviceName, pos);
            }
        }
    }

    public void onXYStagePositionChanged(String deviceName, double xPos, double yPos) {
        if (deviceName.equals(this.core_.getXYStageDevice())) {
            for (MMListenerInterface mmIntf : this.MMListeners_) {
                mmIntf.xyStagePositionChanged(deviceName, xPos, yPos);
            }
        }
    }

    public void onExposureChanged(String deviceName, double exposure) {
        for (MMListenerInterface mmIntf : this.MMListeners_) {
            mmIntf.exposureChanged(deviceName, exposure);
        }
    }

    public void onSLMExposureChanged(String deviceName, double exposure) {
        for (MMListenerInterface mmIntf : this.MMListeners_) {
            mmIntf.slmExposureChanged(deviceName, exposure);
        }
    }

    public final void addMMListener(MMListenerInterface newL) {
        if (this.MMListeners_.contains(newL)) {
            return;
        }
        this.MMListeners_.add(newL);
    }

    public void removeMMListener(MMListenerInterface oldL) {
        if (!this.MMListeners_.contains(oldL)) {
            return;
        }
        this.MMListeners_.remove(oldL);
    }

    public void setIgnoring(boolean isIgnoring) {
        this.ignorePropertyChanges_ = isIgnoring;
    }
}

