/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import com.swtdesigner.SwingResourceManager;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mmcorej.CMMCore;
import org.micromanager.ConfigGroupPad;
import org.micromanager.MMStudio;
import org.micromanager.api.ScriptInterface;
import org.micromanager.dialogs.GroupEditor;
import org.micromanager.dialogs.PresetEditor;
import org.micromanager.utils.ReportingUtils;

public final class ConfigPadButtonPanel
extends JPanel {
    private static final long serialVersionUID = 6481082898578589473L;
    private JButton addGroupButton_;
    private JButton removeGroupButton_;
    private JButton editGroupButton_;
    private JButton addPresetButton_;
    private JButton removePresetButton_;
    private JButton editPresetButton_;
    private ConfigGroupPad configPad_;
    private CMMCore core_;
    private ScriptInterface studio_;

    ConfigPadButtonPanel() {
        this.initialize();
    }

    public void initialize() {
        this.initializeWidgets();
    }

    public void initializeWidgets() {
        this.createLabel("Group:");
        this.addGroupButton_ = this.createButton("", "/org/micromanager/icons/plus.png");
        this.addGroupButton_.setName("Add group");
        this.addGroupButton_.setToolTipText("Create new group of properties");
        this.removeGroupButton_ = this.createButton("", "/org/micromanager/icons/minus.png");
        this.removeGroupButton_.setName("Remove group");
        this.removeGroupButton_.setToolTipText("Delete currently selected group");
        this.editGroupButton_ = this.createButton("Edit", "");
        this.editGroupButton_.setName("Edit group");
        this.editGroupButton_.setToolTipText("Edit currently selected group");
        this.createLabel("Preset:");
        this.addPresetButton_ = this.createButton("", "/org/micromanager/icons/plus.png");
        this.addPresetButton_.setName("Add preset");
        this.addPresetButton_.setToolTipText("Create new preset (set of values for each property in group)");
        this.removePresetButton_ = this.createButton("", "/org/micromanager/icons/minus.png");
        this.removePresetButton_.setName("Remove preset");
        this.removePresetButton_.setToolTipText("Delete currently selected preset");
        this.editPresetButton_ = this.createButton("Edit", "");
        this.editPresetButton_.setName("Remove preset");
        this.editPresetButton_.setToolTipText("Edit property values for currently selected preset");
        GridLayout layout = new GridLayout(1, 8, 2, 1);
        this.setLayout(layout);
    }

    public void setConfigPad(ConfigGroupPad configPad) {
        this.configPad_ = configPad;
    }

    public void setGUI(MMStudio gui) {
        this.studio_ = gui;
    }

    public void setCore(CMMCore core) {
        this.core_ = core;
    }

    public void format(JComponent theComp) {
        theComp.setFont(new Font("Arial", 0, 10));
        this.add(theComp);
    }

    public JLabel createLabel(String labelText) {
        JLabel theLabel = new JLabel(labelText);
        theLabel.setFont(new Font("Arial", 1, 10));
        theLabel.setHorizontalAlignment(4);
        this.add(theLabel);
        return theLabel;
    }

    public JButton createButton() {
        JButton theButton = new JButton();
        theButton.setIconTextGap(0);
        theButton.setMargin(new Insets(-50, -50, -50, -50));
        this.format(theButton);
        theButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigPadButtonPanel.this.handleButtonPress(e);
            }
        });
        return theButton;
    }

    public JButton createButton(String buttonText, String iconPath) {
        JButton theButton = this.createButton();
        theButton.setText(buttonText);
        if (iconPath.length() > 0) {
            theButton.setIcon(SwingResourceManager.getIcon(MMStudio.class, iconPath));
        }
        return theButton;
    }

    protected void handleButtonPress(ActionEvent e) {
        if (e.getSource() == this.addGroupButton_) {
            this.addGroup();
        }
        if (e.getSource() == this.removeGroupButton_) {
            this.removeGroup();
        }
        if (e.getSource() == this.editGroupButton_) {
            this.editGroup();
        }
        if (e.getSource() == this.addPresetButton_) {
            this.addPreset();
        }
        if (e.getSource() == this.removePresetButton_) {
            this.removePreset();
        }
        if (e.getSource() == this.editPresetButton_) {
            this.editPreset();
        }
        this.studio_.refreshGUI();
    }

    public void addGroup() {
        new GroupEditor("", "", this.studio_, this.core_, true);
    }

    public void removeGroup() {
        String groupName = this.configPad_.getSelectedGroup();
        if (groupName.length() > 0) {
            int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove group " + groupName + " and all associated presets?", "Remove the " + groupName + " group?", 0, 1);
            if (result == 0) {
                try {
                    this.core_.deleteConfigGroup(groupName);
                    this.studio_.setConfigChanged(true);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "If you want to remove a group, select it on the Configurations panel first.");
        }
    }

    public void editGroup() {
        String groupName = this.configPad_.getSelectedGroup();
        if (groupName.length() == 0) {
            JOptionPane.showMessageDialog(this, "To edit a group, please select it first, then press the edit button.");
        } else {
            new GroupEditor(groupName, this.configPad_.getPresetForSelectedGroup(), this.studio_, this.core_, false);
        }
    }

    public void addPreset() {
        String groupName = this.configPad_.getSelectedGroup();
        if (groupName.length() == 0) {
            JOptionPane.showMessageDialog(this, "To add a preset to a group, please select the group first, then press the edit button.");
        } else {
            new PresetEditor(groupName, "", this.studio_, this.core_, true);
        }
    }

    public void removePreset() {
        String groupName = this.configPad_.getSelectedGroup();
        String presetName = this.configPad_.getPresetForSelectedGroup();
        if (groupName.length() > 0) {
            if (this.core_.getAvailableConfigs(groupName).size() == 1L) {
                int result = JOptionPane.showConfirmDialog(this, "\"" + presetName + "\" is the last preset for the \"" + groupName + "\" group.\nDelete both preset and group?", "Remove last preset in group", 0, 1);
                if (result == 0) {
                    try {
                        this.core_.deleteConfig(groupName, presetName);
                        this.core_.deleteConfigGroup(groupName);
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                }
            } else {
                int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove preset " + presetName + " from the " + groupName + " group?", "Remove preset", 0, 1);
                if (result == 0) {
                    try {
                        this.core_.deleteConfig(groupName, presetName);
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                }
            }
        }
    }

    public String choosePreset(String groupName) {
        Object[] presets = this.core_.getAvailableConfigs(groupName).toArray();
        return (String)JOptionPane.showInputDialog(null, "Please choose a preset from the " + groupName + " group for editing.", "Preset not selected.", -1, null, presets, presets[0]);
    }

    public void editPreset() {
        String presetName = this.configPad_.getPresetForSelectedGroup();
        String groupName = this.configPad_.getSelectedGroup();
        if (groupName.length() == 0) {
            JOptionPane.showMessageDialog(this, "To edit a preset, please select the preset first, then press the edit button.");
        } else if (presetName.length() == 0) {
            String newPresetName = this.choosePreset(groupName);
            if (newPresetName != null) {
                try {
                    this.core_.setConfig(groupName, newPresetName);
                }
                catch (Exception ex) {
                    ReportingUtils.logError(ex);
                }
                new PresetEditor(groupName, newPresetName, this.studio_, this.core_, false);
            }
        } else {
            new PresetEditor(groupName, presetName, this.studio_, this.core_, false);
        }
    }

    public void handleException(Exception e) {
        ReportingUtils.logError(e);
    }
}

