/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.StrVector;
import org.micromanager.MMStudio;
import org.micromanager.api.ScriptInterface;
import org.micromanager.dialogs.PresetEditor;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.StateGroupCellRenderer;
import org.micromanager.utils.StateItem;
import org.micromanager.utils.StatePresetCellEditor;
import org.micromanager.utils.StatePresetCellRenderer;

public class ConfigGroupPad
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private JTable table_;
    private StateTableData data_;
    private ScriptInterface parentGUI_;
    Preferences prefs_;
    private final String COLUMN_WIDTH = "group_col_width";
    public PresetEditor presetEditor_ = null;
    public String groupName_ = "";

    public ConfigGroupPad() {
        Preferences root = Preferences.userNodeForPackage(this.getClass());
        this.prefs_ = root.node(root.absolutePath() + "/PresetPad");
    }

    private void handleException(Exception e) {
        ReportingUtils.showError(e);
    }

    public void setCore(CMMCore core) {
        this.table_ = new JTable();
        this.table_.setSelectionMode(0);
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setRowSelectionAllowed(true);
        this.setViewportView(this.table_);
        this.data_ = new StateTableData(core);
        this.table_.setModel(this.data_);
        this.table_.addColumn(new TableColumn(0, 200, new StateGroupCellRenderer(), null));
        this.table_.addColumn(new TableColumn(1, 200, new StatePresetCellRenderer(), new StatePresetCellEditor()));
        int colWidth = this.prefs_.getInt("group_col_width", 0);
        if (colWidth > 0) {
            this.table_.getColumnModel().getColumn(0).setPreferredWidth(colWidth);
        }
    }

    public void saveSettings() {
        if (this.prefs_ != null && this.table_ != null) {
            this.prefs_.putInt("group_col_width", this.table_.getColumnModel().getColumn(0).getWidth());
        }
    }

    public void setParentGUI(ScriptInterface parentGUI) {
        this.parentGUI_ = parentGUI;
    }

    public void refreshStructure(boolean fromCache) {
        if (this.data_ != null) {
            this.data_.rebuildModel(fromCache);
            this.data_.fireTableStructureChanged();
            this.table_.repaint();
        }
    }

    public void refreshGroup(String groupName, String configName) {
        if (this.data_ != null) {
            this.data_.refreshGroup(groupName, configName);
            this.data_.fireTableStructureChanged();
            this.table_.repaint();
        }
    }

    public String getSelectedGroup() {
        int idx = this.table_.getSelectedRow();
        if (idx < 0 || this.data_.getRowCount() <= 0) {
            return "";
        }
        return (String)this.data_.getValueAt(idx, 0);
    }

    public void setSelectedGroup(String groupName) {
        for (int i = 0; i < this.data_.getRowCount(); ++i) {
            if (!this.data_.getValueAt(i, 0).toString().contentEquals(groupName)) continue;
            this.table_.setRowSelectionInterval(i, i);
        }
    }

    public String getPresetForSelectedGroup() {
        int idx = this.table_.getSelectedRow();
        if (idx < 0 || this.data_.getRowCount() <= 0) {
            return "";
        }
        try {
            return this.data_.core_.getCurrentConfig((String)this.data_.getValueAt(idx, 0));
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
            return null;
        }
    }

    public final class StateTableData
    extends AbstractTableModel {
        private static final long serialVersionUID = -6584881796860806078L;
        public final String[] columnNames_ = new String[]{"Group", "Preset"};
        ArrayList<StateItem> groupList_ = new ArrayList();
        private CMMCore core_ = null;

        public StateTableData(CMMCore core) {
            this.core_ = core;
            this.rebuildModel(false);
        }

        @Override
        public int getRowCount() {
            return this.groupList_.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames_.length;
        }

        public StateItem getPropertyItem(int row) {
            return this.groupList_.get(row);
        }

        @Override
        public Object getValueAt(int row, int col) {
            StateItem item = this.groupList_.get(row);
            if (col == 0) {
                return item.group;
            }
            if (col == 1) {
                return item.config;
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            StateItem item = this.groupList_.get(row);
            if (col == 1) {
                try {
                    if (value != null && value.toString().length() > 0) {
                        boolean restartLive = ConfigGroupPad.this.parentGUI_.isLiveModeOn();
                        if (restartLive) {
                            ConfigGroupPad.this.parentGUI_.enableLiveMode(false);
                        }
                        if (item.singleProp) {
                            if (item.hasLimits && item.isInteger()) {
                                this.core_.setProperty(item.device, item.name, NumberUtils.intStringDisplayToCore(value));
                            } else if (item.hasLimits && !item.isInteger()) {
                                this.core_.setProperty(item.device, item.name, NumberUtils.doubleStringDisplayToCore(value));
                            } else {
                                this.core_.setProperty(item.device, item.name, value.toString());
                            }
                            this.core_.waitForDevice(item.device);
                        } else {
                            this.core_.setConfig(item.group, value.toString());
                            this.core_.waitForConfig(item.group, value.toString());
                        }
                        if (item.group.equals(this.core_.getChannelGroup())) {
                            this.core_.setExposure(ConfigGroupPad.this.parentGUI_.getChannelExposureTime(item.group, value.toString(), this.core_.getExposure()));
                        }
                        this.refreshStatus();
                        ConfigGroupPad.this.table_.repaint();
                        if (ConfigGroupPad.this.parentGUI_ != null) {
                            if (ConfigGroupPad.this.parentGUI_ instanceof MMStudio) {
                                MMStudio parentGUI = (MMStudio)ConfigGroupPad.this.parentGUI_;
                                parentGUI.updateGUI(false);
                            } else {
                                ConfigGroupPad.this.parentGUI_.refreshGUI();
                            }
                        }
                        if (restartLive) {
                            ConfigGroupPad.this.parentGUI_.enableLiveMode(true);
                        }
                    }
                }
                catch (Exception e) {
                    ConfigGroupPad.this.handleException(e);
                }
            }
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames_[column];
        }

        @Override
        public boolean isCellEditable(int nRow, int nCol) {
            return nCol != 0;
        }

        public void rebuildModel(boolean fromCache) {
            try {
                ReportingUtils.logMessage("Rebuilding config group table");
                StrVector groups = this.core_.getAvailableConfigGroups();
                this.groupList_.clear();
                for (String group : groups) {
                    Configuration cfg;
                    StateItem item = new StateItem();
                    item.group = group;
                    item.config = fromCache ? this.core_.getCurrentConfigFromCache(item.group) : this.core_.getCurrentConfig(item.group);
                    item.allowed = this.core_.getAvailableConfigs(item.group).toArray();
                    if (item.config.length() > 0) {
                        Configuration curCfg = this.core_.getConfigData(item.group, item.config);
                        item.descr = curCfg.getVerbose();
                    } else {
                        item.descr = "";
                    }
                    if (item.allowed.length == 1 && (cfg = this.core_.getConfigData(item.group, item.allowed[0])).size() == 1L) {
                        boolean itemHasAllowedValues;
                        item.device = cfg.getSetting(0L).getDeviceLabel();
                        item.name = cfg.getSetting(0L).getPropertyName();
                        item.hasLimits = this.core_.hasPropertyLimits(item.device, item.name);
                        boolean bl = itemHasAllowedValues = 0L < this.core_.getAllowedPropertyValues(item.device, item.name).size();
                        if (item.hasLimits || !itemHasAllowedValues) {
                            item.singleProp = true;
                            item.type = this.core_.getPropertyType(item.device, item.name);
                            if (fromCache) {
                                item.setValueFromCoreString(this.core_.getPropertyFromCache(item.device, item.name));
                            } else {
                                item.setValueFromCoreString(this.core_.getProperty(item.device, item.name));
                            }
                            item.config = item.value;
                            item.lowerLimit = this.core_.getPropertyLowerLimit(item.device, item.name);
                            item.upperLimit = this.core_.getPropertyUpperLimit(item.device, item.name);
                            item.singlePropAllowed = this.core_.getAllowedPropertyValues(item.device, item.name).toArray();
                        }
                    }
                    this.groupList_.add(item);
                }
                ReportingUtils.logMessage("Finished rebuilding config group table");
            }
            catch (Exception e) {
                ConfigGroupPad.this.handleException(e);
            }
        }

        public void refreshStatus() {
            try {
                ReportingUtils.logMessage("Refreshing config group table");
                for (StateItem item : this.groupList_) {
                    if (item.singleProp) {
                        item.setValueFromCoreString(this.core_.getProperty(item.device, item.name));
                        item.config = item.value;
                        continue;
                    }
                    item.config = this.core_.getCurrentConfig(item.group);
                    if (item.config.length() > 0) {
                        Configuration curCfg = this.core_.getConfigData(item.group, item.config);
                        item.descr = curCfg.getVerbose();
                        continue;
                    }
                    item.descr = "";
                }
                ReportingUtils.logMessage("Finished refreshing config group table");
            }
            catch (Exception e) {
                ConfigGroupPad.this.handleException(e);
            }
        }

        public void refreshGroup(String groupName, String configName) {
            try {
                for (StateItem item : this.groupList_) {
                    if (!item.group.equals(groupName)) continue;
                    item.config = configName;
                }
            }
            catch (Exception e) {
                ConfigGroupPad.this.handleException(e);
            }
        }
    }
}

