/*
 * Decompiled with CFR 0.152.
 */
package com.quirkware.guid;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import org.micromanager.utils.ReportingUtils;

public class PlatformIndependentGuidGen {
    private static PlatformIndependentGuidGen _TheInstance = null;
    private Random _RandomForSpace = null;
    private Random _RandomForTime = null;

    public static synchronized PlatformIndependentGuidGen getInstance() {
        if (_TheInstance == null) {
            _TheInstance = new PlatformIndependentGuidGen();
        }
        return _TheInstance;
    }

    public String genNewGuid() {
        long uniqueInSpace = this._RandomForSpace.nextLong();
        long uniqueInTime = this._RandomForTime.nextLong();
        return Long.toHexString(uniqueInSpace) + "-" + Long.toHexString(uniqueInTime);
    }

    private PlatformIndependentGuidGen() {
        long uniqueSpaceSeed = this.createUniqueSpaceSeed();
        long uniqueTimeSeed = System.currentTimeMillis();
        this._RandomForSpace = new Random(uniqueSpaceSeed);
        this._RandomForTime = new Random(uniqueTimeSeed);
    }

    private long createUniqueSpaceSeed() {
        String hashingString = "";
        Properties systemProps = System.getProperties();
        Enumeration<Object> systemPropKeys = systemProps.keys();
        String systemPropKey = null;
        Locale[] locales = Locale.getAvailableLocales();
        int iCounter = 0;
        Runtime runtime = Runtime.getRuntime();
        InetAddress myAddress = null;
        while (systemPropKeys.hasMoreElements()) {
            systemPropKey = (String)systemPropKeys.nextElement();
            hashingString = hashingString + " " + systemPropKey + " = " + systemProps.getProperty(systemPropKey) + "\n";
        }
        hashingString = hashingString + "Cycle Test = " + this.cpuCycleTest() + "\n";
        for (iCounter = 0; iCounter < locales.length; ++iCounter) {
            hashingString = hashingString + locales[iCounter].getCountry() + " " + locales[iCounter].getDisplayCountry() + " " + locales[iCounter].getDisplayName() + "\n";
        }
        hashingString = hashingString + "Available proc = " + runtime.availableProcessors() + "\n";
        hashingString = hashingString + "free memory = " + runtime.freeMemory() + "\n";
        hashingString = hashingString + "max memory = " + runtime.maxMemory() + "\n";
        hashingString = hashingString + "total memory = " + runtime.totalMemory() + "\n";
        try {
            myAddress = InetAddress.getLocalHost();
            hashingString = hashingString + "my IP address = " + myAddress.toString();
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
        return hashingString.hashCode();
    }

    private long cpuCycleTest() {
        long returnValue;
        long startTime = System.currentTimeMillis();
        long rightNow = System.currentTimeMillis();
        for (returnValue = 0L; rightNow - startTime < 10L && returnValue < 0x7FFFFFFFFFFFFFF5L; ++returnValue) {
            rightNow = System.currentTimeMillis();
        }
        return returnValue;
    }
}

