/*
 * Decompiled with CFR 0.152.
 */
import ij.CommandListener;
import ij.Executer;
import ij.IJ;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.micromanager.MMStudio;
import org.micromanager.imagedisplay.AcquisitionVirtualStack;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.ReportingUtils;

public class MMStudioPlugin
implements PlugIn,
CommandListener {
    static MMStudio studio_;
    private boolean frameSuccessfullyClosed = true;

    public void run(final String arg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (studio_ == null || !studio_.getIsProgramRunning()) {
                        if (JavaUtils.isMac()) {
                            System.setProperty("apple.laf.useScreenMenuBar", "true");
                        }
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                        catch (Exception e) {
                            ReportingUtils.logError(e);
                        }
                        IJ.versionLessThan((String)"1.48g");
                        if (!IJ.versionLessThan((String)"1.46e")) {
                            Executer.addCommandListener((CommandListener)MMStudioPlugin.this);
                        }
                        studio_ = new MMStudio(true);
                        MMStudio.getFrame().setVisible(true);
                        MMStudio.getFrame().setDefaultCloseOperation(0);
                    }
                    if (arg.equals("OpenAcq")) {
                        studio_.promptForAcquisitionToOpen(true);
                    }
                }
                catch (Exception e) {
                    ReportingUtils.logError(e);
                }
            }
        });
    }

    private void setFrameClosingResult(boolean res) {
        this.frameSuccessfullyClosed = res;
    }

    public String commandExecuting(String command) {
        if (command.equalsIgnoreCase("Quit") && studio_ != null) {
            try {
                GUIUtils.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        boolean result = true;
                        if (!studio_.closeSequence(true)) {
                            result = false;
                        }
                        MMStudioPlugin.this.setFrameClosingResult(result);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.frameSuccessfullyClosed) {
                return null;
            }
            return command;
        }
        if (command.equals("Crop")) {
            if (IJ.getImage().getStack() instanceof AcquisitionVirtualStack) {
                new Duplicator().run(IJ.getImage()).show();
                return null;
            }
        } else if (command.equals("Add Noise") && IJ.getImage().getStack() instanceof AcquisitionVirtualStack) {
            AcquisitionVirtualStack avs = (AcquisitionVirtualStack)IJ.getImage().getStack();
            if (avs.getVirtualAcquisitionDisplay().isDiskCached()) {
                new Duplicator().run(IJ.getImage()).show();
            } else if (!IJ.showMessageWithCancel((String)"Micro-Manager data not saved", (String)"Data are not saved and Undo is impossible. \nDo you really want to execute the command?")) {
                return null;
            }
        }
        return command;
    }
}

