/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public class BoundedSortedList<E extends Comparable<E>>
extends ArrayList<E>
implements Serializable {
    private static final long serialVersionUID = 5503813399376102571L;
    private final int maxSize;

    public BoundedSortedList(int maxSize, int initialCapacity) {
        super(initialCapacity);
        if (maxSize < 1) {
            throw new RuntimeException("Invalid max size");
        }
        this.maxSize = maxSize;
    }

    public BoundedSortedList(int maxSize) {
        if (maxSize < 1) {
            throw new RuntimeException("Invalid max size");
        }
        this.maxSize = maxSize;
    }

    @Override
    public boolean add(E e) {
        if (this.isEmpty()) {
            super.add(e);
            return true;
        }
        int ind = Collections.binarySearch(this, e);
        if (ind >= 0) {
            if (this.size() == this.maxSize) {
                this.remove(this.maxSize - 1);
                super.add(ind, e);
            } else if (ind > this.size()) {
                super.add(e);
            } else {
                super.add(ind, e);
            }
            return true;
        }
        ind = -(ind + 1);
        if (this.size() < this.maxSize) {
            super.add(ind, e);
        } else if (ind < this.maxSize) {
            this.remove(this.maxSize - 1);
            super.add(ind, e);
        } else {
            return false;
        }
        return true;
    }

    public E first() {
        if (this.isEmpty()) {
            return null;
        }
        return (E)((Comparable)this.get(0));
    }

    public E last() {
        if (this.isEmpty()) {
            return null;
        }
        return (E)((Comparable)this.get(this.size() - 1));
    }

    @Override
    public void add(int index, E element) {
        this.add(element);
    }

    public int maxSize() {
        return this.maxSize;
    }
}

