/*
 * Decompiled with CFR 0.152.
 */
package jsat.regression.evaluation;

import jsat.math.OnLineStatistics;
import jsat.regression.evaluation.RegressionScore;

public class MeanAbsoluteError
implements RegressionScore {
    private static final long serialVersionUID = -637676526509989776L;
    private OnLineStatistics absError;

    public MeanAbsoluteError() {
    }

    public MeanAbsoluteError(MeanAbsoluteError toCopy) {
        if (toCopy.absError != null) {
            this.absError = toCopy.absError.clone();
        }
    }

    @Override
    public void prepare() {
        this.absError = new OnLineStatistics();
    }

    @Override
    public void addResult(double prediction, double trueValue, double weight) {
        if (this.absError == null) {
            throw new RuntimeException("regression score has not been initialized");
        }
        this.absError.add(Math.abs(prediction - trueValue), weight);
    }

    @Override
    public void addResults(RegressionScore other) {
        MeanAbsoluteError otherObj = (MeanAbsoluteError)other;
        if (otherObj.absError != null) {
            this.absError.add(otherObj.absError);
        }
    }

    @Override
    public double getScore() {
        return this.absError.getMean();
    }

    @Override
    public boolean lowerIsBetter() {
        return true;
    }

    @Override
    public MeanAbsoluteError clone() {
        return new MeanAbsoluteError(this);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.getClass().isAssignableFrom(obj.getClass()) && obj.getClass().isAssignableFrom(this.getClass());
    }

    @Override
    public String getName() {
        return "Mean Absolute Error";
    }
}

