/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.utils.DoubleList;
import jsat.utils.IntList;

public interface VectorCollection<V extends Vec>
extends Cloneable,
Serializable {
    default public void build(List<V> collection) {
        this.build(false, collection);
    }

    default public void build(List<V> collection, DistanceMetric dm) {
        this.build(false, collection, dm);
    }

    default public void build(boolean parallel, List<V> collection) {
        this.build(parallel, collection, this.getDistanceMetric());
    }

    public void build(boolean var1, List<V> var2, DistanceMetric var3);

    public void setDistanceMetric(DistanceMetric var1);

    public DistanceMetric getDistanceMetric();

    default public List<? extends VecPaired<V, Double>> search(Vec query, double range) {
        IntList neighbors = new IntList();
        DoubleList distances = new DoubleList();
        this.search(query, range, (List<Integer>)neighbors, (List<Double>)distances);
        ArrayList<VecPaired<V, Double>> toRet = new ArrayList<VecPaired<V, Double>>();
        for (int i = 0; i < neighbors.size(); ++i) {
            toRet.add(new VecPaired<V, Double>(this.get(neighbors.getI(i)), distances.getD(i)));
        }
        return toRet;
    }

    default public List<? extends VecPaired<V, Double>> search(Vec query, int num_neighbors) {
        IntList neighbors = new IntList();
        DoubleList distances = new DoubleList();
        this.search(query, num_neighbors, (List<Integer>)neighbors, (List<Double>)distances);
        ArrayList<VecPaired<V, Double>> toRet = new ArrayList<VecPaired<V, Double>>();
        for (int i = 0; i < neighbors.size(); ++i) {
            toRet.add(new VecPaired<V, Double>(this.get(neighbors.getI(i)), distances.getD(i)));
        }
        return toRet;
    }

    public void search(Vec var1, double var2, List<Integer> var4, List<Double> var5);

    public void search(Vec var1, int var2, List<Integer> var3, List<Double> var4);

    public V get(int var1);

    public int size();

    public VectorCollection<V> clone();
}

