/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.List;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.VPTreeMV;
import jsat.linear.vectorcollection.VectorArray;
import jsat.linear.vectorcollection.VectorCollection;

public class DefaultVectorCollection<V extends Vec>
implements VectorCollection<V> {
    private DistanceMetric dm;
    VectorCollection<V> base;

    public DefaultVectorCollection() {
        this(new EuclideanDistance());
    }

    public DefaultVectorCollection(DistanceMetric dm) {
        this.setDistanceMetric(dm);
    }

    public DefaultVectorCollection(DistanceMetric dm, List<V> vecs) {
        this(dm, vecs, false);
    }

    public DefaultVectorCollection(DistanceMetric dm, List<V> vecs, boolean parallel) {
        this.setDistanceMetric(dm);
        this.build(parallel, vecs, dm);
    }

    public DefaultVectorCollection(DefaultVectorCollection toCopy) {
        this.dm = toCopy.dm.clone();
        if (toCopy.base != null) {
            this.base = toCopy.base.clone();
        }
    }

    @Override
    public void build(boolean parallel, List<V> collection, DistanceMetric dm) {
        int N = collection.size();
        this.base = N <= 20 || !dm.isValidMetric() ? new VectorArray() : new VPTreeMV();
        this.base.build(parallel, collection, dm);
    }

    @Override
    public void setDistanceMetric(DistanceMetric dm) {
        this.dm = dm;
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        return this.dm;
    }

    @Override
    public void search(Vec query, double range, List<Integer> neighbors, List<Double> distances) {
        this.base.search(query, range, neighbors, distances);
    }

    @Override
    public void search(Vec query, int numNeighbors, List<Integer> neighbors, List<Double> distances) {
        this.base.search(query, numNeighbors, neighbors, distances);
    }

    @Override
    public V get(int indx) {
        return this.base.get(indx);
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public DefaultVectorCollection<V> clone() {
        return new DefaultVectorCollection<V>(this);
    }
}

