/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.vectorcollection.IncrementalCollection;
import jsat.linear.vectorcollection.IndexDistPair;
import jsat.math.FastMath;
import jsat.utils.BoundedSortedList;
import jsat.utils.DoubleList;
import jsat.utils.IndexTable;
import jsat.utils.IntList;
import jsat.utils.ListUtils;
import jsat.utils.random.XORWOW;

public final class CoverTree<V extends Vec>
implements IncrementalCollection<V> {
    private DistanceMetric dm;
    private List<V> vecs;
    private List<Double> accell_cache = null;
    private TreeNode root = null;
    private boolean maxDistDirty = false;
    private boolean looseBounds = false;
    private static final int min_pow_map = -120;
    private static final int max_pow_map = 1000;
    private static final float[] pow_map = new float[1120];
    private static final double base = 1.3;
    private static final double log2_base = Math.log(1.3) / Math.log(2.0);

    private static double pow(int expo) {
        if (expo >= -120 && expo < 1000) {
            return pow_map[expo - -120];
        }
        return Math.pow(1.3, expo);
    }

    public CoverTree(DistanceMetric dm) {
        this.dm = dm;
        this.vecs = new ArrayList<V>();
    }

    public CoverTree(List<V> source, DistanceMetric dm) {
        this(source, dm, false);
    }

    public CoverTree(List<V> source, DistanceMetric dm, boolean parallel) {
        this(source, dm, parallel, false);
    }

    public CoverTree(List<V> source, DistanceMetric dm, boolean parallel, boolean looseBounds) {
        this.setLooseBounds(looseBounds);
        this.build(parallel, source, dm);
    }

    public CoverTree(CoverTree<V> toCopy) {
        this.dm = toCopy.dm.clone();
        this.looseBounds = toCopy.looseBounds;
        this.vecs = new ArrayList<V>(toCopy.vecs);
        if (toCopy.accell_cache != null) {
            this.accell_cache = new DoubleList(toCopy.accell_cache);
        }
        if (toCopy.root != null) {
            this.root = new TreeNode(toCopy.root);
        }
    }

    @Override
    public void build(boolean parallel, List<V> collection, DistanceMetric dm) {
        this.dm = dm;
        this.setLooseBounds(this.looseBounds);
        this.vecs = new ArrayList<V>(collection);
        this.accell_cache = dm.getAccelerationCache(this.vecs, parallel);
        IntList order = new IntList(this.vecs.size());
        ListUtils.addRange(order, 0, this.vecs.size(), 1);
        Collections.shuffle(order, new XORWOW(54321L));
        int pos = 0;
        Iterator iterator = order.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.root = this.simpleInsert(this.root, i);
            ++pos;
        }
        if (!this.looseBounds) {
            this.root.maxdist();
            Iterator iter = this.root.descendants();
            while (iter.hasNext()) {
                ((TreeNode)iter.next()).maxdist();
            }
        }
    }

    @Override
    public void setDistanceMetric(DistanceMetric dm) {
        this.dm = dm;
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        return this.dm;
    }

    public void setLooseBounds(boolean looseBounds) {
        this.looseBounds = looseBounds;
    }

    @Override
    public void search(Vec query, double range, List<Integer> neighbors, List<Double> distances) {
        neighbors.clear();
        distances.clear();
        this.root.findNN(range, query, this.dm.getQueryInfo(query), neighbors, distances, -1.0);
        IndexTable it = new IndexTable(distances);
        it.apply(distances);
        it.apply(neighbors);
    }

    @Override
    public void search(Vec query, int numNeighbors, List<Integer> neighbors, List<Double> distances) {
        BoundedSortedList<IndexDistPair> bsl = new BoundedSortedList<IndexDistPair>(numNeighbors);
        this.root.findNN(numNeighbors, query, this.dm.getQueryInfo(query), bsl, -1.0);
        neighbors.clear();
        distances.clear();
        for (IndexDistPair a : bsl) {
            neighbors.add(a.getIndex());
            distances.add(a.getDist());
        }
    }

    @Override
    public int size() {
        return this.vecs.size();
    }

    @Override
    public V get(int indx) {
        return (V)((Vec)this.vecs.get(indx));
    }

    @Override
    public CoverTree<V> clone() {
        return new CoverTree<V>(this);
    }

    protected void simpleInsert(V x) {
        int x_indx = this.vecs.size();
        this.vecs.add(x);
        if (this.accell_cache == null && this.dm.supportsAcceleration()) {
            this.accell_cache = new DoubleList();
        }
        if (this.accell_cache != null) {
            this.accell_cache.addAll(this.dm.getQueryInfo((Vec)x));
        }
        this.root = this.root == null ? new TreeNode(x_indx) : this.simpleInsert(this.root, x_indx);
    }

    protected TreeNode simpleInsert(TreeNode p, int x_indx) {
        if (this.root == null) {
            this.root = new TreeNode(x_indx);
            return this.root;
        }
        double p_x_dist = p.dist(x_indx);
        if (p_x_dist > p.covdist()) {
            int start_indx = p.vec_indx;
            if (p_x_dist - CoverTree.pow(p.level + 1) < 1.3 * p.covdist()) {
                while (p_x_dist > 1.3 * p.covdist() && !p.isLeaf()) {
                    TreeNode q;
                    TreeNode p_prime = q = p.removeAnyLeaf();
                    p_prime.addChild(p);
                    p_prime.fixLevel();
                    p = p_prime;
                    p_x_dist = p.dist(x_indx);
                    if (p.vec_indx != start_indx) continue;
                    break;
                }
            }
            TreeNode X = new TreeNode(x_indx);
            X.addChild(p);
            X.fixLevel();
            return X;
        }
        return this.simpleInsert_(p, x_indx);
    }

    protected TreeNode simpleInsert_(TreeNode p, int x_indx) {
        for (int q_indx = 0; q_indx < p.numChildren(); ++q_indx) {
            TreeNode q = p.getChild(q_indx);
            if (!(q.dist(x_indx) <= q.covdist())) continue;
            TreeNode q_prime = this.simpleInsert_(q, x_indx);
            p.replaceChild(q_indx, q_prime);
            return p;
        }
        p.addChild(new TreeNode(x_indx, p.level - 1));
        return p;
    }

    @Override
    public void insert(V x) {
        this.simpleInsert(x);
    }

    static {
        for (int pow_indx = -120; pow_indx < 1000; ++pow_indx) {
            CoverTree.pow_map[pow_indx - -120] = (float)Math.pow(1.3, pow_indx);
        }
    }

    private class TreeNode
    implements Cloneable,
    Serializable {
        TreeNode parent = null;
        int level;
        int vec_indx;
        DoubleList children_dists;
        List<TreeNode> children;
        boolean is_sorted = true;
        double maxdist = -1.0;

        public TreeNode(int vec_indx) {
            this(vec_indx, -110);
        }

        public TreeNode(int vec_indx, int level) {
            this.vec_indx = vec_indx;
            this.level = level;
            this.children = new ArrayList<TreeNode>();
            this.children_dists = new DoubleList();
        }

        public TreeNode(TreeNode toCopy) {
            this.level = toCopy.level;
            this.vec_indx = toCopy.vec_indx;
            if (toCopy.children != null) {
                this.children = new ArrayList<TreeNode>(toCopy.children.size());
                this.children_dists = new DoubleList(toCopy.children_dists);
                for (TreeNode childToCopy : toCopy.children) {
                    TreeNode child = new TreeNode(childToCopy);
                    child.parent = this;
                    this.children.add(child);
                }
            }
            this.is_sorted = toCopy.is_sorted;
            this.maxdist = toCopy.maxdist;
        }

        protected TreeNode clone() {
            return new TreeNode(this);
        }

        public void invalidateMaxDist() {
            this.maxdist = -1.0;
            for (TreeNode c : this.children) {
                c.invalidateMaxDist();
            }
        }

        public void invalParentMaxdist() {
            this.maxdist = -2.0;
            if (this.parent != null) {
                this.parent.invalParentMaxdist();
            }
        }

        public void findNN(int k, Vec x, List<Double> x_qi, BoundedSortedList<IndexDistPair> knn, double my_dist_to_x) {
            TreeNode p = this;
            double p_x_dist = my_dist_to_x < 0.0 ? p.dist(x, x_qi) : my_dist_to_x;
            knn.add(new IndexDistPair(p.vec_indx, p_x_dist));
            double[] q_x_dist = new double[p.numChildren()];
            for (int q_indx = 0; q_indx < p.numChildren(); ++q_indx) {
                TreeNode q = p.getChild(q_indx);
                q_x_dist[q_indx] = q.dist(x, x_qi);
            }
            IndexTable it = new IndexTable(q_x_dist);
            for (int i_oder = 0; i_oder < it.length(); ++i_oder) {
                int i = it.index(i_oder);
                TreeNode q = p.getChild(i);
                if (knn.size() >= k && !(knn.last().getDist() > q_x_dist[i] - q.maxdist())) continue;
                q.findNN(k, x, x_qi, knn, q_x_dist[i]);
            }
        }

        public void findNN(double radius, Vec x, List<Double> x_qi, List<Integer> neighbors, List<Double> distances, double my_dist_to_x) {
            TreeNode q;
            TreeNode p = this;
            double p_x_dist = my_dist_to_x < 0.0 ? p.dist(x, x_qi) : my_dist_to_x;
            if (p_x_dist <= radius) {
                neighbors.add(p.vec_indx);
                distances.add(p_x_dist);
            }
            double[] q_x_dist = new double[p.numChildren()];
            for (int q_indx = 0; q_indx < p.numChildren(); ++q_indx) {
                q = p.getChild(q_indx);
                q_x_dist[q_indx] = q.dist(x, x_qi);
            }
            for (int i = 0; i < q_x_dist.length; ++i) {
                q = p.getChild(i);
                if (!(radius > q_x_dist[i] - q.maxdist())) continue;
                q.findNN(radius, x, x_qi, neighbors, distances, q_x_dist[i]);
            }
        }

        public int magnitude() {
            int count = 1;
            for (int i = 0; i < this.numChildren(); ++i) {
                count += this.getChild(i).magnitude();
            }
            return count;
        }

        public boolean isLeaf() {
            return this.children == null || this.children.isEmpty();
        }

        public int numChildren() {
            return this.children.size();
        }

        public TreeNode getChild(int indx) {
            return this.children.get(indx);
        }

        public void addChild(TreeNode child) {
            double dist_to_c = this.dist(child.vec_indx);
            int insert_indx = this.children.size();
            this.children.add(insert_indx, child);
            this.children_dists.add(insert_indx, dist_to_c);
            this.fixChildrenLevel();
            this.invalParentMaxdist();
        }

        public void replaceChild(int orig_index, TreeNode child) {
            double dist_to_c = this.dist(child.vec_indx);
            this.children.set(orig_index, child);
            this.children_dists.set(orig_index, dist_to_c);
            this.fixChildrenLevel();
            this.invalParentMaxdist();
        }

        public void removeChild(int orig_index) {
            this.children.remove(orig_index);
            this.children_dists.remove(orig_index);
            this.invalParentMaxdist();
        }

        public TreeNode removeAnyLeaf() {
            if (this.isLeaf()) {
                throw new RuntimeException("BUG: node has no children to rmeove");
            }
            TreeNode child = this.children.get(this.children.size() - 1);
            if (child.isLeaf()) {
                child.invalParentMaxdist();
                this.children.remove(this.children.size() - 1);
                this.children_dists.remove(this.children_dists.size() - 1);
                return child;
            }
            return child.removeAnyLeaf();
        }

        public double dist(TreeNode q) {
            return CoverTree.this.dm.dist(this.vec_indx, q.vec_indx, (List<? extends Vec>)CoverTree.this.vecs, (List<Double>)CoverTree.this.accell_cache);
        }

        public double dist(int x_indx) {
            return CoverTree.this.dm.dist(this.vec_indx, x_indx, (List<? extends Vec>)CoverTree.this.vecs, (List<Double>)CoverTree.this.accell_cache);
        }

        public double dist(Vec x, List<Double> qi) {
            return CoverTree.this.dm.dist(this.vec_indx, x, qi, CoverTree.this.vecs, CoverTree.this.accell_cache);
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public void fixLevel() {
            double maxDist = CoverTree.pow(-110);
            for (int i = 0; i < this.numChildren(); ++i) {
                maxDist = Math.max(maxDist, this.children_dists.getD(i));
            }
            this.level = (int)Math.ceil(FastMath.log2(maxDist) / log2_base + 1.0E-4);
            this.fixChildrenLevel();
        }

        public void fixChildrenLevel() {
            for (int i = 0; i < this.numChildren(); ++i) {
                TreeNode c = this.getChild(i);
                if (this.level - 1 == c.level) continue;
                c.level = this.level - 1;
                c.fixChildrenLevel();
            }
        }

        public double covdist() {
            return CoverTree.pow(this.level);
        }

        public double sepdist() {
            return CoverTree.pow(this.level - 1);
        }

        private double maxdist() {
            if (this.isLeaf()) {
                return 0.0;
            }
            if (CoverTree.this.looseBounds) {
                return CoverTree.pow(this.level + 1);
            }
            if (this.maxdist >= 0.0) {
                return this.maxdist;
            }
            Stack<TreeNode> toGetChildrenFrom = new Stack<TreeNode>();
            toGetChildrenFrom.add(this);
            while (!toGetChildrenFrom.empty()) {
                TreeNode runner = (TreeNode)toGetChildrenFrom.pop();
                for (int q_indx = 0; q_indx < runner.numChildren(); ++q_indx) {
                    TreeNode q = runner.getChild(q_indx);
                    this.maxdist = Math.max(this.maxdist, this.dist(q.vec_indx));
                    toGetChildrenFrom.add(q);
                }
            }
            return this.maxdist;
        }

        private Iterator<TreeNode> descendants() {
            final Stack<TreeNode> toIterate = new Stack<TreeNode>();
            toIterate.addAll(this.children);
            Iterator<TreeNode> iter = new Iterator<TreeNode>(){

                @Override
                public boolean hasNext() {
                    return !toIterate.isEmpty();
                }

                @Override
                public TreeNode next() {
                    TreeNode next = (TreeNode)toIterate.pop();
                    toIterate.addAll(next.children);
                    return next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
            return iter;
        }
    }
}

