/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.distancemetrics;

import java.util.List;
import java.util.concurrent.ExecutorService;
import jsat.distributions.kernels.KernelTrick;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;

public class KernelDistance
implements DistanceMetric {
    private static final long serialVersionUID = -1553315486668768024L;
    private KernelTrick kf;

    public KernelDistance(KernelTrick kf) {
        this.kf = kf;
    }

    @Override
    public double dist(Vec a, Vec b) {
        return this.kf.eval(a, a) - 2.0 * this.kf.eval(a, b) + this.kf.eval(b, b);
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isSubadditive() {
        return true;
    }

    @Override
    public boolean isIndiscemible() {
        return true;
    }

    @Override
    public double metricBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String toString() {
        return "Kernel (" + this.kf + ") Distance";
    }

    @Override
    public KernelDistance clone() {
        return new KernelDistance(this.kf);
    }

    @Override
    public boolean supportsAcceleration() {
        return false;
    }

    @Override
    public List<Double> getAccelerationCache(List<? extends Vec> vecs, boolean parallel) {
        return null;
    }

    @Override
    public double dist(int a, int b, List<? extends Vec> vecs, List<Double> cache) {
        return this.dist(vecs.get(a), vecs.get(b));
    }

    @Override
    public double dist(int a, Vec b, List<? extends Vec> vecs, List<Double> cache) {
        return this.dist(vecs.get(a), b);
    }

    @Override
    public List<Double> getQueryInfo(Vec q) {
        return null;
    }

    @Override
    public List<Double> getAccelerationCache(List<? extends Vec> vecs, ExecutorService threadpool) {
        return null;
    }

    @Override
    public double dist(int a, Vec b, List<Double> qi, List<? extends Vec> vecs, List<Double> cache) {
        return this.dist(vecs.get(a), b);
    }
}

