/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.empirical.kernelfunc;

import jsat.distributions.empirical.kernelfunc.KernelFunction;

public class TriweightKF
implements KernelFunction {
    private static final long serialVersionUID = -9156392658970318676L;

    private TriweightKF() {
    }

    public static TriweightKF getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public double k(double u) {
        if (Math.abs(u) > 1.0) {
            return 0.0;
        }
        return Math.pow(1.0 - u * u, 3.0) * 1.09375;
    }

    @Override
    public double intK(double u) {
        if (u < -1.0) {
            return 0.0;
        }
        if (u > 1.0) {
            return 1.0;
        }
        return (-5.0 * Math.pow(u, 7.0) + 21.0 * Math.pow(u, 5.0) - 35.0 * Math.pow(u, 3.0) + 35.0 * u + 16.0) / 32.0;
    }

    @Override
    public double k2() {
        return 0.1111111111111111;
    }

    @Override
    public double cutOff() {
        return Math.ulp(1.0f) + 1.0f;
    }

    @Override
    public double kPrime(double u) {
        if (Math.abs(u) > 1.0) {
            return 0.0;
        }
        return -u;
    }

    @Override
    public String toString() {
        return "Triweight Kernel";
    }

    private static class SingletonHolder {
        public static final TriweightKF INSTANCE = new TriweightKF();

        private SingletonHolder() {
        }
    }
}

