/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;
import jsat.math.SpecialMath;

public class FisherSendor
extends ContinuousDistribution {
    private static final long serialVersionUID = 7628304882101574242L;
    double v1;
    double v2;

    public FisherSendor(double v1, double v2) {
        if (v1 <= 0.0) {
            throw new ArithmeticException("v1 must be > 0 not " + v1);
        }
        if (v2 <= 0.0) {
            throw new ArithmeticException("v2 must be > 0 not " + v2);
        }
        this.v1 = v1;
        this.v2 = v2;
    }

    @Override
    public double logPdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double leftSide = this.v1 / 2.0 * Math.log(this.v1) + this.v2 / 2.0 * Math.log(this.v2) - SpecialMath.lnBeta(this.v1 / 2.0, this.v2 / 2.0);
        double rightSide = (this.v1 / 2.0 - 1.0) * Math.log(x) - (this.v1 + this.v2) / 2.0 * Math.log(this.v2 + this.v1 * x);
        return leftSide + rightSide;
    }

    @Override
    public double pdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp(this.logPdf(x));
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return SpecialMath.betaIncReg(this.v1 * x / (this.v1 * x + this.v2), this.v1 / 2.0, this.v2 / 2.0);
    }

    @Override
    public double invCdf(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Probability must be in the range [0,1], not" + p);
        }
        double u = SpecialMath.invBetaIncReg(p, this.v1 / 2.0, this.v2 / 2.0);
        return this.v2 * u / (this.v1 * (1.0 - u));
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "F";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"v1", "v2"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.v1, this.v2};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVariable(String var, double value) {
        if (var.equals("v1")) {
            if (!(value > 0.0)) throw new ArithmeticException("v1 must be > 0 not " + value);
            this.v1 = value;
            return;
        } else {
            if (!var.equals("v2")) return;
            if (!(value > 0.0)) throw new ArithmeticException("v2 must be > 0 not " + value);
            this.v2 = value;
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new FisherSendor(this.v1, this.v2);
    }

    @Override
    public void setUsingData(Vec data) {
        double mu = data.mean();
        double tmp = 2.0 * mu / (-1.0 + mu);
        if (tmp < 2.0) {
            return;
        }
        this.v2 = tmp;
        if (this.v2 < 4.0) {
            return;
        }
        double v2sqr = this.v2 * this.v2;
        double var = data.variance();
        double denom = -2.0 * v2sqr - 16.0 * var + 20.0 * this.v2 * var - 8.0 * v2sqr * var + v2sqr * this.v2 * var;
        this.v1 = 2.0 * (-2.0 * v2sqr + v2sqr * this.v2) / denom;
    }

    @Override
    public double mean() {
        if (this.v2 <= 2.0) {
            return Double.NaN;
        }
        return this.v2 / (this.v2 - 2.0);
    }

    @Override
    public double median() {
        return this.v2 / this.v1 * (1.0 / SpecialMath.invBetaIncReg(0.5, this.v2 / 2.0, this.v1 / 2.0) - 1.0);
    }

    @Override
    public double mode() {
        if (this.v1 <= 2.0) {
            return Double.NaN;
        }
        return (this.v1 - 2.0) / this.v1 * this.v2 / (this.v2 + 2.0);
    }

    @Override
    public double variance() {
        if (this.v2 <= 4.0) {
            return Double.NaN;
        }
        return 2.0 * this.v2 * this.v2 * (this.v1 + this.v2 - 2.0) / (this.v1 * Math.pow(this.v2 - 2.0, 2.0) * (this.v2 - 4.0));
    }

    @Override
    public double skewness() {
        if (this.v2 <= 6.0) {
            return Double.NaN;
        }
        double num = (2.0 * this.v1 + this.v2 - 2.0) * Math.sqrt(8.0 * (this.v2 - 4.0));
        double denom = (this.v2 - 6.0) * Math.sqrt(this.v1 * (this.v1 + this.v2 - 2.0));
        return num / denom;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.v1);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.v2);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FisherSendor other = (FisherSendor)obj;
        if (Double.doubleToLongBits(this.v1) != Double.doubleToLongBits(other.v1)) {
            return false;
        }
        return Double.doubleToLongBits(this.v2) == Double.doubleToLongBits(other.v2);
    }
}

