/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.InPlaceInvertibleTransform;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.math.OnLineStatistics;

public class LinearTransform
implements InPlaceInvertibleTransform {
    private static final long serialVersionUID = 5580283565080452022L;
    private double A;
    private double B;
    private Vec mins;
    private Vec mutliplyConstants;

    public LinearTransform() {
        this(1.0, 0.0);
    }

    public LinearTransform(DataSet dataSet) {
        this(dataSet, 1.0, 0.0);
    }

    public LinearTransform(double A, double B) {
        this.setRange(A, B);
    }

    public LinearTransform(DataSet dataSet, double A, double B) {
        this(A, B);
        this.fit(dataSet);
    }

    public void setRange(double A, double B) {
        if (A == B) {
            throw new RuntimeException("Values must be different");
        }
        if (B > A) {
            double tmp = A;
            A = B;
            B = tmp;
        }
        this.A = A;
        this.B = B;
    }

    @Override
    public void fit(DataSet dataSet) {
        this.mins = new DenseVector(dataSet.getNumNumericalVars());
        DenseVector maxs = new DenseVector(this.mins.length());
        this.mutliplyConstants = new DenseVector(this.mins.length());
        OnLineStatistics[] stats = dataSet.getOnlineColumnStats(false);
        for (int i = 0; i < this.mins.length(); ++i) {
            double min = stats[i].getMin();
            double max = stats[i].getMax();
            if (max - min < 1.0E-6) {
                this.mins.set(i, 0.0);
                ((Vec)maxs).set(i, 1.0);
                this.mutliplyConstants.set(i, 1.0);
                continue;
            }
            this.mins.set(i, min);
            ((Vec)maxs).set(i, max);
            this.mutliplyConstants.set(i, this.A - this.B);
        }
        maxs.mutableSubtract(this.mins);
        this.mutliplyConstants.mutablePairwiseDivide(maxs);
    }

    private LinearTransform(LinearTransform other) {
        this.A = other.A;
        this.B = other.B;
        if (other.mins != null) {
            this.mins = other.mins.clone();
        }
        if (other.mutliplyConstants != null) {
            this.mutliplyConstants = other.mutliplyConstants.clone();
        }
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        DataPoint toRet = dp.clone();
        this.mutableTransform(toRet);
        return toRet;
    }

    @Override
    public LinearTransform clone() {
        return new LinearTransform(this);
    }

    @Override
    public void mutableInverse(DataPoint dp) {
        Vec v = dp.getNumericalValues();
        v.mutableSubtract(this.B);
        v.mutablePairwiseDivide(this.mutliplyConstants);
        v.mutableAdd(this.mins);
    }

    @Override
    public void mutableTransform(DataPoint dp) {
        Vec v = dp.getNumericalValues();
        v.mutableSubtract(this.mins);
        v.mutablePairwiseMultiply(this.mutliplyConstants);
        v.mutableAdd(this.B);
    }

    @Override
    public boolean mutatesNominal() {
        return false;
    }

    @Override
    public DataPoint inverse(DataPoint dp) {
        DataPoint toRet = dp.clone();
        this.mutableInverse(toRet);
        return toRet;
    }
}

