/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.trees;

import java.io.Serializable;
import java.util.Collection;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.DataPoint;
import jsat.linear.DenseVector;

public abstract class TreeNodeVisitor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4026847401940409114L;

    public abstract int childrenCount();

    public abstract boolean isLeaf();

    public abstract TreeNodeVisitor getChild(int var1);

    public abstract void disablePath(int var1);

    public void setPath(int child, TreeNodeVisitor node) {
        throw new UnsupportedOperationException("setPath is an optional operation.");
    }

    public abstract boolean isPathDisabled(int var1);

    public CategoricalResults localClassify(DataPoint dp) {
        throw new UnsupportedOperationException("This tree does not support classification");
    }

    public abstract int getPath(DataPoint var1);

    public double getPathWeight(int path) {
        return 1.0 / (double)this.childrenCount();
    }

    public CategoricalResults classify(DataPoint dp) {
        TreeNodeVisitor node = this;
        while (!node.isLeaf()) {
            int path = node.getPath(dp);
            if (path < 0) {
                double sum = 0.0;
                DenseVector resultSum = null;
                for (int child = 0; child < this.childrenCount(); ++child) {
                    if (node.isPathDisabled(child)) continue;
                    CategoricalResults child_result = node.getChild(child).classify(dp);
                    if (resultSum == null) {
                        resultSum = new DenseVector(child_result.size());
                    }
                    sum += node.getPathWeight(child);
                    resultSum.mutableAdd(node.getPathWeight(child), child_result.getVecView());
                }
                if (resultSum == null) break;
                if (sum < 0.99999) {
                    resultSum.mutableDivide(sum + 1.0E-6);
                }
                return new CategoricalResults(resultSum.arrayCopy());
            }
            if (node.isPathDisabled(path)) break;
            node = node.getChild(path);
        }
        return node.localClassify(dp);
    }

    public double localRegress(DataPoint dp) {
        throw new UnsupportedOperationException("This tree does not support classification");
    }

    public double regress(DataPoint dp) {
        TreeNodeVisitor node = this;
        while (!node.isLeaf()) {
            int path = node.getPath(dp);
            if (path < 0) {
                double sum = 0.0;
                double resultSum = 0.0;
                for (int child = 0; child < this.childrenCount(); ++child) {
                    if (node.isPathDisabled(child)) continue;
                    double child_result = node.getChild(child).regress(dp);
                    sum += node.getPathWeight(child);
                    resultSum += node.getPathWeight(child) * child_result;
                }
                if (sum == 0.0) break;
                if (sum < 0.99999) {
                    resultSum /= sum + 1.0E-6;
                }
                return resultSum;
            }
            if (node.isPathDisabled(path)) break;
            node = node.getChild(path);
        }
        return node.localRegress(dp);
    }

    public abstract Collection<Integer> featuresUsed();

    public abstract TreeNodeVisitor clone();
}

