/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.evaluation;

import jsat.classifiers.evaluation.SimpleBinaryClassMetric;

public class FbetaScore
extends SimpleBinaryClassMetric {
    private static final long serialVersionUID = -7530404462591303694L;
    private double beta;

    public FbetaScore(double beta) {
        if (beta <= 0.0 || Double.isInfinite(beta) || Double.isNaN(beta)) {
            throw new IllegalArgumentException("beta must be in (0, inf), not " + beta);
        }
        this.beta = beta;
    }

    public FbetaScore(FbetaScore toClone) {
        super(toClone);
        this.beta = toClone.beta;
    }

    @Override
    public double getScore() {
        double betaSqrd = this.beta * this.beta;
        return (1.0 + betaSqrd) * this.tp / ((1.0 + betaSqrd) * this.tp + this.fp + betaSqrd * this.fn);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass().isAssignableFrom(obj.getClass()) && obj.getClass().isAssignableFrom(this.getClass())) {
            return this.beta == ((FbetaScore)obj).beta;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return new Double(this.beta).hashCode();
    }

    @Override
    public FbetaScore clone() {
        return new FbetaScore(this);
    }

    @Override
    public String getName() {
        return "F beta(" + this.beta + ") Score";
    }
}

