/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers;

import java.util.ArrayList;
import java.util.List;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.classifiers.calibration.BinaryScoreClassifier;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;
import jsat.utils.concurrent.ParallelUtils;

public class OneVSAll
implements Classifier,
Parameterized {
    private static final long serialVersionUID = -326668337438092217L;
    private Classifier[] oneVsAlls;
    @Parameter.ParameterHolder
    private Classifier baseClassifier;
    private CategoricalData predicting;
    private boolean concurrentTraining;
    private boolean useScoreIfAvailable = true;

    public OneVSAll(Classifier baseClassifier) {
        this(baseClassifier, true);
    }

    public OneVSAll(Classifier baseClassifier, boolean concurrentTraining) {
        this.baseClassifier = baseClassifier;
        this.concurrentTraining = concurrentTraining;
    }

    public void setConcurrentTraining(boolean concurrentTraining) {
        this.concurrentTraining = concurrentTraining;
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        CategoricalResults cr = new CategoricalResults(this.predicting.getNumOfCategories());
        if (this.useScoreIfAvailable && this.oneVsAlls[0] instanceof BinaryScoreClassifier) {
            int maxIndx = 0;
            double maxScore = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.predicting.getNumOfCategories(); ++i) {
                double score = -((BinaryScoreClassifier)this.oneVsAlls[i]).getScore(data);
                if (!(score > maxScore)) continue;
                maxIndx = i;
                maxScore = score;
            }
            cr.setProb(maxIndx, 1.0);
        } else {
            for (int i = 0; i < this.predicting.getNumOfCategories(); ++i) {
                CategoricalResults oneVsAllCR = this.oneVsAlls[i].classify(data);
                double tmp = oneVsAllCR.getProb(0);
                if (!(tmp > 0.0)) continue;
                cr.setProb(i, tmp);
            }
            cr.normalize();
        }
        return cr;
    }

    @Override
    public void train(ClassificationDataSet dataSet, boolean parallel) {
        this.oneVsAlls = new Classifier[dataSet.getClassSize()];
        this.predicting = dataSet.getPredicting();
        ArrayList categorized = new ArrayList();
        for (int i2 = 0; i2 < this.oneVsAlls.length; ++i2) {
            List<DataPoint> tmp = dataSet.getSamples(i2);
            ArrayList<DataPoint> oneCat = new ArrayList<DataPoint>(tmp.size());
            oneCat.addAll(tmp);
            categorized.add(oneCat);
        }
        int numer = dataSet.getNumNumericalVars();
        CategoricalData[] categories = dataSet.getCategories();
        ParallelUtils.range(0, this.oneVsAlls.length, parallel && this.concurrentTraining).forEach(i -> {
            ClassificationDataSet cds = new ClassificationDataSet(numer, categories, new CategoricalData(2));
            for (DataPoint dp : (List)categorized.get(i)) {
                cds.addDataPoint(dp.getNumericalValues(), dp.getCategoricalValues(), 0);
            }
            for (int j = 0; j < categorized.size(); ++j) {
                if (j == i) continue;
                for (DataPoint dp : (List)categorized.get(j)) {
                    cds.addDataPoint(dp.getNumericalValues(), dp.getCategoricalValues(), 1);
                }
            }
            this.oneVsAlls[i] = this.baseClassifier.clone();
            if (this.concurrentTraining) {
                this.oneVsAlls[i].train(cds, false);
            } else {
                this.oneVsAlls[i].train(cds, parallel);
            }
        });
    }

    @Override
    public OneVSAll clone() {
        OneVSAll clone = new OneVSAll(this.baseClassifier.clone(), this.concurrentTraining);
        if (this.predicting != null) {
            clone.predicting = this.predicting.clone();
        }
        if (this.oneVsAlls != null) {
            clone.oneVsAlls = new Classifier[this.oneVsAlls.length];
            for (int i = 0; i < this.oneVsAlls.length; ++i) {
                if (this.oneVsAlls[i] == null) continue;
                clone.oneVsAlls[i] = this.oneVsAlls[i].clone();
            }
        }
        return clone;
    }

    @Override
    public boolean supportsWeightedData() {
        return this.baseClassifier.supportsWeightedData();
    }
}

