/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;

public class IntList
extends AbstractList<Integer>
implements Serializable {
    private static final long serialVersionUID = 8189142393005394477L;
    private int[] array;
    private int end;

    private IntList(int[] array, int end) {
        this.array = array;
        this.end = end;
    }

    public IntList() {
        this(10);
    }

    @Override
    public void clear() {
        this.end = 0;
    }

    public IntList(int capacity) {
        this.array = new int[capacity];
        this.end = 0;
    }

    public IntList(Collection<Integer> c) {
        this(c.size());
        this.addAll((Collection<? extends Integer>)c);
    }

    @Override
    public int set(int index, int element) {
        this.boundsCheck(index);
        int prev = this.array[index];
        this.array[index] = element;
        return prev;
    }

    @Override
    public Integer set(int index, Integer element) {
        return this.set(index, (int)element);
    }

    @Override
    public void add(int index, int element) {
        if (index == this.size()) {
            this.add(element);
        } else {
            this.boundsCheck(index);
            this.enlargeIfNeeded(1);
            System.arraycopy(this.array, index, this.array, index + 1, this.end - index);
            this.array[index] = element;
            ++this.end;
        }
    }

    @Override
    public void add(int index, Integer element) {
        this.add(index, (int)element);
    }

    @Override
    public boolean add(int e) {
        this.enlargeIfNeeded(1);
        this.array[this.end++] = e;
        return true;
    }

    @Override
    public boolean add(Integer e) {
        if (e == null) {
            return false;
        }
        return this.add((int)e);
    }

    public int getI(int index) {
        this.boundsCheck(index);
        return this.array[index];
    }

    @Override
    public Integer get(int index) {
        return this.getI(index);
    }

    private void boundsCheck(int index) throws IndexOutOfBoundsException {
        if (index >= this.end) {
            throw new IndexOutOfBoundsException("List of of size " + this.size() + ", index requested was " + index);
        }
    }

    @Override
    public int size() {
        return this.end;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        int initSize = this.size();
        this.enlargeIfNeeded(c.size());
        Iterator<? extends Integer> iterator = c.iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            this.add(i);
        }
        return initSize != this.size();
    }

    @Override
    public Integer remove(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Can not remove invalid index " + index);
        }
        int removed = this.array[index];
        for (int i = index; i < this.end - 1; ++i) {
            this.array[i] = this.array[i + 1];
        }
        --this.end;
        return removed;
    }

    private void enlargeIfNeeded(int i) {
        while (this.end + i > this.array.length) {
            this.array = Arrays.copyOf(this.array, Math.max(this.array.length * 2, 8));
        }
    }

    public void sort() {
        Arrays.sort(this.array, 0, this.end);
    }

    public static List<Integer> unmodifiableView(int[] array, int length) {
        return Collections.unmodifiableList(IntList.view(array, length));
    }

    public static IntList view(int[] array, int length) {
        if (length > array.length || length < 0) {
            throw new IllegalArgumentException("length must be non-negative and no more than the size of the array(" + array.length + "), not " + length);
        }
        return new IntList(array, length);
    }

    public static IntList view(int[] array) {
        return IntList.view(array, array.length);
    }

    public IntStream streamInts() {
        return IntStream.of(this.array).limit(this.end);
    }

    public static IntList range(int start, int end, int step) {
        IntList l = new IntList((end - start) / step + 1);
        for (int i = start; i < end; ++i) {
            l.add(i);
        }
        return l;
    }

    public static IntList range(int start, int end) {
        return IntList.range(start, end, 1);
    }

    public static IntList range(int end) {
        return IntList.range(0, end);
    }
}

