/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jsat.linear.DenseVector;
import jsat.linear.Vec;

public class DoubleList
extends AbstractList<Double>
implements Serializable {
    private static final long serialVersionUID = 653930294509274337L;
    private double[] array;
    private int end;

    private DoubleList(double[] array, int end) {
        this.array = array;
        this.end = end;
    }

    @Override
    public void clear() {
        this.end = 0;
    }

    public DoubleList() {
        this(10);
    }

    public DoubleList(int capacity) {
        this(new double[capacity], 0);
    }

    public DoubleList(Collection<Double> c) {
        this(c.size());
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.end;
    }

    @Override
    public boolean add(double e) {
        this.enlageIfNeeded(1);
        this.array[this.end] = e;
        this.increasedSize(1);
        return true;
    }

    private void decreaseSize(int removed) {
        this.end -= removed;
    }

    private void increasedSize(int added) {
        this.end += added;
    }

    private void boundsCheck(int index) throws IndexOutOfBoundsException {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("List is of size " + this.size() + ", index requested " + index);
        }
    }

    private void enlageIfNeeded(int i) {
        while (this.end + i > this.array.length) {
            this.array = Arrays.copyOf(this.array, Math.max(this.array.length * 2, 8));
        }
    }

    @Override
    public boolean add(Double e) {
        if (e == null) {
            return false;
        }
        return this.add((double)e);
    }

    public double getD(int index) {
        this.boundsCheck(index);
        return this.array[index];
    }

    @Override
    public Double get(int index) {
        return this.getD(index);
    }

    @Override
    public double set(int index, double element) {
        this.boundsCheck(index);
        double ret = this.get(index);
        this.array[index] = element;
        return ret;
    }

    @Override
    public Double set(int index, Double element) {
        return this.set(index, (double)element);
    }

    @Override
    public void add(int index, double element) {
        if (index == this.size()) {
            this.add(element);
        } else {
            this.boundsCheck(index);
            this.enlageIfNeeded(1);
            System.arraycopy(this.array, index, this.array, index + 1, this.size() - index);
            this.set(index, element);
            this.increasedSize(1);
        }
    }

    @Override
    public void add(int index, Double element) {
        this.add(index, (double)element);
    }

    public double removeD(int index) {
        this.boundsCheck(index);
        double ret = this.array[index];
        for (int i = index; i < this.end - 1; ++i) {
            this.array[i] = this.array[i + 1];
        }
        this.decreaseSize(1);
        return ret;
    }

    @Override
    public Double remove(int index) {
        return this.removeD(index);
    }

    public double[] getBackingArray() {
        return this.array;
    }

    public Vec getVecView() {
        return new DenseVector(this.array, 0, this.end);
    }

    public static List<Double> unmodifiableView(double[] array, int length) {
        return Collections.unmodifiableList(DoubleList.view(array, length));
    }

    public static DoubleList view(double[] array, int length) {
        if (length > array.length || length < 0) {
            throw new IllegalArgumentException("length must be non-negative and no more than the size of the array(" + array.length + "), not " + length);
        }
        return new DoubleList(array, length);
    }
}

