/*
 * Decompiled with CFR 0.152.
 */
package jsat.text.stemming;

import java.util.HashMap;
import jsat.text.stemming.Stemmer;

public class LovinsStemmer
extends Stemmer {
    private static final long serialVersionUID = -3229865664217642197L;
    private static final HashMap<String, String> ending11 = new HashMap<String, String>(){
        private static final long serialVersionUID = 4064350307133685150L;
        {
            this.put("alistically", "B");
            this.put("arizability", "A");
            this.put("izationally", "B");
        }
    };
    private static final HashMap<String, String> ending10 = new HashMap<String, String>(){
        private static final long serialVersionUID = -5247798032923242997L;
        {
            this.put("antialness", "A");
            this.put("arisations", "A");
            this.put("arizations", "A");
            this.put("entialness", "A");
        }
    };
    private static final HashMap<String, String> ending9 = new HashMap<String, String>(){
        private static final long serialVersionUID = -9153017770847287495L;
        {
            this.put("allically", "C");
            this.put("antaneous", "A");
            this.put("antiality", "A");
            this.put("arisation", "A");
            this.put("arization", "A");
            this.put("ationally", "B");
            this.put("ativeness", "A");
            this.put("eableness", "E");
            this.put("entations", "A");
            this.put("entiality", "A");
            this.put("entialize", "A");
            this.put("entiation", "A");
            this.put("ionalness", "A");
            this.put("istically", "A");
            this.put("itousness", "A");
            this.put("izability", "A");
            this.put("izational", "A");
        }
    };
    private static final HashMap<String, String> ending8 = new HashMap<String, String>(){
        private static final long serialVersionUID = 3671522347706544570L;
        {
            this.put("ableness", "A");
            this.put("arizable", "A");
            this.put("entation", "A");
            this.put("entially", "A");
            this.put("eousness", "A");
            this.put("ibleness", "A");
            this.put("icalness", "A");
            this.put("ionalism", "A");
            this.put("ionality", "A");
            this.put("ionalize", "A");
            this.put("iousness", "A");
            this.put("izations", "A");
            this.put("lessness", "A");
        }
    };
    private static final HashMap<String, String> ending7 = new HashMap<String, String>(){
        private static final long serialVersionUID = -4697823317524161452L;
        {
            this.put("ability", "A");
            this.put("aically", "A");
            this.put("alistic", "B");
            this.put("alities", "A");
            this.put("ariness", "E");
            this.put("aristic", "A");
            this.put("arizing", "A");
            this.put("ateness", "A");
            this.put("atingly", "A");
            this.put("ational", "B");
            this.put("atively", "A");
            this.put("ativism", "A");
            this.put("elihood", "E");
            this.put("encible", "A");
            this.put("entally", "A");
            this.put("entials", "A");
            this.put("entiate", "A");
            this.put("entness", "A");
            this.put("fulness", "A");
            this.put("ibility", "A");
            this.put("icalism", "A");
            this.put("icalist", "A");
            this.put("icality", "A");
            this.put("icalize", "A");
            this.put("ication", "G");
            this.put("icianry", "A");
            this.put("ination", "A");
            this.put("ingness", "A");
            this.put("ionally", "A");
            this.put("isation", "A");
            this.put("ishness", "A");
            this.put("istical", "A");
            this.put("iteness", "A");
            this.put("iveness", "A");
            this.put("ivistic", "A");
            this.put("ivities", "A");
            this.put("ization", "F");
            this.put("izement", "A");
            this.put("oidally", "A");
            this.put("ousness", "A");
        }
    };
    private static final HashMap<String, String> ending6 = new HashMap<String, String>(){
        private static final long serialVersionUID = -7030401064572348271L;
        {
            this.put("aceous", "A");
            this.put("acious", "B");
            this.put("action", "G");
            this.put("alness", "A");
            this.put("ancial", "A");
            this.put("ancies", "A");
            this.put("ancing", "B");
            this.put("ariser", "A");
            this.put("arized", "A");
            this.put("arizer", "A");
            this.put("atable", "A");
            this.put("ations", "B");
            this.put("atives", "A");
            this.put("eature", "Z");
            this.put("efully", "A");
            this.put("encies", "A");
            this.put("encing", "A");
            this.put("ential", "A");
            this.put("enting", "C");
            this.put("entist", "A");
            this.put("eously", "A");
            this.put("ialist", "A");
            this.put("iality", "A");
            this.put("ialize", "A");
            this.put("ically", "A");
            this.put("icance", "A");
            this.put("icians", "A");
            this.put("icists", "A");
            this.put("ifully", "A");
            this.put("ionals", "A");
            this.put("ionate", "D");
            this.put("ioning", "A");
            this.put("ionist", "A");
            this.put("iously", "A");
            this.put("istics", "A");
            this.put("izable", "E");
            this.put("lessly", "A");
            this.put("nesses", "A");
            this.put("oidism", "A");
        }
    };
    private static final HashMap<String, String> ending5 = new HashMap<String, String>(){
        private static final long serialVersionUID = -5282435864116373834L;
        {
            this.put("acies", "A");
            this.put("acity", "A");
            this.put("aging", "B");
            this.put("aical", "A");
            this.put("alism", "B");
            this.put("ality", "A");
            this.put("alize", "A");
            this.put("allic", "b");
            this.put("anced", "B");
            this.put("ances", "B");
            this.put("antic", "C");
            this.put("arial", "A");
            this.put("aries", "A");
            this.put("arily", "A");
            this.put("arity", "B");
            this.put("arize", "A");
            this.put("aroid", "A");
            this.put("ately", "A");
            this.put("ating", "I");
            this.put("ation", "B");
            this.put("ative", "A");
            this.put("ators", "A");
            this.put("atory", "A");
            this.put("ature", "E");
            this.put("early", "Y");
            this.put("ehood", "A");
            this.put("eless", "A");
            this.put("ement", "A");
            this.put("enced", "A");
            this.put("ences", "A");
            this.put("eness", "E");
            this.put("ening", "E");
            this.put("ental", "A");
            this.put("ented", "C");
            this.put("ently", "A");
            this.put("fully", "A");
            this.put("ially", "A");
            this.put("icant", "A");
            this.put("ician", "A");
            this.put("icide", "A");
            this.put("icism", "A");
            this.put("icist", "A");
            this.put("icity", "A");
            this.put("idine", "I");
            this.put("iedly", "A");
            this.put("ihood", "A");
            this.put("inate", "A");
            this.put("iness", "A");
            this.put("ingly", "B");
            this.put("inism", "J");
            this.put("inity", "c");
            this.put("ional", "A");
            this.put("ioned", "A");
            this.put("ished", "A");
            this.put("istic", "A");
            this.put("ities", "A");
            this.put("itous", "A");
            this.put("ively", "A");
            this.put("ivity", "A");
            this.put("izers", "F");
            this.put("izing", "F");
            this.put("oidal", "A");
            this.put("oides", "A");
            this.put("otide", "A");
            this.put("ously", "A");
        }
    };
    private static final HashMap<String, String> ending4 = new HashMap<String, String>(){
        private static final long serialVersionUID = -7293777277850278026L;
        {
            this.put("able", "A");
            this.put("ably", "A");
            this.put("ages", "B");
            this.put("ally", "B");
            this.put("ance", "B");
            this.put("ancy", "B");
            this.put("ants", "B");
            this.put("aric", "A");
            this.put("arly", "K");
            this.put("ated", "I");
            this.put("ates", "A");
            this.put("atic", "B");
            this.put("ator", "A");
            this.put("ealy", "Y");
            this.put("edly", "E");
            this.put("eful", "A");
            this.put("eity", "A");
            this.put("ence", "A");
            this.put("ency", "A");
            this.put("ened", "E");
            this.put("enly", "E");
            this.put("eous", "A");
            this.put("hood", "A");
            this.put("ials", "A");
            this.put("ians", "A");
            this.put("ible", "A");
            this.put("ibly", "A");
            this.put("ical", "A");
            this.put("ides", "L");
            this.put("iers", "A");
            this.put("iful", "A");
            this.put("ines", "M");
            this.put("ings", "N");
            this.put("ions", "B");
            this.put("ious", "A");
            this.put("isms", "B");
            this.put("ists", "A");
            this.put("itic", "H");
            this.put("ized", "F");
            this.put("izer", "F");
            this.put("less", "A");
            this.put("lily", "A");
            this.put("ness", "A");
            this.put("ogen", "A");
            this.put("ward", "A");
            this.put("wise", "A");
            this.put("ying", "B");
            this.put("yish", "A");
        }
    };
    private static final HashMap<String, String> ending3 = new HashMap<String, String>(){
        private static final long serialVersionUID = -5629841014950478203L;
        {
            this.put("acy", "A");
            this.put("age", "B");
            this.put("aic", "A");
            this.put("als", "b");
            this.put("ant", "B");
            this.put("ars", "O");
            this.put("ary", "F");
            this.put("ata", "A");
            this.put("ate", "A");
            this.put("eal", "Y");
            this.put("ear", "Y");
            this.put("ely", "E");
            this.put("ene", "E");
            this.put("ent", "C");
            this.put("ery", "E");
            this.put("ese", "A");
            this.put("ful", "A");
            this.put("ial", "A");
            this.put("ian", "A");
            this.put("ics", "A");
            this.put("ide", "L");
            this.put("ied", "A");
            this.put("ier", "A");
            this.put("ies", "P");
            this.put("ily", "A");
            this.put("ine", "M");
            this.put("ing", "N");
            this.put("ion", "Q");
            this.put("ish", "C");
            this.put("ism", "B");
            this.put("ist", "A");
            this.put("ite", "a");
            this.put("ity", "A");
            this.put("ium", "A");
            this.put("ive", "A");
            this.put("ize", "F");
            this.put("oid", "A");
            this.put("one", "R");
            this.put("ous", "A");
        }
    };
    private static final HashMap<String, String> ending2 = new HashMap<String, String>(){
        private static final long serialVersionUID = -8894812965945848256L;
        {
            this.put("ae", "A");
            this.put("al", "b");
            this.put("ar", "X");
            this.put("as", "B");
            this.put("ed", "E");
            this.put("en", "F");
            this.put("es", "E");
            this.put("ia", "A");
            this.put("ic", "A");
            this.put("is", "A");
            this.put("ly", "B");
            this.put("on", "S");
            this.put("or", "T");
            this.put("um", "U");
            this.put("us", "V");
            this.put("yl", "R");
            this.put("s'", "A");
            this.put("'s", "A");
        }
    };
    private static final HashMap<String, String> ending1 = new HashMap<String, String>(){
        private static final long serialVersionUID = -7536643426902207427L;
        {
            this.put("a", "A");
            this.put("e", "A");
            this.put("i", "A");
            this.put("o", "A");
            this.put("s", "W");
            this.put("y", "B");
        }
    };
    private static final HashMap<String, String> endings = new HashMap<String, String>(){
        private static final long serialVersionUID = -8057392854617089310L;
        {
            this.putAll(ending11);
            this.putAll(ending10);
            this.putAll(ending9);
            this.putAll(ending8);
            this.putAll(ending7);
            this.putAll(ending6);
            this.putAll(ending5);
            this.putAll(ending4);
            this.putAll(ending3);
            this.putAll(ending2);
            this.putAll(ending1);
        }
    };

    private static String removeEnding(String word) {
        block31: for (int i = Math.min(11, word.length() - 2); i > 0; --i) {
            String ending = word.substring(word.length() - i);
            String condition = endings.get(ending);
            if (condition == null) continue;
            String stem = word.substring(0, word.length() - i);
            switch (condition.charAt(0)) {
                case 'A': {
                    return stem;
                }
                case 'B': {
                    if (stem.length() < 3) continue block31;
                    return stem;
                }
                case 'C': {
                    if (stem.length() < 4) continue block31;
                    return stem;
                }
                case 'D': {
                    if (stem.length() < 5) continue block31;
                    return stem;
                }
                case 'E': {
                    if (stem.endsWith("e")) continue block31;
                    return stem;
                }
                case 'F': {
                    if (stem.endsWith("e") || stem.length() < 3) continue block31;
                    return stem;
                }
                case 'G': {
                    if (!stem.endsWith("f") || stem.length() < 3) continue block31;
                    return stem;
                }
                case 'H': {
                    if (!stem.endsWith("t") && !stem.endsWith("ll")) continue block31;
                    return stem;
                }
                case 'I': {
                    if (stem.endsWith("o") || stem.endsWith("e")) continue block31;
                    return stem;
                }
                case 'J': {
                    if (stem.endsWith("a") || stem.endsWith("e")) continue block31;
                    return stem;
                }
                case 'K': {
                    if (stem.length() < 3 || !stem.matches(".*(i|u.e|l)$")) continue block31;
                    return stem;
                }
                case 'L': {
                    if (stem.endsWith("os")) {
                        return stem;
                    }
                    if (stem.matches(".*(u|x|s)$")) continue block31;
                    return stem;
                }
                case 'M': {
                    if (stem.endsWith("a") || stem.endsWith("c") || stem.endsWith("e") || stem.endsWith("m")) continue block31;
                    return stem;
                }
                case 'N': {
                    if (!(stem.matches(".*s..$") ? stem.length() >= 4 : stem.length() >= 3)) continue block31;
                    return stem;
                }
                case 'O': {
                    if (!stem.endsWith("l") && !stem.endsWith("i")) continue block31;
                    return stem;
                }
                case 'P': {
                    if (stem.endsWith("e")) continue block31;
                    return stem;
                }
                case 'Q': {
                    if (stem.length() < 3 || stem.endsWith("l") || stem.endsWith("n")) continue block31;
                    return stem;
                }
                case 'R': {
                    if (!stem.endsWith("n") && !stem.endsWith("r")) continue block31;
                    return stem;
                }
                case 'S': {
                    if (!stem.endsWith("dr") && (!stem.endsWith("t") || stem.endsWith("tt"))) continue block31;
                    return stem;
                }
                case 'T': {
                    if (!stem.endsWith("s") && (!stem.endsWith("t") || stem.endsWith("ot"))) continue block31;
                    return stem;
                }
                case 'U': {
                    if (!stem.endsWith("l") && !stem.endsWith("m") && !stem.endsWith("n") && !stem.endsWith("r")) continue block31;
                    return stem;
                }
                case 'V': {
                    if (!stem.endsWith("c")) continue block31;
                    return stem;
                }
                case 'W': {
                    if (stem.endsWith("s") || stem.endsWith("u")) continue block31;
                    return stem;
                }
                case 'X': {
                    if (!stem.matches(".*(l|i|u.e)$")) continue block31;
                    return stem;
                }
                case 'Y': {
                    if (!stem.endsWith("in")) continue block31;
                    return stem;
                }
                case 'Z': {
                    if (stem.endsWith("f")) continue block31;
                    return stem;
                }
                case 'a': {
                    if (!stem.matches(".*(d|f|ph|th|l|er|or|es|t)$")) continue block31;
                    return stem;
                }
                case 'b': {
                    if (stem.length() < 3 || stem.endsWith("met") || stem.endsWith("ryst")) continue block31;
                    return stem;
                }
                case 'c': {
                    if (!stem.endsWith("l")) continue block31;
                    return stem;
                }
            }
        }
        return word;
    }

    private static String fixStem(String stem) {
        char lastChar = stem.charAt(stem.length() - 1);
        stem = stem.replaceFirst("(dd|bb|gg|ll|mm|nn|pp|rr|ss|tt)$", "" + lastChar);
        stem = stem.replaceFirst("iev$", "ief");
        stem = stem.replaceFirst("uct$", "uc");
        stem = stem.replaceFirst("umpt$", "um");
        stem = stem.replaceFirst("rpt$", "rb");
        stem = stem.replaceFirst("urs$", "ur");
        stem = stem.replaceFirst("istr$", "ister");
        stem = stem.replaceFirst("metr$", "meter");
        if ((stem = stem.replaceFirst("olv$", "olut")).endsWith("ul") && !stem.endsWith("aoiul")) {
            stem = stem.replaceFirst("[^aoi]ul$", "l");
        }
        stem = stem.replaceFirst("bex$", "bic");
        stem = stem.replaceFirst("dex$", "dic");
        stem = stem.replaceFirst("pex$", "pic");
        stem = stem.replaceFirst("tex$", "tic");
        stem = stem.replaceFirst("ax$", "ac");
        stem = stem.replaceFirst("ex$", "ec");
        stem = stem.replaceFirst("ix$", "ic");
        stem = stem.replaceFirst("lux$", "luc");
        stem = stem.replaceFirst("uad$", "uas");
        stem = stem.replaceFirst("vad$", "vas");
        stem = stem.replaceFirst("cid$", "cis");
        stem = stem.replaceFirst("lid$", "lis");
        stem = stem.replaceFirst("erid$", "eris");
        if ((stem = stem.replaceFirst("pand$", "pans")).endsWith("end") && !stem.endsWith("send")) {
            stem = stem.replaceFirst("[^s]end$", "ens");
        }
        stem = stem.replaceFirst("ond$", "ons");
        stem = stem.replaceFirst("lud$", "lus");
        stem = stem.replaceFirst("rud$", "rus");
        stem = stem.replaceFirst("[^pt]her$", "hes");
        if ((stem = stem.replaceFirst("mit$", "mis")).endsWith("ent") && !stem.endsWith("ment")) {
            stem = stem.replaceFirst("[^m]ent$", "ens");
        }
        if ((stem = stem.replaceFirst("ert$", "ers")).endsWith("et") && !stem.endsWith("net")) {
            stem = stem.replaceFirst("et$", "es");
        }
        stem = stem.replaceFirst("yt$", "ys");
        stem = stem.replaceFirst("yz$", "ys");
        return stem;
    }

    @Override
    public String stem(String word) {
        return LovinsStemmer.fixStem(LovinsStemmer.removeEnding(word));
    }
}

