/*
 * Decompiled with CFR 0.152.
 */
package jsat.regression.evaluation;

import jsat.regression.evaluation.TotalHistoryRegressionScore;

public class RelativeAbsoluteError
extends TotalHistoryRegressionScore {
    private static final long serialVersionUID = -6152988968756871647L;

    public RelativeAbsoluteError() {
    }

    public RelativeAbsoluteError(RelativeAbsoluteError toCopy) {
        super(toCopy);
    }

    @Override
    public double getScore() {
        double trueMean = this.truths.getVecView().mean();
        double numer = 0.0;
        double denom = 0.0;
        for (int i = 0; i < this.truths.size(); ++i) {
            numer += Math.abs(this.predictions.getD(i) - this.truths.getD(i));
            denom += Math.abs(trueMean - this.truths.getD(i));
        }
        return numer / denom;
    }

    @Override
    public boolean lowerIsBetter() {
        return true;
    }

    @Override
    public RelativeAbsoluteError clone() {
        return new RelativeAbsoluteError(this);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.getClass().isAssignableFrom(obj.getClass()) && obj.getClass().isAssignableFrom(this.getClass());
    }

    @Override
    public String getName() {
        return "Relative Absolute Error";
    }
}

