/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.distancemetrics;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import jsat.linear.Vec;

public interface DistanceMetric
extends Cloneable,
Serializable {
    public double dist(Vec var1, Vec var2);

    public boolean isSymmetric();

    public boolean isSubadditive();

    public boolean isIndiscemible();

    default public boolean isValidMetric() {
        return this.isSymmetric() && this.isSubadditive() && this.isIndiscemible();
    }

    public double metricBound();

    public boolean supportsAcceleration();

    default public List<Double> getAccelerationCache(List<? extends Vec> vecs) {
        return this.getAccelerationCache(vecs, false);
    }

    public List<Double> getAccelerationCache(List<? extends Vec> var1, ExecutorService var2);

    public List<Double> getAccelerationCache(List<? extends Vec> var1, boolean var2);

    public double dist(int var1, int var2, List<? extends Vec> var3, List<Double> var4);

    public double dist(int var1, Vec var2, List<? extends Vec> var3, List<Double> var4);

    public List<Double> getQueryInfo(Vec var1);

    public double dist(int var1, Vec var2, List<Double> var3, List<? extends Vec> var4, List<Double> var5);

    public String toString();

    public DistanceMetric clone();
}

