/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import jsat.linear.Matrix;
import jsat.linear.Vec;

public class RowColumnOps {
    public static void addDiag(Matrix A, int start, int to, double c) {
        for (int i = start; i < to; ++i) {
            A.increment(i, i, c);
        }
    }

    public static void addRow(Matrix A, int i, int start, int to, double c) {
        for (int j = start; j < to; ++j) {
            A.increment(i, j, c);
        }
    }

    public static void addRow(Matrix A, int i, double c) {
        RowColumnOps.addRow(A, i, 0, A.cols(), c);
    }

    public static void multRow(Matrix A, int i, int start, int to, double c) {
        for (int j = start; j < to; ++j) {
            A.set(i, j, A.get(i, j) * c);
        }
    }

    public static void multRow(Matrix A, int i, double c) {
        RowColumnOps.multRow(A, i, 0, A.cols(), c);
    }

    public static void multRow(Matrix A, int i, int start, int to, Vec c) {
        for (int j = start; j < to; ++j) {
            A.set(i, j, A.get(i, j) * c.get(j));
        }
    }

    public static void multRow(Matrix A, int i, Vec c) {
        if (A.cols() != c.length()) {
            throw new ArithmeticException("Can not perform row update, length miss match " + A.cols() + " and " + c.length());
        }
        RowColumnOps.multRow(A, i, 0, c.length(), c);
    }

    public static void multRow(Matrix A, int i, int start, int to, double[] c) {
        for (int j = start; j < to; ++j) {
            A.set(i, j, A.get(i, j) * c[j]);
        }
    }

    public static void multRow(Matrix A, int i, double[] c) {
        if (A.cols() != c.length) {
            throw new ArithmeticException("Can not perform row update, length miss match " + A.cols() + " and " + c.length);
        }
        RowColumnOps.multRow(A, i, 0, c.length, c);
    }

    public static void divRow(Matrix A, int i, int start, int to, double c) {
        for (int j = start; j < to; ++j) {
            A.set(i, j, A.get(i, j) / c);
        }
    }

    public static void divRow(Matrix A, int i, double c) {
        RowColumnOps.divRow(A, i, 0, A.cols(), c);
    }

    public static void addCol(Matrix A, int j, int start, int to, double c) {
        for (int i = start; i < to; ++i) {
            A.increment(i, j, c);
        }
    }

    public static void addCol(Matrix A, int j, double c) {
        RowColumnOps.addCol(A, j, 0, A.rows(), c);
    }

    public static void multCol(Matrix A, int j, int start, int to, double c) {
        for (int i = start; i < to; ++i) {
            A.set(i, j, A.get(i, j) * c);
        }
    }

    public static void multCol(Matrix A, int j, double c) {
        RowColumnOps.multCol(A, j, 0, A.rows(), c);
    }

    public static void divCol(Matrix A, int j, int start, int to, double c) {
        for (int i = start; i < to; ++i) {
            A.set(i, j, A.get(i, j) / c);
        }
    }

    public static void divCol(Matrix A, int j, double c) {
        RowColumnOps.divCol(A, j, 0, A.rows(), c);
    }

    public static void divCol(Matrix A, int j, int start, int to, Vec c) {
        for (int i = start; i < to; ++i) {
            A.set(i, j, A.get(i, j) / c.get(i));
        }
    }

    public static void divCol(Matrix A, int j, int start, int to, double[] c) {
        for (int i = start; i < to; ++i) {
            A.set(i, j, A.get(i, j) / c[i]);
        }
    }

    public static void addMultRow(Matrix A, int i, int start, int to, double t, double[] c) {
        for (int j = start; j < to; ++j) {
            A.increment(i, j, c[j] * t);
        }
    }

    public static void addMultRow(Matrix A, int i, int start, int to, double t, Vec c) {
        for (int j = start; j < to; ++j) {
            A.increment(i, j, c.get(j) * t);
        }
    }

    public static void addMultCol(Matrix A, int j, int start, int to, double t, double[] c) {
        for (int i = start; i < to; ++i) {
            A.increment(i, j, c[i] * t);
        }
    }

    public static void addMultCol(Matrix A, int j, int start, int to, double t, Vec c) {
        for (int i = start; i < to; ++i) {
            A.increment(i, j, c.get(i) * t);
        }
    }

    public static void swapCol(Matrix A, int j, int k, int start, int to) {
        for (int i = start; i < to; ++i) {
            double t = A.get(i, j);
            A.set(i, j, A.get(i, k));
            A.set(i, k, t);
        }
    }

    public static void swapCol(Matrix A, int j, int k) {
        RowColumnOps.swapCol(A, j, k, 0, A.rows());
    }

    public static void swapRow(Matrix A, int j, int k, int start, int to) {
        for (int i = start; i < to; ++i) {
            double t = A.get(j, i);
            A.set(j, i, A.get(k, i));
            A.set(k, i, t);
        }
    }

    public static void swapRow(Matrix A, int j, int k) {
        RowColumnOps.swapCol(A, j, k, 0, A.cols());
    }

    public static void fillRow(Matrix A, int i, int from, int to, double val) {
        for (int j = from; j < to; ++j) {
            A.set(i, j, val);
        }
    }

    public static void fillCol(Matrix A, int j, int from, int to, double val) {
        for (int i = from; i < to; ++i) {
            A.set(i, j, val);
        }
    }
}

