/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.neuralnetwork.initializers;

import java.util.Random;
import jsat.classifiers.neuralnetwork.initializers.BiastInitializer;
import jsat.classifiers.neuralnetwork.initializers.WeightInitializer;
import jsat.linear.Matrix;
import jsat.linear.Vec;

public class TanhInitializer
implements WeightInitializer,
BiastInitializer {
    private static final long serialVersionUID = -4770682311082616208L;

    @Override
    public void init(Matrix w, Random rand) {
        double cnt = Math.sqrt(6.0) / Math.sqrt(w.rows() + w.cols());
        for (int i = 0; i < w.rows(); ++i) {
            for (int j = 0; j < w.cols(); ++j) {
                w.set(i, j, rand.nextDouble() * cnt * 2.0 - cnt);
            }
        }
    }

    @Override
    public void init(Vec b, int fanIn, Random rand) {
        double cnt = Math.sqrt(6.0) / Math.sqrt(b.length() + fanIn);
        for (int i = 0; i < b.length(); ++i) {
            b.set(i, rand.nextDouble() * cnt * 2.0 - cnt);
        }
    }

    @Override
    public TanhInitializer clone() {
        return new TanhInitializer();
    }
}

