/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.DAG.decomp.Study;
import org.rhwlab.DAG.decomp.UnifiedResult;
import org.rhwlab.DAG.views.GeneTablePanel;
import org.rhwlab.DAG.views.UnifiedGenePanel;
import org.rhwlab.RNASeq.TimeWarpedDataSource;

public class UnifiedResultFrame
extends JFrame
implements Runnable,
ChangeListener {
    List<Study> studies;
    GeneTablePanel geneTablePanel;
    JPanel centerPanel;

    public void init() {
        this.setTitle("Unified RNASeq");
        this.setDefaultCloseOperation(3);
        this.geneTablePanel.addListener(this);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        JScrollPane scroll = new JScrollPane(this.centerPanel);
        JSplitPane splitPane = new JSplitPane(1, true, scroll, this.geneTablePanel.getPanel());
        this.setContentPane(splitPane);
        this.pack();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        GeneTablePanel panel = (GeneTablePanel)e.getSource();
        String[] genes = panel.getSelectedGenes();
        this.centerPanel.removeAll();
        for (String gene : genes) {
            try {
                JPanel genePanel = new JPanel();
                genePanel.setLayout(new BoxLayout(genePanel, 0));
                for (Study study : this.studies) {
                    UnifiedGenePanel unifiedPanel = new UnifiedGenePanel();
                    unifiedPanel.setGene(gene);
                    UnifiedResult result = study.getUnifiedResult();
                    TimeWarpedDataSource source = study.getTimeWarpedDataSource();
                    unifiedPanel.setLabel(result.getLabel());
                    unifiedPanel.setDataSources(source);
                    unifiedPanel.setUnifiedResult(result);
                    unifiedPanel.init();
                    genePanel.add((Component)unifiedPanel.getPanel());
                }
                this.centerPanel.add(genePanel);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        this.validate();
        this.repaint();
    }

    public void setGeneTable(Object obj) {
        this.geneTablePanel = (GeneTablePanel)obj;
    }

    public void setStudies(Object obj) {
        if (obj instanceof List) {
            this.studies = (List)obj;
        } else {
            this.studies = new ArrayList<Study>();
            this.studies.add((Study)obj);
        }
    }

    @Override
    public void run() {
        this.setSize(500, 500);
        this.setVisible(true);
    }
}

