/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.Color;
import java.awt.Paint;
import java.util.Set;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.DAG.decomp.UnifiedResult;
import org.rhwlab.RNASeq.RNASeq;

public class UnifiedGenePanelOrig {
    Color[] colors = new Color[]{Color.red, Color.blue, Color.green, Color.yellow};
    ChartPanel panel;
    boolean all = false;

    public UnifiedGenePanelOrig(String gene, UnifiedResult result) throws Exception {
        this(gene, result, false);
    }

    public UnifiedGenePanelOrig(String gene, UnifiedResult result, boolean all) throws Exception {
        this.all = all;
        double[] pseudoTimes = result.getUnifiedTimes();
        double[] unified = result.getGeneData(gene);
        XYSeriesCollection collect = new XYSeriesCollection();
        JFreeChart chart = ChartFactory.createXYLineChart((String)(gene + " (Unified Data)"), (String)"DevelopmentalTime", (String)"DCPM", (XYDataset)collect, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        XYLineAndShapeRenderer rend = new XYLineAndShapeRenderer();
        plot.setRenderer((XYItemRenderer)rend);
        Set<String> exps = result.getExperiments();
        int s = 0;
        System.out.print("Gene");
        for (String exp : exps) {
            int[] sampleTimes = result.getSamples(exp);
            double[] times = result.getTimes(exp);
            for (int i = 0; i < sampleTimes.length; ++i) {
                System.out.printf(",%s_%d_%d", exp, sampleTimes[i], (int)times[i]);
            }
        }
        for (int i = 0; i < unified.length; ++i) {
            System.out.printf("Unified_%d_%d ", i + 1, (int)pseudoTimes[i]);
        }
        System.out.println();
        System.out.printf("%s", gene);
        for (String exp : exps) {
            RNASeq rnaSeq = new RNASeq(exp, gene);
            int[] sampleTimes = result.getSamples(exp);
            double[] times = result.getTimes(exp);
            XYSeries series = new XYSeries((Comparable)((Object)exp));
            for (int i = 0; i < sampleTimes.length; ++i) {
                double e = rnaSeq.getExpression(Integer.valueOf(sampleTimes[i]));
                series.add(times[i], e);
                System.out.printf(",%f", e);
            }
            collect.addSeries(series);
            rend.setSeriesLinesVisible(s, false);
            rend.setSeriesShapesVisible(s, true);
            rend.setSeriesPaint(s, (Paint)this.colors[s]);
            ++s;
        }
        if (all) {
            for (String exp : exps) {
                XYSeries series = new XYSeries((Comparable)((Object)(exp + "Uni")));
                RNASeq rnaSeq = new RNASeq(exp, gene);
                double[] uni = UnifiedGenePanelOrig.normalizeTo(unified, rnaSeq.getMean(), rnaSeq.getSD());
                for (int i = 0; i < unified.length; ++i) {
                    series.add(pseudoTimes[i], uni[i]);
                }
                collect.addSeries(series);
                rend.setSeriesLinesVisible(s, true);
                rend.setSeriesShapesVisible(s, false);
                rend.setSeriesPaint(s, (Paint)this.colors[s - exps.size()]);
                ++s;
            }
        }
        XYSeries series = new XYSeries((Comparable)((Object)"Unified"));
        for (int i = 0; i < unified.length; ++i) {
            series.add(pseudoTimes[i], unified[i]);
            System.out.printf(",%f", unified[i]);
        }
        System.out.println();
        collect.addSeries(series);
        rend.setSeriesLinesVisible(s, true);
        rend.setSeriesShapesVisible(s, false);
        rend.setSeriesPaint(s, (Paint)Color.black);
        this.panel = new ChartPanel(chart);
    }

    public ChartPanel getPanel() {
        return this.panel;
    }

    public static double[] normalizeTo(double[] rawdata, double mu, double sd, double expMu, double expSD) {
        int i;
        double min = 0.0;
        double[] data = new double[rawdata.length];
        for (i = 0; i < data.length; ++i) {
            data[i] = expSD * (rawdata[i] - mu) / sd + expMu;
            if (!(data[i] < min)) continue;
            min = data[i];
        }
        if (min < 0.0) {
            for (i = 0; i < data.length; ++i) {
                data[i] = data[i] - min;
            }
        }
        return data;
    }

    public static double[] normalizeTo(double[] rawdata, double expMu, double expSD) {
        double mu = StatUtils.mean((double[])rawdata);
        double sd = Math.sqrt(StatUtils.variance((double[])rawdata, (double)mu));
        return UnifiedGenePanelOrig.normalizeTo(rawdata, mu, sd, expMu, expSD);
    }
}

