/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.Color;
import java.awt.Paint;
import java.util.TreeMap;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.DAG.decomp.UnifiedResult;
import org.rhwlab.RNASeq.DataSource;
import org.rhwlab.RNASeq.ExperimentDataSource;
import org.rhwlab.RNASeq.TimeWarpedDataSource;

public class UnifiedGenePanel {
    XYSeriesCollection collect;
    JFreeChart chart;
    XYPlot plot;
    XYLineAndShapeRenderer rend;
    static TreeMap<String, Color> colors = new TreeMap();
    ChartPanel panel;
    UnifiedResult unifiedResult;
    TimeWarpedDataSource dataSource;
    String label;
    String gene;

    public void init() throws Exception {
        this.collect = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)this.label, (String)"DevelopmentalTime", (String)"DCPM", (XYDataset)this.collect, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.plot = this.chart.getXYPlot();
        this.rend = new XYLineAndShapeRenderer();
        this.plot.setRenderer((XYItemRenderer)this.rend);
        double error = this.unifiedResult.rmsErrorNoTimeWarping(this.gene, (DataSource)this.dataSource, this.dataSource.getKdeFile());
        this.chart.setTitle(this.gene + "_" + this.label + String.format("(%f)", error));
        this.plotExpData(this.gene, this.dataSource);
        this.plotUnified(this.gene, this.unifiedResult);
        this.panel = new ChartPanel(this.chart);
    }

    public void setGene(String gene) throws Exception {
        this.gene = gene;
    }

    private void plotUnified(String gene, UnifiedResult result) {
        double[] pseudoTimes = this.dataSource.getStageTimes();
        double[] unified = result.getGeneData(gene);
        XYSeries series = new XYSeries((Comparable)((Object)"Unified"));
        int s = this.collect.getSeriesCount();
        for (int i = 0; i < unified.length; ++i) {
            series.add(pseudoTimes[i], unified[i]);
        }
        this.collect.addSeries(series);
        this.rend.setSeriesLinesVisible(s, true);
        this.rend.setSeriesShapesVisible(s, false);
        this.rend.setSeriesPaint(s, (Paint)Color.black);
    }

    private void plotExpData(String gene, TimeWarpedDataSource source) throws Exception {
        String[] exps = source.getExperiments();
        int s = 0;
        for (String exp : exps) {
            ExperimentDataSource expSource = source.getExperimentSource(exp);
            double[] sampleTimes = source.getExperimentTimes(exp);
            double[] dcpm = expSource.getFeatureData(gene);
            XYSeries series = new XYSeries((Comparable)((Object)exp));
            for (int i = 0; i < sampleTimes.length; ++i) {
                series.add(sampleTimes[i], dcpm[i]);
            }
            this.collect.addSeries(series);
            this.rend.setSeriesLinesVisible(s, false);
            this.rend.setSeriesShapesVisible(s, true);
            this.rend.setSeriesPaint(s, (Paint)colors.get(exp));
            ++s;
        }
    }

    public ChartPanel getPanel() {
        return this.panel;
    }

    public static double[] normalizeTo(double[] rawdata, double mu, double sd, double expMu, double expSD) {
        int i;
        double min = 0.0;
        double[] data = new double[rawdata.length];
        for (i = 0; i < data.length; ++i) {
            data[i] = expSD * (rawdata[i] - mu) / sd + expMu;
            if (!(data[i] < min)) continue;
            min = data[i];
        }
        if (min < 0.0) {
            for (i = 0; i < data.length; ++i) {
                data[i] = data[i] - min;
            }
        }
        return data;
    }

    public static double[] normalizeTo(double[] rawdata, double expMu, double expSD) {
        double mu = StatUtils.mean((double[])rawdata);
        double sd = Math.sqrt(StatUtils.variance((double[])rawdata, (double)mu));
        return UnifiedGenePanel.normalizeTo(rawdata, mu, sd, expMu, expSD);
    }

    public void setUnifiedResult(Object obj) {
        this.unifiedResult = (UnifiedResult)obj;
    }

    public void setDataSources(Object obj) {
        this.dataSource = (TimeWarpedDataSource)obj;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    static {
        colors.put("20120223_EMB", Color.blue);
        colors.put("20120411_EMB", Color.green);
        colors.put("20120419_EMB", Color.MAGENTA);
        colors.put("N2_EE_50", Color.red);
    }
}

