/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.Dimension;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.rhwlab.utils.Tester;

public class UnifiedCorrelationDistributionPanel
extends ChartPanel {
    int n;
    String title;
    String[] genes;
    Map<String, double[]> corrs;
    List<Tester> testers = new ArrayList<Tester>();
    HistogramDataset dataset;

    public UnifiedCorrelationDistributionPanel(String title, String[] genes, Map<String, double[]> corrs, int n) {
        super(null);
        this.n = n;
        this.corrs = corrs;
        this.genes = genes;
        this.title = title;
    }

    public void init() {
        Set<String> corrSet = this.corrs.keySet();
        int N = this.corrs.keySet().size() + 1;
        this.n = Math.min(this.n, N - 1);
        int L = N - this.n;
        int D = (int)((double)N * ((double)(N - 1) / 2.0)) - (int)((double)(L * (L - 1)) / 2.0);
        int index = 0;
        ArrayList<Double> values = new ArrayList<Double>();
        for (String gene : this.corrs.keySet()) {
            double[] corr = this.corrs.get(gene);
            for (int i = 0; i < Math.min(corr.length, this.n); ++i) {
                index = corr.length - i - 1;
                String other = this.genes[index];
                boolean ok = true;
                for (Tester t : this.testers) {
                    if (t.test((Object)gene) && t.test((Object)other)) continue;
                    ok = false;
                    break;
                }
                if (ok && Double.isFinite(corr[index])) {
                    values.add(corr[index]);
                    continue;
                }
                boolean bl = false;
            }
        }
        double[] x = new double[values.size()];
        try {
            PrintWriter writer = new PrintWriter(this.title);
            for (int i = 0; i < x.length; ++i) {
                x[i] = (Double)values.get(i);
                writer.printf("%d: %f\n", i, x[i]);
            }
            writer.close();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        this.dataset = new HistogramDataset();
        this.dataset.addSeries((Comparable)((Object)String.format("%d gene window", this.n)), x, 1000);
        JFreeChart chart = ChartFactory.createHistogram((String)this.title, (String)"Spearmans", (String)"Frequency", (IntervalXYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.setChart(chart);
        this.setPreferredSize(new Dimension(400, 250));
    }

    public HistogramDataset getDataset() {
        return this.dataset;
    }

    public void addTester(Tester tester) {
        this.testers.add(tester);
    }
}

