/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.jfree.data.statistics.HistogramDataset;
import org.rhwlab.DAG.decomp.DCPMThresholdTester;
import org.rhwlab.DAG.decomp.OperonTester;
import org.rhwlab.DAG.decomp.UnifiedResult;
import org.rhwlab.DAG.views.HistogramCummulativePanel;
import org.rhwlab.DAG.views.UnifiedCorrelationDistributionPanel;
import org.rhwlab.db.beans.Gene;

public class UnifiedCorrelationDistributionFrame
extends JFrame
implements Runnable {
    String[] chromosomes = new String[]{"I", "II", "III", "IV", "V", "X"};
    HashMap<Integer, HashMap<String, HistogramDataset>> datasetMap;
    Integer[] windows = new Integer[]{2, 8, 200};
    Double[] dcpms = new Double[]{0.1, 0.4, 1.0, 5.0};
    UnifiedResult result;

    public UnifiedCorrelationDistributionFrame() {
        this.setTitle("Only Operons");
    }

    public void init() throws Exception {
        JTabbedPane tabPane = new JTabbedPane();
        for (String chrom : this.chromosomes) {
            ArrayList unfiltered = Gene.getGenesOnChromosome((String)chrom);
            ArrayList<String> sequence = new ArrayList<String>();
            HashMap<String, Gene> geneMap = new HashMap<String, Gene>();
            for (Gene gene : unfiltered) {
                sequence.add(gene.getSequenceName());
                geneMap.put(gene.getSequenceName(), gene);
            }
            OperonTester operonTester = new OperonTester();
            operonTester.setGeneMap(geneMap);
            List<String> filtered = this.result.filterGenesByThreshold(sequence, 0.0);
            String[] genes = filtered.toArray(new String[0]);
            LinkedHashMap<String, double[]> corrMap = this.result.pairwiseCorrelation(genes);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            JScrollPane scroll = new JScrollPane(panel);
            tabPane.add(chrom, scroll);
            for (Double dcpm : this.dcpms) {
                DCPMThresholdTester tester = new DCPMThresholdTester();
                tester.setThreshold(dcpm);
                tester.setResult(this.result);
                HashMap<Object, HistogramDataset> windowMap = new HashMap<Object, HistogramDataset>();
                JPanel windowPanel = new JPanel();
                windowPanel.setLayout(new BoxLayout(windowPanel, 1));
                for (Integer window : this.windows) {
                    UnifiedCorrelationDistributionPanel corrPanel = new UnifiedCorrelationDistributionPanel(String.format("%s(%f)_%d", chrom, dcpm, window), genes, corrMap, window);
                    corrPanel.addTester(tester);
                    corrPanel.addTester(operonTester);
                    corrPanel.init();
                    windowPanel.add((Component)((Object)corrPanel));
                    windowMap.put(window, corrPanel.getDataset());
                }
                HistogramCummulativePanel cummPanel = new HistogramCummulativePanel(String.format("%s(%f)", chrom, dcpm), windowMap);
                windowPanel.add((Component)((Object)cummPanel));
                panel.add(windowPanel);
            }
        }
        this.add(tabPane);
    }

    @Override
    public void run() {
        this.setSize(1500, 500);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public void setResult(Object obj) {
        this.result = (UnifiedResult)obj;
    }

    public static void main(String[] args) throws Exception {
        UnifiedResult result = new UnifiedResult();
        UnifiedCorrelationDistributionFrame frame = new UnifiedCorrelationDistributionFrame();
        frame.setResult(result);
        frame.init();
        EventQueue.invokeLater(frame);
    }
}

