/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.rhwlab.DAG.views.HistogramPanel;
import org.rhwlab.DAG.views.IterationPanel;

public class SingleVariableDisplayPanel
extends JPanel {
    double[] values;
    static HashMap<String, String> labelMap;

    public SingleVariableDisplayPanel(String var, double[] vals, int start, int end) throws Exception {
        this.values = vals;
        this.makeMap();
        this.makePanel(var, start);
    }

    private void makeMap() {
        if (labelMap == null) {
            labelMap = new HashMap();
            labelMap.put("StartTime", "Developmental Time of Zero Time Sample");
            labelMap.put("DispersionRate", "Increase in Stage Distribution Variance");
            labelMap.put("GrowthRate", "Ratio of Developmental to Sample Time");
            labelMap.put("InitialVariance", "Initial Stage Distribution Variance");
        }
    }

    public SingleVariableDisplayPanel(String var, ArrayList<String> valuesList, int start, int end) throws Exception {
        this.makeMap();
        this.values = new double[end - start];
        for (int i = start; i < end; ++i) {
            this.values[i - start] = Double.valueOf(valuesList.get(i));
        }
        this.makePanel(var, start);
    }

    private final void makePanel(String var, int start) {
        this.setLayout(new BoxLayout(this, 0));
        String label = SingleVariableDisplayPanel.variableConversion(var);
        HistogramPanel histPanel = new HistogramPanel(label, this.values);
        IterationPanel iterPanel = new IterationPanel(label, this.values, start);
        this.add(histPanel);
        this.add(iterPanel);
    }

    static String variableConversion(String var) {
        String[] tokens = var.split("_");
        String label = labelMap.get(tokens[0]);
        if (label == null) {
            return var;
        }
        return label;
    }
}

