/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.util.Set;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.DAG.decomp.UnifiedResult;
import org.rhwlab.RNASeq.RNASeq;

public class RawGenePanel {
    ChartPanel panel;

    RawGenePanel(String gene, UnifiedResult result) throws Exception {
        XYSeriesCollection collect = new XYSeriesCollection();
        JFreeChart chart = ChartFactory.createXYLineChart((String)(gene + " (N2 Data)"), (String)"SampleTime", (String)"DCPM", (XYDataset)collect, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        XYLineAndShapeRenderer rend = new XYLineAndShapeRenderer();
        plot.setRenderer((XYItemRenderer)rend);
        Set<String> exps = result.getExperiments();
        int s = 0;
        for (String exp : exps) {
            RNASeq rnaSeq = new RNASeq(exp, gene);
            int[] sampleTimes = result.getSamples(exp);
            XYSeries series = new XYSeries((Comparable)((Object)exp));
            for (int i = 0; i < sampleTimes.length; ++i) {
                double e = rnaSeq.getExpression(Integer.valueOf(sampleTimes[i]));
                series.add((double)sampleTimes[i], e);
            }
            collect.addSeries(series);
            rend.setSeriesLinesVisible(s, false);
            rend.setSeriesShapesVisible(s, true);
            ++s;
        }
        this.panel = new ChartPanel(chart);
    }

    public ChartPanel getPanel() {
        return this.panel;
    }
}

