/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rhwlab.DAG.decomp.Config;
import org.rhwlab.DAG.decomp.PMatrix;
import org.rhwlab.DAG.pipeline.MCMC;
import org.rhwlab.DAG.pipeline.Pipeline;
import org.rhwlab.DAG.views.ExperimentStageTimeDistPanel;
import org.rhwlab.RNASeq.DataSource;
import org.rhwlab.RNASeq.KdeFile;
import org.rhwlab.RNASeq.PMatrixKdeFile;
import org.rhwlab.views.BufferedImagePanel;
import org.tc33.jheatchart.HeatChart;

public class PMatrixFrame
extends JFrame {
    public PMatrixFrame(DataSource source, Config config, PMatrixKdeFile kde) throws Exception {
        PMatrix P;
        Object[] sTimes;
        double[] sampleTimes;
        Object[] experiments = source.getExperiments();
        double timeInc = kde.getValue("TimeInc", "Mode");
        int N = config.getNStages();
        Object[] stageValues = new Integer[N];
        for (int i = 1; i <= N; ++i) {
            stageValues[i - 1] = new Integer(i);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 2));
        Arrays.sort(experiments);
        for (Object experiment : experiments) {
            sampleTimes = source.getExperimentTimes((String)experiment);
            sTimes = new Integer[sampleTimes.length];
            for (int i = 0; i < sTimes.length; ++i) {
                sTimes[i] = new Integer((int)sampleTimes[i]);
            }
            P = new PMatrix(N, sampleTimes, (String)experiment, null, kde);
            for (int i = 0; i < sampleTimes.length; ++i) {
                System.out.printf("%s,%d,%f\n", experiment, (int)sampleTimes[i], P.getMean(i));
            }
            ExperimentStageTimeDistPanel expPanel = new ExperimentStageTimeDistPanel((String)experiment, P, source, 1000.0);
            panel.add((String)experiment, (Component)expPanel.getPanel());
        }
        for (Object experiment : experiments) {
            sampleTimes = source.getExperimentTimes((String)experiment);
            sTimes = new Integer[sampleTimes.length];
            for (int i = 0; i < sTimes.length; ++i) {
                sTimes[i] = new Integer((int)sampleTimes[i]);
            }
            P = new PMatrix(N, sampleTimes, (String)experiment, null, kde);
            double[][] pValues = new double[N][];
            for (int r = 0; r < N; ++r) {
                pValues[r] = P.getRow(r);
            }
            HeatChart heatChart = new HeatChart((double[][])pValues);
            heatChart.setHighValueColour(Color.RED);
            heatChart.setLowValueColour(Color.WHITE);
            heatChart.setTitle((String)experiment);
            heatChart.setXAxisLabel("Sample Times");
            heatChart.setXValues(sTimes);
            heatChart.setYAxisLabel("Stage");
            heatChart.setYValues(stageValues);
            BufferedImage image = (BufferedImage)heatChart.getChartImage();
            BufferedImagePanel imagePanel = new BufferedImagePanel(image);
            panel.add((String)experiment, (Component)imagePanel);
        }
        JScrollPane scroll = new JScrollPane(panel);
        this.setContentPane(scroll);
        this.pack();
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Pipeline pipe = new Pipeline(args[0]);
                    MCMC mcmc = pipe.getMCMC();
                    DataSource source = mcmc.getDataSource();
                    Config config = mcmc.getConfig();
                    PMatrixKdeFile initializingKDE = mcmc.getPKDE();
                    KdeFile pResults = new KdeFile(args[0] + ".kde");
                    initializingKDE.combine(pResults);
                    PMatrixFrame frame = new PMatrixFrame(source, config, initializingKDE);
                    frame.setSize(500, 500);
                    frame.setDefaultCloseOperation(3);
                    frame.setTitle(args[0]);
                    frame.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }
}

