/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.jfree.data.statistics.HistogramDataset;
import org.rhwlab.DAG.decomp.UnifiedResult;
import org.rhwlab.DAG.views.HistogramCummulativePanel;
import org.rhwlab.DAG.views.OldVersionPanel;
import org.rhwlab.db.beans.Gene;

public class OldVersionFrame
extends JFrame
implements Runnable {
    String[] chromosomes = new String[]{"I"};
    HashMap<Double, List<String>> chromosomeGenesMap;
    HashMap<Double, Map<String, double[]>> correlationMap;
    HashMap<Integer, HashMap<String, HistogramDataset>> datasetMap;
    Integer[] windows = new Integer[]{2};
    Double[] dcpms = new Double[]{0.0};
    UnifiedResult result;

    public void init() throws Exception {
        JTabbedPane tabPane = new JTabbedPane();
        for (String chrom : this.chromosomes) {
            List chromoGenes = Gene.oldgetGenesOnChromosome((String)chrom);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            JScrollPane scroll = new JScrollPane(panel);
            tabPane.add(chrom, scroll);
            this.chromosomeGenesMap = new HashMap();
            this.correlationMap = new HashMap();
            for (Double dcpm : this.dcpms) {
                List<String> filteredGenes = this.result.filterGenesByThreshold(chromoGenes, (double)dcpm);
                this.chromosomeGenesMap.put(dcpm, filteredGenes);
                String[] genes = new String[filteredGenes.size()];
                for (int i = 0; i < genes.length; ++i) {
                    genes[i] = filteredGenes.get(i);
                }
                this.correlationMap.put(dcpm, this.result.pairwiseCorrelation(genes));
                System.out.printf("Chromosome: %s, DCPM Threshold: %f, Genes: %d\n", chrom, dcpm, filteredGenes.size());
                HashMap<Object, HistogramDataset> windowMap = new HashMap<Object, HistogramDataset>();
                JPanel windowPanel = new JPanel();
                windowPanel.setLayout(new BoxLayout(windowPanel, 1));
                for (Integer window : this.windows) {
                    OldVersionPanel corrPanel = new OldVersionPanel(filteredGenes, this.correlationMap.get(dcpm), window);
                    windowPanel.add((Component)((Object)corrPanel));
                    windowMap.put(window, corrPanel.getDataset());
                }
                HistogramCummulativePanel cummPanel = new HistogramCummulativePanel(String.format("%s(%f)", chrom, dcpm), windowMap);
                windowPanel.add((Component)((Object)cummPanel));
                panel.add(windowPanel);
            }
        }
        this.add(tabPane);
    }

    @Override
    public void run() {
        this.setSize(1500, 500);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public void setResult(Object obj) {
        this.result = (UnifiedResult)obj;
    }

    public static void main(String[] args) throws Exception {
        UnifiedResult result = new UnifiedResult();
        OldVersionFrame frame = new OldVersionFrame();
        frame.setResult(result);
        frame.init();
        EventQueue.invokeLater(frame);
    }
}

