/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.rhwlab.DAG.views.SingleVariableDisplayPanel;
import org.rhwlab.demux.MultiVariableFormat;

public class MultipleVariablesDisplayPanel
extends JPanel {
    public void displayVariablesMultiFormat(String[] vars, String directory, int start, int end) throws Exception {
        this.removeAll();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        for (String var : vars) {
            File file = new File(directory, var);
            TreeMap map = MultiVariableFormat.readFile((File)file, (Integer)start);
            for (String name : map.keySet()) {
                double[] vals = (double[])map.get(name);
                SingleVariableDisplayPanel single = new SingleVariableDisplayPanel(name, vals, start, end);
                mainPanel.add(single);
            }
        }
        this.add(mainPanel);
    }

    public void displayVariables(String[] vars, String directory, int start, int end) throws Exception {
        this.removeAll();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        for (String var : vars) {
            ArrayList<String> valuesList = this.readSingleVariableFile(directory, var);
            SingleVariableDisplayPanel single = new SingleVariableDisplayPanel(var, valuesList, start, end);
            mainPanel.add(single);
        }
        this.add(mainPanel);
    }

    private ArrayList<String> readSingleVariableFile(String directory, String var) throws Exception {
        ArrayList<String> valuesList = new ArrayList<String>();
        File file = new File(directory, var);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String value = reader.readLine();
        while (value != null) {
            valuesList.add(value);
            value = reader.readLine();
        }
        reader.close();
        return valuesList;
    }
}

