/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.Dimension;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class HistogramCummulativePanel
extends ChartPanel {
    public HistogramCummulativePanel(String title, Map<Object, HistogramDataset> histogramDatasets) {
        super(null);
        XYSeriesCollection collect = new XYSeriesCollection();
        for (Object label : histogramDatasets.keySet()) {
            HistogramDataset histogram = histogramDatasets.get(label);
            for (int s = 0; s < histogram.getSeriesCount(); ++s) {
                XYSeries xySeries = new XYSeries((Comparable)((Object)String.format("%s_%d", label.toString(), s)));
                double sum = 0.0;
                for (int i = 0; i < histogram.getItemCount(s); ++i) {
                    sum += histogram.getYValue(s, i);
                }
                double y = 0.0;
                for (int i = 0; i < histogram.getItemCount(s); ++i) {
                    double x = histogram.getXValue(s, i);
                    xySeries.add(x, (y += histogram.getYValue(s, i)) / sum);
                }
                collect.addSeries(xySeries);
            }
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)"Spearmans", (String)"CDF", (XYDataset)collect, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.setChart(chart);
        this.setPreferredSize(new Dimension(400, 250));
    }
}

