/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.rhwlab.DAG.changepoints.views.ChangeNotifier;

public class GeneTablePanel
extends ChangeNotifier {
    String geneListFile;
    File[] dataFiles = new File[0];
    Set<String> geneList;
    JPanel panel = new JPanel();
    JTable table;

    public void init() throws Exception {
        if (this.geneListFile != null) {
            BufferedReader reader = new BufferedReader(new FileReader(this.geneListFile));
            this.geneList = new LinkedHashSet<String>();
            String line = reader.readLine();
            while (line != null) {
                this.geneList.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        DefaultTableModel model = new DefaultTableModel();
        model.setRowCount(this.geneList.size());
        this.table = new JTable(model);
        this.table.setAutoCreateRowSorter(true);
        int column = 1;
        model.addColumn("Gene");
        int row = 0;
        for (String gene : this.geneList) {
            model.setValueAt(gene, row, 0);
            ++row;
        }
        for (int i = 0; i < this.dataFiles.length; ++i) {
            File file = this.dataFiles[i];
            BufferedReader reader = new BufferedReader(new FileReader(this.dataFiles[i]));
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            String line = reader.readLine();
            String[] tokens = line.split(",");
            int n = tokens.length - 1;
            for (int j = 1; j < tokens.length; ++j) {
                model.addColumn(String.format("%s", tokens[j]));
            }
            line = reader.readLine();
            while (line != null) {
                tokens = line.split(",");
                map.put(tokens[0], tokens);
                line = reader.readLine();
            }
            reader.close();
            row = 0;
            for (String gene : this.geneList) {
                String[] data = (String[])map.get(gene);
                if (data != null) {
                    for (int k = 0; k < n; ++k) {
                        model.setValueAt(data[k + 1], row, column + k);
                    }
                } else {
                    boolean bl = false;
                }
                ++row;
            }
            column += n;
        }
        if (this.dataFiles.length > 0) {
            TableRowSorter sorter = (TableRowSorter)this.table.getRowSorter();
            for (int c = 2; c < 6; ++c) {
                sorter.setComparator(c, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Double d1 = Double.parseDouble((String)o1);
                        Double d2 = Double.parseDouble((String)o2);
                        return d1.compareTo(d2);
                    }
                });
            }
        }
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.table);
        this.panel.add(scroll);
        JButton button = new JButton("Display");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneTablePanel.this.notifyListeners();
            }
        });
        this.panel.add(button);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String[] getSelectedGenes() {
        int[] rows = this.table.getSelectedRows();
        String[] ret = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            int row = this.table.convertRowIndexToModel(rows[i]);
            ret[i] = (String)this.table.getModel().getValueAt(row, 0);
        }
        return ret;
    }

    public void setGeneListFile(String file) throws Exception {
        this.geneListFile = file;
    }

    public void setDataFiles(Object o) {
        this.dataFiles = (File[])o;
    }

    public void setGeneList(Object o) {
        this.geneList = (Set)o;
    }
}

