/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.rhwlab.DAG.views.MultipleVariablesDisplayPanel;

public class FullMarginalViewer
extends JFrame {
    String dir;
    JList varJList;
    boolean singleVar;
    MultipleVariablesDisplayPanel dispPanel;
    JTextField firstField = new JTextField("0");
    JTextField lastField = new JTextField();

    public FullMarginalViewer(String directory, String total, boolean single) {
        this.dir = directory;
        this.setDefaultCloseOperation(3);
        this.setTitle(directory);
        this.getContentPane().setLayout(new BorderLayout());
        this.singleVar = single;
        String[] vars = this.variableList(directory);
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String var : vars) {
            model.addElement(var);
        }
        this.varJList = new JList(model);
        JScrollPane scroll = new JScrollPane(this.varJList);
        JPanel varPanel = new JPanel();
        varPanel.setLayout(new BoxLayout(varPanel, 1));
        JButton display = new JButton("Display");
        display.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FullMarginalViewer.this.displayChoosenVariables(FullMarginalViewer.this.singleVar);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
        varPanel.add(display);
        varPanel.add(scroll);
        this.add((Component)varPanel, "East");
        JScrollPane dispscroll = new JScrollPane();
        this.dispPanel = new MultipleVariablesDisplayPanel();
        dispscroll.setViewportView(this.dispPanel);
        this.add((Component)dispscroll, "Center");
        JPanel rangePanel = new JPanel();
        rangePanel.setLayout(new BoxLayout(rangePanel, 0));
        rangePanel.add(new JLabel("First: "));
        rangePanel.add(this.firstField);
        rangePanel.add(Box.createHorizontalStrut(50));
        rangePanel.add(new JLabel("Last: "));
        rangePanel.add(this.lastField);
        this.lastField.setText(total);
        rangePanel.add(Box.createHorizontalStrut(50));
        rangePanel.add(new JLabel("Total Iterations: " + total));
        this.add((Component)rangePanel, "North");
        this.pack();
    }

    private void displayChoosenVariables(boolean single) throws Exception {
        List selected = this.varJList.getSelectedValuesList();
        int start = Integer.valueOf(this.firstField.getText());
        int end = Integer.valueOf(this.lastField.getText());
        if (single) {
            this.dispPanel.displayVariables(selected.toArray(new String[0]), this.dir, start, end);
        } else {
            this.dispPanel.displayVariablesMultiFormat(selected.toArray(new String[0]), this.dir, start, end);
        }
        this.pack();
        this.dispPanel.validate();
        this.dispPanel.repaint();
    }

    private String[] variableList(String directory) {
        File dirFile = new File(directory);
        if (dirFile.isDirectory()) {
            File[] files = dirFile.listFiles();
            Object[] variables = new String[files.length];
            for (int i = 0; i < variables.length; ++i) {
                variables[i] = files[i].getName();
            }
            Arrays.sort(variables);
            return variables;
        }
        return null;
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean format = true;
                    if (args.length > 2) {
                        format = false;
                    }
                    FullMarginalViewer frame = new FullMarginalViewer(args[0], args[1], format);
                    frame.setSize(500, 500);
                    frame.setVisible(true);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
    }
}

