/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.DAG.decomp.PMatrix;
import org.rhwlab.RNASeq.DataSource;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class ExperimentStageTimeDistPanel {
    ChartPanel chartPanel;

    ExperimentStageTimeDistPanel(String experiment, PMatrix P, DataSource source, double maxValue) {
        double inc = maxValue / 500.0;
        XYSeriesCollection collection = new XYSeriesCollection();
        double[] sampleTimes = source.getExperimentSource(experiment).getTimes();
        for (int i = 0; i < sampleTimes.length; ++i) {
            double mean = P.getMean(i);
            double variance = P.getVariance(i);
            XYSeries xySeries = new XYSeries((Comparable)((Object)String.format("Sample%3d", (int)sampleTimes[i])));
            for (double x = 0.0; x <= maxValue; x += inc) {
                double y = NormalDist.density((double)mean, (double)Math.sqrt(variance), (double)x);
                xySeries.add(x, y);
            }
            collection.addSeries(xySeries);
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)experiment, (String)"Developmental Time", (String)"Embryo Proportion", (XYDataset)collection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setPreferredSize(new Dimension(400, 400));
    }

    public ChartPanel getPanel() {
        return this.chartPanel;
    }
}

