/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.rhwlab.db.beans.ChromosomeFeatures;
import org.rhwlab.db.beans.FeatureTester;

public class CorrelationDistributionPanel
extends ChartPanel {
    int n;
    String title;
    ChromosomeFeatures rawData;
    List<String> features;
    Map<String, double[]> corrs;
    List<FeatureTester> testers = new ArrayList<FeatureTester>();
    HistogramDataset dataset;

    public CorrelationDistributionPanel(String title, List<String> features, ChromosomeFeatures raw, Map<String, double[]> corrs, int n) {
        super(null);
        this.n = n;
        this.corrs = corrs;
        this.rawData = raw;
        this.title = title;
        this.features = features;
    }

    public void init() {
        int N = this.corrs.keySet().size() + 1;
        this.n = Math.min(this.n, N - 1);
        int L = N - this.n;
        int D = (int)((double)N * ((double)(N - 1) / 2.0)) - (int)((double)(L * (L - 1)) / 2.0);
        int index = 0;
        ArrayList<Double> values = new ArrayList<Double>();
        for (String feature : this.corrs.keySet()) {
            double[] corr = this.corrs.get(feature);
            for (int i = 0; i < Math.min(corr.length, this.n); ++i) {
                index = corr.length - i - 1;
                String other = this.features.get(index);
                boolean ok = true;
                for (FeatureTester t : this.testers) {
                    if (t.test(feature, this.rawData) && t.test(other, this.rawData)) continue;
                    ok = false;
                    break;
                }
                if (ok && Double.isFinite(corr[index])) {
                    values.add(corr[index]);
                    continue;
                }
                boolean bl = false;
            }
        }
        double[] x = new double[values.size()];
        try {
            for (int i = 0; i < x.length; ++i) {
                x[i] = (Double)values.get(i);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        this.dataset = new HistogramDataset();
        this.dataset.addSeries((Comparable)((Object)String.format("%d gene window", this.n)), x, 1000);
        JFreeChart chart = ChartFactory.createHistogram((String)this.title, (String)"Spearmans", (String)"Frequency", (IntervalXYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.setChart(chart);
        this.setPreferredSize(new Dimension(400, 250));
    }

    public HistogramDataset getDataset() {
        return this.dataset;
    }

    public void addTester(FeatureTester tester) {
        this.testers.add(tester);
    }
}

