/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.views;

import java.awt.Component;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.jfree.data.statistics.HistogramDataset;
import org.rhwlab.DAG.views.CorrelationDistributionPanel;
import org.rhwlab.db.beans.ChromosomeFeatures;
import org.rhwlab.db.beans.FeatureTester;

public class CorrelationDistributionFrame
extends JFrame
implements Runnable {
    public static String[] chromosomes = new String[]{"I", "II", "III", "IV", "V", "X"};
    Integer[] windows;
    List<FeatureTester> testers;
    ChromosomeFeatures result;

    public void init() throws Exception {
        SpearmansCorrelation spear = new SpearmansCorrelation();
        JTabbedPane tabPane = new JTabbedPane();
        for (String chrom : chromosomes) {
            List features = this.result.getSortedFeatures(chrom);
            LinkedHashMap<String, double[]> corrMap = new LinkedHashMap<String, double[]>();
            for (int i = 1; i < features.size(); ++i) {
                String feature = (String)features.get(i);
                double[] data = this.result.getFeatureData(feature);
                double[] corrs = new double[i];
                for (int j = 0; j < i; ++j) {
                    String other = (String)features.get(j);
                    double[] otherData = this.result.getFeatureData(other);
                    corrs[j] = spear.correlation(data, otherData);
                }
                corrMap.put(feature, corrs);
            }
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            JScrollPane scroll = new JScrollPane(panel);
            tabPane.add(chrom, scroll);
            for (FeatureTester tester : this.testers) {
                HashMap<Integer, HistogramDataset> windowMap = new HashMap<Integer, HistogramDataset>();
                JPanel windowPanel = new JPanel();
                windowPanel.setLayout(new BoxLayout(windowPanel, 1));
                for (Integer window : this.windows) {
                    CorrelationDistributionPanel corrPanel = new CorrelationDistributionPanel(String.format("%s_%s_%d", chrom, tester.getLabel(), window), features, this.result, corrMap, window);
                    corrPanel.addTester(tester);
                    corrPanel.init();
                    windowPanel.add((Component)((Object)corrPanel));
                    windowMap.put(window, corrPanel.getDataset());
                }
                panel.add(windowPanel);
            }
        }
        this.add(tabPane);
    }

    @Override
    public void run() {
        this.setSize(1500, 500);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public void setResult(Object obj) {
        this.result = (ChromosomeFeatures)obj;
    }

    public void setFrameTitle(Object obj) {
        this.setTitle((String)obj);
    }

    public void setWindows(Object obj) {
        String s = (String)obj;
        String[] tokens = s.split(",|\t| ");
        this.windows = new Integer[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            this.windows[i] = new Integer(tokens[i]);
        }
    }

    public void setTesters(Object obj) {
        if (obj instanceof List) {
            this.testers = (List)obj;
        }
    }
}

