/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.proposal;

import org.rhwlab.DAG.distributions.Normal;
import org.rhwlab.DAG.proposal.ProposalDistribution;
import org.rhwlab.DAG.proposal.RandomWalk;

public class GaussianRandomWalk
extends RandomWalk {
    public double sd;

    public GaussianRandomWalk() {
    }

    public GaussianRandomWalk(double sd) {
        this.setSigma(sd);
    }

    public final void setSigma(double sd) {
        this.sd = sd;
        this.setSamplingDistribution(new Normal(0.0, sd * sd));
    }

    @Override
    public void adapt(int i, int a) {
        if (a > 0) {
            double sigma = this.sd * (double)a / (0.234 * (double)(i + 1));
            this.setSigma(sigma);
        }
    }

    @Override
    public ProposalDistribution copy() {
        GaussianRandomWalk ret = new GaussianRandomWalk();
        ret.setSigma(this.sd);
        return ret;
    }
}

