/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.proposal;

import org.rhwlab.DAG.distributions.Normal;
import org.rhwlab.DAG.proposal.MultiRandomWalk;
import org.rhwlab.DAG.proposal.ProposalDistribution;

public class GaussianMultiRandomWalk
extends MultiRandomWalk {
    double sd;

    public GaussianMultiRandomWalk() {
    }

    public GaussianMultiRandomWalk(double sd) {
        this.setSigma(sd);
    }

    public void setSigma(double sd) {
        this.sd = sd;
        this.setSamplingDistribution(new Normal(0.0, sd * sd));
    }

    @Override
    public void adapt(int i, int a) {
        if (a > 0) {
            double sigma = this.sd * (double)a / (0.234 * (double)(i + 1));
            this.setSigma(sigma);
        }
    }

    @Override
    public ProposalDistribution copy() {
        GaussianMultiRandomWalk ret = new GaussianMultiRandomWalk();
        ret.setSigma(this.sd);
        return ret;
    }
}

